/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.gene;

import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.project.Project;
import cgdp.recog.set.AbstractSetUploader;
import cgdp.recog.set.gene.GeneSet;
import cgdp.recog.system.Codec;
import cgdp.recog.system.URLList;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileUtil;

public class GeneSetUploader
extends AbstractSetUploader {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneSetUploader.class);
    private static final String DELIMITER = "\t";
    private GeneSet geneSet;

    public GeneSetUploader(GeneSet geneSet, String string, Project project) throws Exception {
        super(project);
        this.geneSet = geneSet;
        this.setUploadType(string);
        this.setContextPath(URLList.getInstance().getPutGeneSet());
        this.setOptions();
    }

    public void setOptions() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("mode=");
        if (this.uploadType != null) {
            stringBuffer.append(this.uploadType);
        }
        stringBuffer.append("&set_name=");
        stringBuffer.append(Codec.encode(this.geneSet.getName()));
        stringBuffer.append("&set_val=");
        stringBuffer.append(Codec.encode(this.getSetContents()));
        this.setOptions(stringBuffer.toString());
    }

    private String getSetContents() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("sp");
        stringBuffer.append(DELIMITER);
        stringBuffer.append("name");
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        for (GeneInfo geneInfo : this.geneSet.getElementList()) {
            stringBuffer.append(geneInfo.getInfo(GeneInfoTitle.TITLE_ORGANISM_CODE));
            stringBuffer.append(DELIMITER);
            stringBuffer.append(geneInfo.getInfo(GeneInfoTitle.TITLE_LOCUSTAG_SERVER));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        logger.info(stringBuffer.toString());
        return stringBuffer.toString();
    }
}

