/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.venn;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.set.venn.VennClusterListDialog;
import cgdp.recog.set.venn.VennGeneInfoListDialog;
import cgdp.recog.set.venn.VennModel;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.MessageManager;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import java.util.Set;
import javax.swing.JColorChooser;

class VennFacade {
    VennFacade() {
    }

    public static void setColor(Component component, Set set, VennModel vennModel) {
        if (CollectionUtil.isNull(set)) {
            return;
        }
        Set set2 = (Set)set.iterator().next();
        Color color = vennModel.getColor(set2);
        Color color2 = JColorChooser.showDialog(component, "Color palette", color);
        for (Set set3 : set) {
            vennModel.addColorElementSetList(set3, color2);
        }
    }

    public static void removeColor(Set set, VennModel vennModel) {
        for (Set set2 : set) {
            vennModel.removeColor(set2);
        }
    }

    public static void showInfoListDialog(Component component, MediatorImpl mediatorImpl, ClusterTbl clusterTbl, VennModel vennModel, List list) {
        if (CollectionUtil.isNull(list)) {
            String string = vennModel.isGeneSet() ? "There is no genes" : "There is no clusters";
            MessageManager.showMessage(component, string);
            return;
        }
        if (vennModel.isGeneSet()) {
            VennGeneInfoListDialog vennGeneInfoListDialog = VennGeneInfoListDialog.getInstance(component, mediatorImpl);
            vennGeneInfoListDialog.updateValue(list);
            vennGeneInfoListDialog.setVisible(true);
        } else if (vennModel.isClusterSet()) {
            VennClusterListDialog vennClusterListDialog = VennClusterListDialog.getInstance(component, mediatorImpl, clusterTbl);
            vennClusterListDialog.updateValue(list);
            vennClusterListDialog.setVisible(true);
        }
    }

    static String getInfoListButtonLabel(VennModel vennModel) {
        if (vennModel.isClusterSet()) {
            return "Cluster List";
        }
        return "Gene List";
    }

    static String getCreateSetButtonLabel(VennModel vennModel) {
        if (vennModel.isClusterSet()) {
            return "Create cluster set...";
        }
        return "Create gene set...";
    }
}

