/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.venn;

import cgdp.recog.set.AbstractElementSet;
import cgdp.recog.set.AbstractElementSetFacade;
import cgdp.recog.set.venn.VennContext;
import cgdp.recog.set.venn.VennModel;
import cgdp.recog.util.Renderer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.util.HashSet;
import java.util.Set;

class VennRenderer
implements Renderer {
    private VennModel vennModel;
    private VennContext vennContext;

    VennRenderer(VennModel vennModel) {
        this.vennModel = vennModel;
        this.vennContext = new VennContext();
    }

    public void setSize(double d, double d2) {
        this.vennContext.setWidth(d);
        this.vennContext.setHeight(d2);
    }

    public void drawNoDrawString(Graphics2D graphics2D) {
        String string = "Can't draw venn diagram.";
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = fontMetrics.stringWidth(string);
        graphics2D.setColor(Color.black);
        graphics2D.drawString(string, (int)((this.vennContext.getWidth() - (double)n) / 2.0), (int)(this.vennContext.getHeight() / 2.0));
    }

    public void drawSelectedArea(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setFont(this.vennContext.createFont());
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.25f));
        graphics2D.setColor(VennContext.SELECTED_COLOR);
        Set set = this.vennModel.getSelectedAreaSet((int)this.vennContext.getWidth(), (int)this.vennContext.getHeight());
        for (Shape shape : set) {
            graphics2D.fill(shape);
        }
        graphics2D.setComposite(composite);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        this.vennModel.clearAreaElementSetSet();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setFont(this.vennContext.createFont());
        if (this.vennModel.getElementSetSize() == 1) {
            this.vennContext.setRadiusRatio(0.35);
            this.drawOneSet(graphics2D);
        } else if (this.vennModel.getElementSetSize() == 2) {
            this.vennContext.setRadiusRatio(0.3);
            this.drawTwoSet(graphics2D);
        } else if (this.vennModel.getElementSetSize() == 3) {
            this.vennContext.setRadiusRatio(0.25);
            this.drawThreeSet(graphics2D);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }

    private void drawOneSet(Graphics2D graphics2D) {
        this.drawBackground(graphics2D);
        AbstractElementSet abstractElementSet = (AbstractElementSet)this.vennModel.getElementSetList().get(0);
        double d = this.vennContext.getWidth() / 2.0 - this.vennContext.getRadius();
        double d2 = this.vennContext.getHeight() / 2.0 - this.vennContext.getRadius();
        Shape shape = this.drawCircle(graphics2D, d, d2, abstractElementSet);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = fontMetrics.stringWidth(abstractElementSet.getName());
        int n2 = (int)((this.vennContext.getWidth() - (double)n) / 2.0);
        int n3 = (int)(this.vennContext.getHeight() / 2.0 + this.vennContext.getRadius() + (double)fontMetrics.getHeight() * 2.0);
        graphics2D.drawString(abstractElementSet.getName(), n2, n3);
        String string = String.valueOf(abstractElementSet.getElementSize());
        int n4 = fontMetrics.stringWidth(string);
        int n5 = (int)(d + (this.vennContext.getRadius() - (double)n4 / 2.0));
        int n6 = (int)(d2 + this.vennContext.getRadius());
        graphics2D.drawString(string, n5, n6);
        this.vennModel.addAreaElementSet(shape, abstractElementSet);
    }

    private void drawTwoSet(Graphics2D graphics2D) {
        this.drawBackground(graphics2D);
        AbstractElementSet abstractElementSet = (AbstractElementSet)this.vennModel.getElementSetList().get(0);
        AbstractElementSet abstractElementSet2 = (AbstractElementSet)this.vennModel.getElementSetList().get(1);
        double d = (this.vennContext.getWidth() - 3.0 * this.vennContext.getRadius()) / 2.0;
        double d2 = (this.vennContext.getWidth() - this.vennContext.getRadius()) / 2.0;
        double d3 = this.vennContext.getHeight() / 2.0 - this.vennContext.getRadius();
        Shape shape = this.drawCircle(graphics2D, d, d3, abstractElementSet);
        Shape shape2 = this.drawCircle(graphics2D, d2, d3, abstractElementSet2);
        Area area = new Area(shape);
        Area area2 = new Area(shape2);
        area.intersect(area2);
        HashSet hashSet = new HashSet(this.vennModel.getElementSetList());
        this.drawArea(graphics2D, area, hashSet);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = fontMetrics.stringWidth(abstractElementSet.getName());
        int n2 = (int)((this.vennContext.getWidth() - this.vennContext.getRadius()) / 2.0 - (double)n);
        int n3 = (int)(this.vennContext.getHeight() / 2.0 + this.vennContext.getRadius() + (double)fontMetrics.getHeight() * 2.0);
        graphics2D.drawString(abstractElementSet.getName(), n2, n3);
        n2 = (int)((this.vennContext.getWidth() + this.vennContext.getRadius()) / 2.0);
        graphics2D.drawString(abstractElementSet2.getName(), n2, n3);
        AbstractElementSet abstractElementSet3 = AbstractElementSetFacade.intersect(hashSet);
        int n4 = abstractElementSet3.getElementListSize();
        int n5 = abstractElementSet.getElementListSize() - n4;
        int n6 = abstractElementSet2.getElementListSize() - n4;
        String string = String.valueOf(n4);
        int n7 = fontMetrics.stringWidth(string);
        int n8 = (int)(this.vennContext.getWidth() / 2.0 - (double)n7 / 2.0);
        int n9 = (int)(d3 + this.vennContext.getRadius());
        graphics2D.drawString(string, n8, n9);
        string = String.valueOf(n5);
        n7 = fontMetrics.stringWidth(string);
        n8 = (int)(this.vennContext.getWidth() / 2.0 - this.vennContext.getRadius() - (double)n7 / 2.0);
        graphics2D.drawString(string, n8, n9);
        string = String.valueOf(n6);
        n7 = fontMetrics.stringWidth(string);
        n8 = (int)(this.vennContext.getWidth() / 2.0 + this.vennContext.getRadius() - (double)n7 / 2.0);
        graphics2D.drawString(string, n8, n9);
        this.vennModel.addAreaElementSet(shape, abstractElementSet);
        this.vennModel.addAreaElementSet(shape2, abstractElementSet2);
    }

    private void drawThreeSet(Graphics2D graphics2D) {
        this.drawBackground(graphics2D);
        AbstractElementSet abstractElementSet = (AbstractElementSet)this.vennModel.getElementSetList().get(0);
        AbstractElementSet abstractElementSet2 = (AbstractElementSet)this.vennModel.getElementSetList().get(1);
        AbstractElementSet abstractElementSet3 = (AbstractElementSet)this.vennModel.getElementSetList().get(2);
        double d = (this.vennContext.getWidth() - 2.0 * this.vennContext.getRadius()) / 2.0;
        double d2 = (this.vennContext.getWidth() - 3.0 * this.vennContext.getRadius()) / 2.0;
        double d3 = (this.vennContext.getWidth() - this.vennContext.getRadius()) / 2.0;
        double d4 = (this.vennContext.getHeight() - 3.0 * this.vennContext.getRadius()) / 2.0;
        double d5 = (this.vennContext.getHeight() - this.vennContext.getRadius()) / 2.0;
        Shape shape = this.drawCircle(graphics2D, d, d4, abstractElementSet);
        Shape shape2 = this.drawCircle(graphics2D, d2, d5, abstractElementSet2);
        Shape shape3 = this.drawCircle(graphics2D, d3, d5, abstractElementSet3);
        Area area = new Area(shape);
        Area area2 = new Area(shape2);
        Area area3 = new Area(shape3);
        Area area4 = new Area(shape);
        area4.intersect(area2);
        area4.intersect(area3);
        HashSet<AbstractElementSet> hashSet = new HashSet<AbstractElementSet>(this.vennModel.getElementSetList());
        this.drawArea(graphics2D, area4, hashSet);
        AbstractElementSet abstractElementSet4 = AbstractElementSetFacade.intersect(hashSet);
        int n = abstractElementSet4.getElementListSize();
        Area area5 = new Area(shape);
        area5.intersect(area2);
        area5.subtract(area4);
        hashSet = new HashSet();
        hashSet.add(abstractElementSet);
        hashSet.add(abstractElementSet2);
        this.drawArea(graphics2D, area5, hashSet);
        abstractElementSet4 = AbstractElementSetFacade.intersect(hashSet);
        int n2 = abstractElementSet4.getElementListSize() - n;
        Area area6 = new Area(shape2);
        area6.intersect(area3);
        area6.subtract(area4);
        hashSet = new HashSet();
        hashSet.add(abstractElementSet2);
        hashSet.add(abstractElementSet3);
        this.drawArea(graphics2D, area6, hashSet);
        abstractElementSet4 = AbstractElementSetFacade.intersect(hashSet);
        int n3 = abstractElementSet4.getElementListSize() - n;
        Area area7 = new Area(shape3);
        area7.intersect(area);
        area7.subtract(area4);
        hashSet = new HashSet();
        hashSet.add(abstractElementSet);
        hashSet.add(abstractElementSet3);
        this.drawArea(graphics2D, area7, hashSet);
        abstractElementSet4 = AbstractElementSetFacade.intersect(hashSet);
        int n4 = abstractElementSet4.getElementListSize() - n;
        int n5 = abstractElementSet.getElementListSize() - n2 - n4 - n;
        int n6 = abstractElementSet2.getElementListSize() - n2 - n3 - n;
        int n7 = abstractElementSet3.getElementListSize() - n3 - n4 - n;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n8 = fontMetrics.stringWidth(abstractElementSet.getName());
        int n9 = (int)((this.vennContext.getWidth() - (double)n8) / 2.0);
        int n10 = (int)((this.vennContext.getHeight() - this.vennContext.getRadius() * 3.0) / 2.0 - (double)fontMetrics.getHeight());
        graphics2D.drawString(abstractElementSet.getName(), n9, n10);
        n8 = fontMetrics.stringWidth(abstractElementSet2.getName());
        n9 = (int)((this.vennContext.getWidth() - this.vennContext.getRadius()) / 2.0 - (double)n8);
        n10 = (int)((this.vennContext.getHeight() + this.vennContext.getRadius() * 3.0) / 2.0 + (double)fontMetrics.getHeight() * 2.0);
        graphics2D.drawString(abstractElementSet2.getName(), n9, n10);
        n9 = (int)((this.vennContext.getWidth() + this.vennContext.getRadius()) / 2.0);
        graphics2D.drawString(abstractElementSet3.getName(), n9, n10);
        String string = String.valueOf(n);
        int n11 = fontMetrics.stringWidth(string);
        int n12 = (int)(this.vennContext.getWidth() / 2.0 - (double)n11 / 2.0);
        int n13 = (int)(this.vennContext.getHeight() / 2.0 + (double)fontMetrics.getAscent());
        graphics2D.drawString(string, n12, n13);
        string = String.valueOf(n5);
        n11 = fontMetrics.stringWidth(string);
        n12 = (int)(this.vennContext.getWidth() / 2.0 - (double)n11 / 2.0);
        n13 = (int)(this.vennContext.getHeight() / 2.0 - this.vennContext.getRadius() + (double)fontMetrics.getAscent());
        graphics2D.drawString(string, n12, n13);
        string = String.valueOf(n6);
        n11 = fontMetrics.stringWidth(string);
        n12 = (int)(this.vennContext.getWidth() / 2.0 - this.vennContext.getRadius() - (double)n11 / 2.0);
        n13 = (int)(this.vennContext.getHeight() / 2.0 + this.vennContext.getRadius() - (double)fontMetrics.getAscent());
        graphics2D.drawString(string, n12, n13);
        string = String.valueOf(n7);
        n11 = fontMetrics.stringWidth(string);
        n12 = (int)(this.vennContext.getWidth() / 2.0 + this.vennContext.getRadius() - (double)n11 / 2.0);
        n13 = (int)(this.vennContext.getHeight() / 2.0 + this.vennContext.getRadius() - (double)fontMetrics.getAscent());
        graphics2D.drawString(string, n12, n13);
        string = String.valueOf(n2);
        n11 = fontMetrics.stringWidth(string);
        n12 = (int)(this.vennContext.getWidth() / 2.0 - this.vennContext.getRadius() / 2.0 - (double)n11 / 2.0);
        n13 = (int)(this.vennContext.getHeight() / 2.0 - this.vennContext.getRadius() / 4.0 + (double)fontMetrics.getAscent());
        graphics2D.drawString(string, n12, n13);
        string = String.valueOf(n3);
        n11 = fontMetrics.stringWidth(string);
        n12 = (int)(this.vennContext.getWidth() / 2.0 - (double)n11 / 2.0);
        n13 = (int)(this.vennContext.getHeight() / 2.0 + this.vennContext.getRadius() - (double)fontMetrics.getAscent());
        graphics2D.drawString(string, n12, n13);
        string = String.valueOf(n4);
        n11 = fontMetrics.stringWidth(string);
        n12 = (int)(this.vennContext.getWidth() / 2.0 + this.vennContext.getRadius() / 2.0 - (double)n11 / 2.0);
        n13 = (int)(this.vennContext.getHeight() / 2.0 - this.vennContext.getRadius() / 4.0 + (double)fontMetrics.getAscent());
        graphics2D.drawString(string, n12, n13);
        this.vennModel.addAreaElementSet(shape, abstractElementSet);
        this.vennModel.addAreaElementSet(shape2, abstractElementSet2);
        this.vennModel.addAreaElementSet(shape3, abstractElementSet3);
    }

    private void drawBackground(Graphics2D graphics2D) {
        Color color = this.vennModel.getColor(new HashSet());
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, (int)this.vennContext.getWidth(), (int)this.vennContext.getHeight());
    }

    private Shape drawCircle(Graphics2D graphics2D, double d, double d2, AbstractElementSet abstractElementSet) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(d, d2, this.vennContext.getDiameter(), this.vennContext.getDiameter());
        Color color = this.vennModel.getColor(abstractElementSet);
        if (color != null) {
            graphics2D.setColor(color);
            graphics2D.fill(double_);
        } else {
            graphics2D.setColor(VennContext.BACKGROUND_COLOR);
            graphics2D.fill(double_);
        }
        graphics2D.setColor(Color.black);
        graphics2D.draw(double_);
        return double_;
    }

    private void drawArea(Graphics2D graphics2D, Area area, Set set) {
        Color color = this.vennModel.getColor(set);
        if (color == null) {
            color = VennContext.BACKGROUND_COLOR;
        }
        graphics2D.setColor(color);
        graphics2D.fill(area);
        graphics2D.setColor(Color.black);
        graphics2D.draw(area);
    }
}

