/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.sort;

import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.option.ClusterMode;
import cgdp.recog.sort.SortCondition;
import cgdp.recog.sort.SortType;
import java.util.LinkedHashMap;
import java.util.Map;

public class BasicSortCondition
implements SortCondition {
    private int sortType;
    private int inoutType;
    private String sortName;

    @Override
    public int getSortType() {
        return this.sortType;
    }

    public void setSortType(int n) {
        this.sortType = n;
    }

    public boolean isPattern() {
        return SortType.isPattern(this.getSortType());
    }

    public boolean isCluster() {
        return SortType.isCluster(this.getSortType());
    }

    public boolean isGenePosition() {
        return SortType.isGenePosition(this.getSortType());
    }

    public boolean isGeneInfo() {
        return SortType.isGeneInfo(this.getSortType());
    }

    public boolean isPatternCoef() {
        return SortType.isPatternCoef(this.getSortType());
    }

    public boolean isDistanceCluster() {
        return SortType.isDistanceCluster(this.getSortType());
    }

    public boolean isDistancePattern() {
        return SortType.isDistancePattern(this.getSortType());
    }

    @Override
    public int getInoutType() {
        return this.inoutType;
    }

    public void setInoutType(int n) {
        this.inoutType = n;
    }

    public void setSortName(String string) {
        this.sortName = string;
    }

    @Override
    public String getSortName() {
        return this.sortName;
    }

    @Override
    public Map createDisplayOptionMap() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("Name", this.getSortName());
        linkedHashMap.put("Cluster Mode", ClusterMode.getClusterModeName(this.getInoutType()));
        return linkedHashMap;
    }

    public String toString() {
        return "type=" + this.getSortType();
    }

    @Override
    public String getLabel() {
        return this.getSortName();
    }

    @Override
    public boolean containsInfo(AbstractInfoTitle abstractInfoTitle) {
        return false;
    }

    @Override
    public boolean equalsSortCondition(SortCondition sortCondition) {
        if (sortCondition == null) {
            return false;
        }
        if (!(sortCondition instanceof BasicSortCondition)) {
            return false;
        }
        BasicSortCondition basicSortCondition = (BasicSortCondition)sortCondition;
        return this.getSortType() == basicSortCondition.getSortType() && this.getInoutType() == basicSortCondition.getInoutType() && this.getSortName().equals(basicSortCondition.getSortName());
    }

    @Override
    public int getHashCode() {
        int n = 1;
        n = n * 31 + new Integer(this.getSortType()).hashCode();
        n = n * 31 + new Integer(this.getInoutType()).hashCode();
        n = n * 31 + this.getSortName().hashCode();
        return n;
    }
}

