/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.sort;

import cgdp.recog.data.AbstractMultiCluster;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.SuperCluster;
import cgdp.recog.sort.AbstractSortable;
import cgdp.recog.sort.ClusterPoint;
import cgdp.recog.sort.SortException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

class DistanceClusterSortable
extends AbstractSortable {
    private List organismCodeList;
    private Cluster baseCluster;
    private List clusterList;

    DistanceClusterSortable(int n, List list, Cluster cluster, List list2) {
        this.setInoutType(n);
        this.organismCodeList = list;
        this.baseCluster = cluster;
        this.clusterList = list2;
    }

    @Override
    public void sort() throws SortException {
        Object object;
        Iterator iterator;
        Object object2;
        Object object32;
        Cluster cluster = this.baseCluster;
        if (this.isBaseCluster()) {
            cluster = new SuperCluster();
            for (Object object32 : this.clusterList) {
                if (!this.baseCluster.equalsCluster(((Cluster)object32).getClusterId())) continue;
                ((SuperCluster)cluster).addSubCluster((Cluster)object32);
            }
        }
        Object object4 = this.clusterList;
        if (this.isBaseCluster()) {
            object4 = ClusterTbl.createSuperClusterListByCluster(this.clusterList);
        }
        object32 = new ArrayList();
        Object object5 = object4.iterator();
        while (object5.hasNext()) {
            object2 = (Cluster)object5.next();
            if (cluster.equalsCluster((Cluster)object2)) continue;
            object32.add(object2);
        }
        if (this.isCanceled()) {
            return;
        }
        object5 = new ArrayList();
        object2 = object32.iterator();
        while (object2.hasNext()) {
            if (this.isCanceled()) {
                return;
            }
            iterator = (Cluster)object2.next();
            int n = 0;
            for (int i = 0; i < this.organismCodeList.size(); ++i) {
                String string = (String)this.organismCodeList.get(i);
                if (cluster.isExistOrganism(string) && !((Cluster)((Object)iterator)).isExistOrganism(string)) {
                    n += this.getPoint((Cluster)((Object)iterator), i);
                    continue;
                }
                if (cluster.isExistOrganism(string) || !((Cluster)((Object)iterator)).isExistOrganism(string)) continue;
                n += this.getPoint(cluster, i);
            }
            object = new ClusterPoint();
            ((ClusterPoint)object).setObject(iterator);
            ((ClusterPoint)object).setPoint(n);
            object5.add(object);
            this.incrementProgress();
        }
        Collections.sort(object5, new Comparator(){

            public int compare(Object object, Object object2) {
                ClusterPoint clusterPoint = (ClusterPoint)object;
                ClusterPoint clusterPoint2 = (ClusterPoint)object2;
                return clusterPoint.getPoint() - clusterPoint2.getPoint();
            }
        });
        object2 = new ArrayList<Object>();
        if (this.isBaseCluster()) {
            object2.addAll(((SuperCluster)cluster).getSubClusterList());
            iterator = object5.iterator();
            while (iterator.hasNext()) {
                ClusterPoint clusterPoint = (ClusterPoint)iterator.next();
                object = (SuperCluster)clusterPoint.getObject();
                object2.addAll(((AbstractMultiCluster)object).getSubClusterList());
            }
        } else {
            object2.add(cluster);
            iterator = object5.iterator();
            while (iterator.hasNext()) {
                object2.add(((ClusterPoint)iterator.next()).getObject());
            }
        }
        this.setResultClusterList((List)object2);
    }

    private int getPoint(Cluster cluster, int n) {
        int n2;
        int n3;
        int n4 = -1;
        for (n3 = n - 1; n3 >= 0; --n3) {
            if (!cluster.isExistOrganism((String)this.organismCodeList.get(n3))) continue;
            n4 = n3;
            break;
        }
        n3 = this.organismCodeList.size();
        for (n2 = n + 1; n2 < this.organismCodeList.size(); ++n2) {
            if (!cluster.isExistOrganism((String)this.organismCodeList.get(n2))) continue;
            n3 = n2;
            break;
        }
        n2 = 0;
        if (n4 != -1 && n3 != this.organismCodeList.size()) {
            int n5 = Math.abs(n - n4);
            n5 *= n5;
            int n6 = Math.abs(n - n3);
            n2 = n5 < (n6 *= n6) ? n5 : n6;
        } else if (n4 != -1) {
            int n7 = Math.abs(n - n4);
            n2 = n7 * n7;
        } else if (n3 != this.organismCodeList.size()) {
            int n8 = Math.abs(n - n3);
            n2 = n8 * n8;
        }
        return n2;
    }
}

