/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.sort;

import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.SuperCluster;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.EnumComparator;
import cgdp.recog.info.MultiInfoCondition;
import cgdp.recog.info.MultiValueCondition;
import cgdp.recog.info.cell.CellInfoFacade;
import cgdp.recog.info.cell.CellInfoMultiInfoManager;
import cgdp.recog.info.cluster.ClusterInfoCalcCondition;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoMultiInfoManager;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.info.gene.GeneInfoMultiInfoManager;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.sort.AbstractSortable;
import cgdp.recog.sort.GeneInfoSortCondition;
import cgdp.recog.sort.InfoSortCondition;
import cgdp.recog.sort.SortException;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GeneInfoSortable
extends AbstractSortable {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneInfoSortable.class);
    private List clusterList;
    private InfoSortCondition infoSortCondition;
    private Map clusterInfoMap;

    GeneInfoSortable(int n, List list, InfoSortCondition infoSortCondition) {
        this.setInoutType(n);
        this.clusterList = list;
        this.infoSortCondition = infoSortCondition;
    }

    @Override
    public void sort() throws SortException {
        try {
            Object object;
            Object object2;
            Object object3;
            this.setProgressMaxValue();
            List list = this.infoSortCondition.getSortKeyList();
            this.incrementProgress();
            Map map = new HashMap();
            if (this.infoSortCondition.isNeededLoadGeneInfo()) {
                object3 = this.infoSortCondition.getOrganismCode();
                map = GeneInfoFacade.createGeneInfoMap(this.clusterList, (String)object3, list);
            }
            this.incrementProgress();
            object3 = new HashMap();
            if (this.infoSortCondition.isNeededLoadClusterInfo()) {
                object2 = this.infoSortCondition.getClusterInfoCalcCondition();
                object3 = ClusterInfoFacade.createClusterInfoMap(this.clusterList, list, (ClusterInfoCalcCondition)object2);
                this.setClusterInfoMap((Map)object3);
            }
            this.incrementProgress();
            object2 = new HashMap();
            if (this.infoSortCondition.isNeededLoadCellInfo()) {
                object = this.infoSortCondition.getOrganismCode();
                object2 = CellInfoFacade.createClusterCellInfoMap((String)object, this.clusterList, list);
                this.setClusterInfoMap((Map)object3);
            }
            object = new ClusterGeneInfoComparator(this.infoSortCondition, map, (Map)object3, (Map)object2);
            this.incrementProgress();
            List list2 = this.clusterList;
            if (this.isBaseCluster()) {
                list2 = ClusterTbl.createSuperClusterListByCluster(this.clusterList);
                for (SuperCluster superCluster : list2) {
                    if (superCluster.getSubClusterList().size() <= 1) continue;
                    Collections.sort(superCluster.getSubClusterList(), object);
                }
            }
            this.incrementProgress();
            Collections.sort(list2, object);
            this.incrementProgress();
            List list3 = this.createResultClusterList(list2);
            this.setResultClusterList(list3);
            this.incrementProgress();
        }
        catch (Exception exception) {
            String string = "Fail to sort by gene properties.";
            logger.warn(string, exception);
        }
    }

    protected void setProgressMaxValue() {
        ProgressImpl progressImpl = this.getProgressImpl();
        progressImpl.setTotal(7);
    }

    public static int compareValue(MultiValueCondition multiValueCondition, AbstractInfoTitle abstractInfoTitle, Comparable comparable, Comparable comparable2) {
        if (!GeneInfoSortable.isNull(comparable) && GeneInfoSortable.isNull(comparable2)) {
            return -1;
        }
        if (GeneInfoSortable.isNull(comparable) && !GeneInfoSortable.isNull(comparable2)) {
            return 1;
        }
        if (!GeneInfoSortable.isNull(comparable) && !GeneInfoSortable.isNull(comparable2)) {
            int n = 0;
            if (abstractInfoTitle.isCharacter() || abstractInfoTitle.isNumeric()) {
                n = GeneInfoSortable.compareCharNum(multiValueCondition, comparable, comparable2, false);
            } else if (abstractInfoTitle.isEnum()) {
                n = GeneInfoSortable.compareEnum(multiValueCondition, comparable, comparable2, false);
            } else if (abstractInfoTitle.isHierarchy()) {
                n = GeneInfoSortable.compareHierarchy(multiValueCondition, comparable, comparable2, false);
            }
            if (n != 0) {
                return n;
            }
        }
        return 0;
    }

    static int compareCharNum(MultiInfoCondition multiInfoCondition, Comparable comparable, Comparable comparable2) {
        return GeneInfoSortable.compareCharNum(multiInfoCondition, comparable, comparable2, false);
    }

    static int compareCharNum(MultiInfoCondition multiInfoCondition, Comparable comparable, Comparable comparable2, boolean bl) {
        int n = 0;
        n = multiInfoCondition.isAsc() || bl ? comparable.compareTo(comparable2) : comparable2.compareTo(comparable);
        return n;
    }

    static int compareEnum(MultiInfoCondition multiInfoCondition, Comparable comparable, Comparable comparable2) {
        return GeneInfoSortable.compareEnum(multiInfoCondition, comparable, comparable2, false);
    }

    static int compareEnum(MultiInfoCondition multiInfoCondition, Comparable comparable, Comparable comparable2, boolean bl) {
        return EnumComparator.compareEnum(multiInfoCondition, comparable, comparable2, bl);
    }

    public static int compareHierarchy(MultiInfoCondition multiInfoCondition, Comparable comparable, Comparable comparable2) {
        return GeneInfoSortable.compareHierarchy(multiInfoCondition, comparable, comparable2, false);
    }

    static int compareHierarchy(MultiInfoCondition multiInfoCondition, Comparable comparable, Comparable comparable2, boolean bl) {
        List list = GeneInfoTitle.splitHierarchyData((String)((Object)comparable));
        List list2 = GeneInfoTitle.splitHierarchyData((String)((Object)comparable2));
        int n = Math.min(list.size(), list2.size());
        for (int i = 0; i < n; ++i) {
            Comparable comparable3 = (Comparable)list.get(i);
            Comparable comparable4 = (Comparable)list2.get(i);
            int n2 = 0;
            n2 = multiInfoCondition.isAsc() || bl ? comparable3.compareTo(comparable4) : comparable4.compareTo(comparable3);
            if (n2 == 0) continue;
            return n2;
        }
        if (multiInfoCondition.isAsc() || bl) {
            if (list.size() < list2.size()) {
                return -1;
            }
            if (list.size() > list2.size()) {
                return 1;
            }
        } else {
            if (list.size() < list2.size()) {
                return 1;
            }
            if (list.size() > list2.size()) {
                return -1;
            }
        }
        return 0;
    }

    public static int compareValueAsc(MultiValueCondition multiValueCondition, AbstractInfoTitle abstractInfoTitle, Comparable comparable, Comparable comparable2) {
        if (!GeneInfoSortable.isNull(comparable) && GeneInfoSortable.isNull(comparable2)) {
            return -1;
        }
        if (GeneInfoSortable.isNull(comparable) && !GeneInfoSortable.isNull(comparable2)) {
            return 1;
        }
        if (!GeneInfoSortable.isNull(comparable) && !GeneInfoSortable.isNull(comparable2)) {
            int n = 0;
            if (abstractInfoTitle.isCharacter() || abstractInfoTitle.isNumeric()) {
                n = GeneInfoSortable.compareCharNum(multiValueCondition, comparable, comparable2, true);
            } else if (abstractInfoTitle.isEnum()) {
                n = GeneInfoSortable.compareEnum(multiValueCondition, comparable, comparable2, true);
            } else if (abstractInfoTitle.isHierarchy()) {
                n = GeneInfoSortable.compareHierarchy(multiValueCondition, comparable, comparable2, true);
            }
            if (n != 0) {
                return n;
            }
        }
        return 0;
    }

    static Comparable getValue(MultiInfoCondition multiInfoCondition, String string, Map map) {
        return GeneInfoMultiInfoManager.getValue(multiInfoCondition, string, map);
    }

    private static boolean isNull(Comparable comparable) {
        if (comparable instanceof String) {
            return StringTool.isNull((String)((Object)comparable));
        }
        return comparable == null;
    }

    LocusTagComparator createLocusTagComparator(List list, Map map) {
        return new LocusTagComparator(list, map);
    }

    ClusterInfoValueComparator createClusterInfoValueComparator(List list, Map map) {
        return new ClusterInfoValueComparator(list, map);
    }

    protected InfoSortCondition getInfoSortCondition() {
        return this.infoSortCondition;
    }

    private void setClusterInfoMap(Map map) {
        this.clusterInfoMap = map;
    }

    public Map getClusterInfoMap() {
        return this.clusterInfoMap;
    }

    class ClusterInfoValueComparator
    implements Comparator {
        private List conditionList;
        private Map clusterInfoMap;

        ClusterInfoValueComparator(List list, Map map) {
            this.conditionList = list;
            this.clusterInfoMap = map;
        }

        ClusterInfoValueComparator(GeneInfoSortCondition geneInfoSortCondition, Map map) {
            this.conditionList = new ArrayList();
            this.conditionList.add(geneInfoSortCondition);
            this.clusterInfoMap = map;
        }

        public int compare(Object object, Object object2) {
            Cluster cluster = (Cluster)object;
            Cluster cluster2 = (Cluster)object2;
            for (GeneInfoSortCondition geneInfoSortCondition : this.conditionList) {
                Comparable comparable = ClusterInfoMultiInfoManager.getValue((MultiInfoCondition)geneInfoSortCondition, cluster, this.clusterInfoMap);
                Comparable comparable2 = ClusterInfoMultiInfoManager.getValue((MultiInfoCondition)geneInfoSortCondition, cluster2, this.clusterInfoMap);
                int n = GeneInfoSortable.compareValue(geneInfoSortCondition, geneInfoSortCondition.getInfoTitle(), comparable, comparable2);
                if (n == 0) continue;
                return n;
            }
            return 0;
        }
    }

    class LocusTagComparator
    implements Comparator {
        private List conditionList;
        private Map geneInfoMap;

        public LocusTagComparator(List list, Map map) {
            this.conditionList = list;
            this.geneInfoMap = map;
        }

        public LocusTagComparator(GeneInfoSortCondition geneInfoSortCondition, Map map) {
            this.conditionList = new ArrayList();
            this.conditionList.add(geneInfoSortCondition);
            this.geneInfoMap = map;
        }

        public int compare(Object object, Object object2) {
            String string = (String)object;
            String string2 = (String)object2;
            for (GeneInfoSortCondition geneInfoSortCondition : this.conditionList) {
                Comparable comparable = GeneInfoSortable.getValue(geneInfoSortCondition, string, this.geneInfoMap);
                Comparable comparable2 = GeneInfoSortable.getValue(geneInfoSortCondition, string2, this.geneInfoMap);
                int n = GeneInfoSortable.compareValueAsc(geneInfoSortCondition, geneInfoSortCondition.getInfoTitle(), comparable, comparable2);
                if (n == 0) continue;
                return n;
            }
            return 0;
        }
    }

    private class ClusterGeneInfoComparator
    implements Comparator {
        private InfoSortCondition infoSortCondition;
        private Map geneInfoMap;
        private Map clusterInfoMap;
        private Map cellInfoMap;

        public ClusterGeneInfoComparator(InfoSortCondition infoSortCondition, Map map, Map map2, Map map3) {
            this.infoSortCondition = infoSortCondition;
            this.geneInfoMap = map;
            this.clusterInfoMap = map2;
            this.cellInfoMap = map3;
        }

        public int compare(Object object, Object object2) {
            Cluster cluster = (Cluster)object;
            Cluster cluster2 = (Cluster)object2;
            for (GeneInfoSortCondition geneInfoSortCondition : this.infoSortCondition.getGeneInfoSortConditionList()) {
                int n = 0;
                n = geneInfoSortCondition.isGene() ? this.compareForGene(geneInfoSortCondition, cluster, cluster2) : (geneInfoSortCondition.isCell() ? this.compareForCell(geneInfoSortCondition, cluster, cluster2) : this.compareForCluster(geneInfoSortCondition, cluster, cluster2));
                if (n == 0) continue;
                return n;
            }
            return 0;
        }

        private int compareForCluster(GeneInfoSortCondition geneInfoSortCondition, Cluster cluster, Cluster cluster2) {
            Comparable comparable = this.getRepresentativeClusterValue(geneInfoSortCondition, cluster);
            Comparable comparable2 = this.getRepresentativeClusterValue(geneInfoSortCondition, cluster2);
            return GeneInfoSortable.compareValue(geneInfoSortCondition, geneInfoSortCondition.getInfoTitle(), comparable, comparable2);
        }

        private Comparable getRepresentativeClusterValue(GeneInfoSortCondition geneInfoSortCondition, Cluster cluster) {
            return ClusterInfoMultiInfoManager.getRepresentativeValue(geneInfoSortCondition, cluster, new ClusterInfoValueComparator(geneInfoSortCondition, this.clusterInfoMap), this.clusterInfoMap);
        }

        private int compareForGene(GeneInfoSortCondition geneInfoSortCondition, Cluster cluster, Cluster cluster2) {
            String string = this.infoSortCondition.getOrganismCode();
            List list = cluster.getLocusTagWithoutDomainList(string);
            List list2 = cluster2.getLocusTagWithoutDomainList(string);
            if (!CollectionUtil.isNull(list) && CollectionUtil.isNull(list2)) {
                return -1;
            }
            if (CollectionUtil.isNull(list) && !CollectionUtil.isNull(list2)) {
                return 1;
            }
            if (CollectionUtil.isNull(list) && CollectionUtil.isNull(list2)) {
                return 0;
            }
            Comparable comparable = this.getRepresentativeValue(geneInfoSortCondition, list);
            Comparable comparable2 = this.getRepresentativeValue(geneInfoSortCondition, list2);
            return GeneInfoSortable.compareValue(geneInfoSortCondition, geneInfoSortCondition.getInfoTitle(), comparable, comparable2);
        }

        private Comparable getRepresentativeValue(GeneInfoSortCondition geneInfoSortCondition, List list) {
            return GeneInfoMultiInfoManager.getRepresentativeValue(geneInfoSortCondition, list, new LocusTagComparator(geneInfoSortCondition, this.geneInfoMap), this.geneInfoMap);
        }

        private int compareForCell(GeneInfoSortCondition geneInfoSortCondition, Cluster cluster, Cluster cluster2) {
            Comparable comparable = this.getRepresentativeCellValue(geneInfoSortCondition, cluster);
            Comparable comparable2 = this.getRepresentativeCellValue(geneInfoSortCondition, cluster2);
            return GeneInfoSortable.compareValue(geneInfoSortCondition, geneInfoSortCondition.getInfoTitle(), comparable, comparable2);
        }

        private Comparable getRepresentativeCellValue(GeneInfoSortCondition geneInfoSortCondition, Cluster cluster) {
            return CellInfoMultiInfoManager.getRepresentativeValue(geneInfoSortCondition, cluster, this.cellInfoMap);
        }
    }
}

