/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.sort;

import cgdp.recog.calc.CoefCondition;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.SuperCluster;
import cgdp.recog.funccat.FuncCatTbl;
import cgdp.recog.funccat.FunctionCategoryType;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.cluster.ClusterInfoCalcCondition;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.info.cluster.ClusterInfoUtil;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.option.ClusterMode;
import cgdp.recog.ppm.PPMLabelCondition;
import cgdp.recog.ppm.PPMLabelLocation;
import cgdp.recog.ppm.PPMLabelType;
import cgdp.recog.sort.BasicSortCondition;
import cgdp.recog.sort.GeneInfoSortCondition;
import cgdp.recog.sort.GeneInfoSortConditionGroup;
import java.util.List;

public class SortConditionFactory {
    public static BasicSortCondition createPatternCondition(int n, List list) {
        GeneInfoSortCondition geneInfoSortCondition = new GeneInfoSortCondition();
        geneInfoSortCondition.setInfoTitle(SortConditionFactory.getPatternTitle(n));
        geneInfoSortCondition.setOrder(2);
        GeneInfoSortCondition geneInfoSortCondition2 = new GeneInfoSortCondition();
        geneInfoSortCondition2.setInfoTitle(SortConditionFactory.getFuncCatTitle(n));
        geneInfoSortCondition2.setOrder(1);
        GeneInfoSortCondition geneInfoSortCondition3 = new GeneInfoSortCondition();
        geneInfoSortCondition3.setInfoTitle(SortConditionFactory.getGeneCountTitle(n));
        geneInfoSortCondition3.setOrder(2);
        GeneInfoSortCondition geneInfoSortCondition4 = new GeneInfoSortCondition();
        geneInfoSortCondition4.setInfoTitle(SortConditionFactory.getClusterIDTitle());
        geneInfoSortCondition4.setOrder(1);
        GeneInfoSortConditionGroup geneInfoSortConditionGroup = new GeneInfoSortConditionGroup();
        geneInfoSortConditionGroup.setInoutType(ClusterMode.getClusterMode());
        geneInfoSortConditionGroup.addCondition(geneInfoSortCondition);
        geneInfoSortConditionGroup.addCondition(geneInfoSortCondition2);
        geneInfoSortConditionGroup.addCondition(geneInfoSortCondition3);
        geneInfoSortConditionGroup.addCondition(geneInfoSortCondition4);
        ClusterInfoCalcCondition clusterInfoCalcCondition = new ClusterInfoCalcCondition();
        clusterInfoCalcCondition.setOrganismCodeList(list);
        geneInfoSortConditionGroup.setClusterInfoCalcCondition(clusterInfoCalcCondition);
        geneInfoSortConditionGroup.setSortName("Phylogenetic pattern (lexical order)");
        if (ClusterMode.isBaseCluster(n)) {
            GeneInfoSortCondition geneInfoSortCondition5 = new GeneInfoSortCondition();
            geneInfoSortCondition5.setInfoTitle(ClusterInfoFacade.getInfoTitle("subclusterid"));
            geneInfoSortCondition5.setOrder(1);
            geneInfoSortConditionGroup.addCondition(geneInfoSortCondition5);
        }
        return geneInfoSortConditionGroup;
    }

    public static BasicSortCondition createFrequencyClusterCondition(int n) {
        return SortConditionFactory.createCondition(1, n, "Phylogenetic pattern frequency");
    }

    private static BasicSortCondition createCondition(int n, int n2, String string) {
        BasicSortCondition basicSortCondition = new BasicSortCondition();
        basicSortCondition.setSortType(n);
        basicSortCondition.setInoutType(n2);
        basicSortCondition.setSortName(string);
        return basicSortCondition;
    }

    public static BasicSortCondition createPatternCoefClusteringCondition(int n, Cluster cluster, List list, CoefCondition coefCondition, boolean bl) {
        GeneInfoSortCondition geneInfoSortCondition = new GeneInfoSortCondition();
        geneInfoSortCondition.setInfoTitle(ClusterInfoUtil.getPatternCoefTitle(n));
        if (coefCondition.getDistType() == 3) {
            geneInfoSortCondition.setOrder(2);
        } else {
            geneInfoSortCondition.setOrder(1);
        }
        GeneInfoSortCondition geneInfoSortCondition2 = new GeneInfoSortCondition();
        geneInfoSortCondition2.setInfoTitle(SortConditionFactory.getPatternTitle(n));
        geneInfoSortCondition2.setOrder(1);
        GeneInfoSortCondition geneInfoSortCondition3 = new GeneInfoSortCondition();
        geneInfoSortCondition3.setInfoTitle(ClusterInfoFacade.getInfoTitle("clusterid"));
        geneInfoSortCondition3.setOrder(1);
        GeneInfoSortConditionGroup geneInfoSortConditionGroup = new GeneInfoSortConditionGroup();
        geneInfoSortConditionGroup.setInoutType(ClusterMode.getClusterMode());
        geneInfoSortConditionGroup.addCondition(geneInfoSortCondition);
        geneInfoSortConditionGroup.addCondition(geneInfoSortCondition2);
        geneInfoSortConditionGroup.addCondition(geneInfoSortCondition3);
        ClusterInfoCalcCondition clusterInfoCalcCondition = new ClusterInfoCalcCondition();
        clusterInfoCalcCondition.setOrganismCodeList(list);
        clusterInfoCalcCondition.setBaseCluster(cluster);
        clusterInfoCalcCondition.setCoefCondition(coefCondition);
        geneInfoSortConditionGroup.setClusterInfoCalcCondition(clusterInfoCalcCondition);
        geneInfoSortConditionGroup.setSortType(7);
        String string = cluster instanceof SuperCluster ? "Phylogenetic pattern similarity based on the cluster " : "Phylogenetic pattern similarity based on the cluster " + cluster.getClusterId();
        geneInfoSortConditionGroup.setSortName(string);
        if (bl) {
            GeneInfoSortCondition geneInfoSortCondition4 = new GeneInfoSortCondition();
            geneInfoSortCondition4.setInfoTitle(ClusterInfoFacade.getInfoTitle("subclusterid"));
            geneInfoSortCondition4.setOrder(1);
            geneInfoSortConditionGroup.addCondition(geneInfoSortCondition4);
        }
        return geneInfoSortConditionGroup;
    }

    public static GeneInfoSortConditionGroup createHomClustIdConditionGroup(boolean bl) {
        return SortConditionFactory.createHomClustIdConditionGroup(bl, 1);
    }

    public static GeneInfoSortConditionGroup createHomClustIdConditionGroup(boolean bl, int n) {
        GeneInfoSortCondition geneInfoSortCondition = new GeneInfoSortCondition();
        geneInfoSortCondition.setInfoTitle(ClusterInfoFacade.getInfoTitle("homclusterid"));
        geneInfoSortCondition.setOrder(n);
        GeneInfoSortCondition geneInfoSortCondition2 = new GeneInfoSortCondition();
        geneInfoSortCondition2.setInfoTitle(ClusterInfoFacade.getInfoTitle("clusterid"));
        geneInfoSortCondition2.setOrder(n);
        GeneInfoSortConditionGroup geneInfoSortConditionGroup = new GeneInfoSortConditionGroup();
        geneInfoSortConditionGroup.setInoutType(ClusterMode.getClusterMode());
        geneInfoSortConditionGroup.addCondition(geneInfoSortCondition);
        geneInfoSortConditionGroup.addCondition(geneInfoSortCondition2);
        geneInfoSortConditionGroup.setSortName("Homology cluster ID");
        if (bl) {
            GeneInfoSortCondition geneInfoSortCondition3 = new GeneInfoSortCondition();
            geneInfoSortCondition3.setInfoTitle(ClusterInfoFacade.getInfoTitle("subclusterid"));
            geneInfoSortCondition3.setOrder(n);
            geneInfoSortConditionGroup.addCondition(geneInfoSortCondition3);
        }
        return geneInfoSortConditionGroup;
    }

    public static GeneInfoSortConditionGroup createClustIdConditionGroup(boolean bl) {
        return SortConditionFactory.createClustIdConditionGroup(bl, 1);
    }

    public static GeneInfoSortConditionGroup createClustIdConditionGroup(boolean bl, int n) {
        GeneInfoSortCondition geneInfoSortCondition = new GeneInfoSortCondition();
        geneInfoSortCondition.setInfoTitle(ClusterInfoFacade.getInfoTitle("clusterid"));
        geneInfoSortCondition.setOrder(n);
        GeneInfoSortConditionGroup geneInfoSortConditionGroup = new GeneInfoSortConditionGroup();
        geneInfoSortConditionGroup.setInoutType(2);
        geneInfoSortConditionGroup.addCondition(geneInfoSortCondition);
        geneInfoSortConditionGroup.setSortName("Cluster ID");
        if (bl) {
            GeneInfoSortCondition geneInfoSortCondition2 = new GeneInfoSortCondition();
            geneInfoSortCondition2.setInfoTitle(ClusterInfoFacade.getInfoTitle("subclusterid"));
            geneInfoSortCondition2.setOrder(n);
            geneInfoSortConditionGroup.addCondition(geneInfoSortCondition2);
        }
        return geneInfoSortConditionGroup;
    }

    public static GeneInfoSortConditionGroup createScoreConditionGroup(int n, boolean bl) {
        return SortConditionFactory.createScoreConditionGroup(n, bl, 1);
    }

    public static GeneInfoSortConditionGroup createScoreConditionGroup(int n, boolean bl, int n2) {
        GeneInfoSortCondition geneInfoSortCondition = new GeneInfoSortCondition();
        geneInfoSortCondition.setInfoTitle(PPMLabelLocation.getScoreTitle(n, bl));
        geneInfoSortCondition.setOrder(n2);
        GeneInfoSortCondition geneInfoSortCondition2 = new GeneInfoSortCondition();
        geneInfoSortCondition2.setInfoTitle(ClusterInfoFacade.getInfoTitle("clusterid"));
        geneInfoSortCondition2.setOrder(1);
        GeneInfoSortConditionGroup geneInfoSortConditionGroup = new GeneInfoSortConditionGroup();
        geneInfoSortConditionGroup.setInoutType(ClusterMode.getClusterMode());
        geneInfoSortConditionGroup.addCondition(geneInfoSortCondition);
        geneInfoSortConditionGroup.addCondition(geneInfoSortCondition2);
        geneInfoSortConditionGroup.setSortName("Score");
        if (bl) {
            GeneInfoSortCondition geneInfoSortCondition3 = new GeneInfoSortCondition();
            geneInfoSortCondition3.setInfoTitle(ClusterInfoFacade.getInfoTitle("subclusterid"));
            geneInfoSortCondition3.setOrder(1);
            geneInfoSortConditionGroup.addCondition(geneInfoSortCondition3);
        }
        return geneInfoSortConditionGroup;
    }

    public static GeneInfoSortConditionGroup createDistConditionGroup(int n, boolean bl) {
        return SortConditionFactory.createDistConditionGroup(n, bl, 1);
    }

    public static GeneInfoSortConditionGroup createDistConditionGroup(int n, boolean bl, int n2) {
        GeneInfoSortCondition geneInfoSortCondition = new GeneInfoSortCondition();
        geneInfoSortCondition.setInfoTitle(PPMLabelLocation.getDistTitle(n, bl));
        geneInfoSortCondition.setOrder(n2);
        GeneInfoSortCondition geneInfoSortCondition2 = new GeneInfoSortCondition();
        geneInfoSortCondition2.setInfoTitle(ClusterInfoFacade.getInfoTitle("clusterid"));
        geneInfoSortCondition2.setOrder(1);
        GeneInfoSortConditionGroup geneInfoSortConditionGroup = new GeneInfoSortConditionGroup();
        geneInfoSortConditionGroup.setInoutType(ClusterMode.getClusterMode());
        geneInfoSortConditionGroup.addCondition(geneInfoSortCondition);
        geneInfoSortConditionGroup.addCondition(geneInfoSortCondition2);
        geneInfoSortConditionGroup.setSortName("Dist");
        if (bl) {
            GeneInfoSortCondition geneInfoSortCondition3 = new GeneInfoSortCondition();
            geneInfoSortCondition3.setInfoTitle(ClusterInfoFacade.getInfoTitle("subclusterid"));
            geneInfoSortCondition3.setOrder(1);
            geneInfoSortConditionGroup.addCondition(geneInfoSortCondition3);
        }
        return geneInfoSortConditionGroup;
    }

    public static GeneInfoSortConditionGroup createTemplatePhpatCondition(int n) {
        GeneInfoSortCondition geneInfoSortCondition = new GeneInfoSortCondition();
        geneInfoSortCondition.setInfoTitle(SortConditionFactory.getPhpatOrderTitle(n));
        geneInfoSortCondition.setOrder(1);
        GeneInfoSortCondition geneInfoSortCondition2 = new GeneInfoSortCondition();
        geneInfoSortCondition2.setInfoTitle(SortConditionFactory.getFuncCatTitle(n));
        geneInfoSortCondition2.setOrder(1);
        GeneInfoSortCondition geneInfoSortCondition3 = new GeneInfoSortCondition();
        geneInfoSortCondition3.setInfoTitle(SortConditionFactory.getGeneNameTitle(n));
        geneInfoSortCondition3.setOrder(1);
        GeneInfoSortCondition geneInfoSortCondition4 = new GeneInfoSortCondition();
        geneInfoSortCondition4.setInfoTitle(SortConditionFactory.getClusterIDTitle());
        geneInfoSortCondition4.setOrder(1);
        GeneInfoSortConditionGroup geneInfoSortConditionGroup = new GeneInfoSortConditionGroup();
        geneInfoSortConditionGroup.setInoutType(n);
        geneInfoSortConditionGroup.addCondition(geneInfoSortCondition);
        geneInfoSortConditionGroup.addCondition(geneInfoSortCondition2);
        geneInfoSortConditionGroup.addCondition(geneInfoSortCondition3);
        geneInfoSortConditionGroup.addCondition(geneInfoSortCondition4);
        geneInfoSortConditionGroup.setSortName("Category/gene name");
        if (ClusterMode.isBaseCluster(n)) {
            GeneInfoSortCondition geneInfoSortCondition5 = new GeneInfoSortCondition();
            geneInfoSortCondition5.setInfoTitle(ClusterInfoFacade.getInfoTitle("subclusterid"));
            geneInfoSortCondition5.setOrder(1);
            geneInfoSortConditionGroup.addCondition(geneInfoSortCondition5);
        }
        return geneInfoSortConditionGroup;
    }

    public static GeneInfoSortConditionGroup createFuncCatGeneNameConditionGroup(int n) {
        return SortConditionFactory.createFuncCatGeneNameConditionGroup(n, 1);
    }

    public static GeneInfoSortConditionGroup createFuncCatGeneNameConditionGroup(int n, int n2) {
        GeneInfoSortCondition geneInfoSortCondition = new GeneInfoSortCondition();
        geneInfoSortCondition.setInfoTitle(SortConditionFactory.getFuncCatTitle(n));
        geneInfoSortCondition.setOrder(n2);
        GeneInfoSortCondition geneInfoSortCondition2 = new GeneInfoSortCondition();
        geneInfoSortCondition2.setInfoTitle(SortConditionFactory.getGeneNameTitle(n));
        geneInfoSortCondition2.setOrder(n2);
        GeneInfoSortCondition geneInfoSortCondition3 = new GeneInfoSortCondition();
        geneInfoSortCondition3.setInfoTitle(SortConditionFactory.getClusterIDTitle());
        geneInfoSortCondition3.setOrder(1);
        GeneInfoSortConditionGroup geneInfoSortConditionGroup = new GeneInfoSortConditionGroup();
        geneInfoSortConditionGroup.setInoutType(n);
        geneInfoSortConditionGroup.addCondition(geneInfoSortCondition);
        geneInfoSortConditionGroup.addCondition(geneInfoSortCondition2);
        geneInfoSortConditionGroup.addCondition(geneInfoSortCondition3);
        geneInfoSortConditionGroup.setSortName("Category/gene name");
        if (ClusterMode.isBaseCluster(n)) {
            GeneInfoSortCondition geneInfoSortCondition4 = new GeneInfoSortCondition();
            geneInfoSortCondition4.setInfoTitle(ClusterInfoFacade.getInfoTitle("subclusterid"));
            geneInfoSortCondition4.setOrder(1);
            geneInfoSortConditionGroup.addCondition(geneInfoSortCondition4);
        }
        return geneInfoSortConditionGroup;
    }

    private static AbstractInfoTitle getPatternTitle(int n) {
        ClusterInfoTitle clusterInfoTitle = ClusterMode.isBaseCluster(n) ? ClusterInfoFacade.getInfoTitle("CPattern") : ClusterInfoFacade.getInfoTitle("SCPattern");
        return clusterInfoTitle;
    }

    private static AbstractInfoTitle getGeneCountTitle(int n) {
        ClusterInfoTitle clusterInfoTitle = ClusterMode.isBaseCluster(n) ? ClusterInfoFacade.getInfoTitle("CGeneCount") : ClusterInfoFacade.getInfoTitle("SCGeneCount");
        return clusterInfoTitle;
    }

    private static AbstractInfoTitle getFuncCatTitle(int n) {
        AbstractInfoTitle abstractInfoTitle = ClusterMode.isBaseCluster(n) ? SortConditionFactory.getClusterFuncCatTitle() : SortConditionFactory.getSubClusterFuncCatTitle();
        return abstractInfoTitle;
    }

    private static AbstractInfoTitle getClusterFuncCatTitle() {
        String string = FuncCatTbl.getInstance().getFunctionCategoryType();
        ClusterInfoTitle clusterInfoTitle = FunctionCategoryType.isKEGG(string) ? ClusterInfoFacade.getInfoTitle("CFuncKegg") : (FunctionCategoryType.isCOG(string) ? ClusterInfoFacade.getInfoTitle("CFuncCog") : (FunctionCategoryType.isTIGR(string) ? ClusterInfoFacade.getInfoTitle("CFuncTigr") : ClusterInfoFacade.getInfoTitle("CFuncMbgd")));
        return clusterInfoTitle;
    }

    private static AbstractInfoTitle getSubClusterFuncCatTitle() {
        String string = FuncCatTbl.getInstance().getFunctionCategoryType();
        ClusterInfoTitle clusterInfoTitle = FunctionCategoryType.isKEGG(string) ? ClusterInfoFacade.getInfoTitle("SCFuncKegg") : (FunctionCategoryType.isCOG(string) ? ClusterInfoFacade.getInfoTitle("SCFuncCog") : (FunctionCategoryType.isTIGR(string) ? ClusterInfoFacade.getInfoTitle("SCFuncTigr") : ClusterInfoFacade.getInfoTitle("SCFuncMbgd")));
        return clusterInfoTitle;
    }

    private static AbstractInfoTitle getGeneNameTitle(int n) {
        ClusterInfoTitle clusterInfoTitle = ClusterMode.isBaseCluster(n) ? ClusterInfoFacade.getInfoTitle("CGene") : ClusterInfoFacade.getInfoTitle("SCGene");
        return clusterInfoTitle;
    }

    private static AbstractInfoTitle getClusterIDTitle() {
        ClusterInfoTitle clusterInfoTitle = ClusterMode.isClusterMode() ? ClusterInfoFacade.getInfoTitle("clusterid") : ClusterInfoFacade.getInfoTitle("subclusterid");
        return clusterInfoTitle;
    }

    public static AbstractInfoTitle getPhpatOrderTitle(int n) {
        ClusterInfoTitle clusterInfoTitle = ClusterMode.isBaseCluster(n) ? ClusterInfoFacade.getInfoTitle("CPhpatOrder") : ClusterInfoFacade.getInfoTitle("SCPhpatOrder");
        return clusterInfoTitle;
    }

    public static GeneInfoSortConditionGroup createGenePositionConditionGroup(String string, int n) {
        return SortConditionFactory.createGenePositionConditionGroup(string, n, 1);
    }

    public static String getGenePositionConditionGroupName(String string) {
        return "Gene order on " + string;
    }

    public static GeneInfoSortConditionGroup createGenePositionConditionGroup(String string, int n, int n2) {
        GeneInfoSortCondition geneInfoSortCondition = new GeneInfoSortCondition();
        geneInfoSortCondition.setInfoTitle(GeneInfoTitle.TITLE_CHRID);
        geneInfoSortCondition.setOrder(n2);
        GeneInfoSortCondition geneInfoSortCondition2 = new GeneInfoSortCondition();
        geneInfoSortCondition2.setInfoTitle(GeneInfoTitle.TITLE_CONTIGID);
        geneInfoSortCondition2.setOrder(n2);
        GeneInfoSortCondition geneInfoSortCondition3 = new GeneInfoSortCondition();
        geneInfoSortCondition3.setInfoTitle(GeneInfoTitle.TITLE_START);
        geneInfoSortCondition3.setOrder(n2);
        geneInfoSortCondition3.setMultiInfoType(2);
        geneInfoSortCondition3.setMultiElementType(2);
        GeneInfoSortCondition geneInfoSortCondition4 = new GeneInfoSortCondition();
        geneInfoSortCondition4.setInfoTitle(SortConditionFactory.getClusterIDTitle());
        geneInfoSortCondition4.setOrder(1);
        GeneInfoSortConditionGroup geneInfoSortConditionGroup = new GeneInfoSortConditionGroup();
        geneInfoSortConditionGroup.setOrganismCode(string);
        geneInfoSortConditionGroup.setInoutType(ClusterMode.getClusterMode());
        geneInfoSortConditionGroup.addCondition(geneInfoSortCondition);
        geneInfoSortConditionGroup.addCondition(geneInfoSortCondition2);
        geneInfoSortConditionGroup.addCondition(geneInfoSortCondition3);
        geneInfoSortConditionGroup.addCondition(geneInfoSortCondition4);
        geneInfoSortConditionGroup.setSortName(SortConditionFactory.getGenePositionConditionGroupName(string));
        if (ClusterMode.isBaseCluster(n)) {
            GeneInfoSortCondition geneInfoSortCondition5 = new GeneInfoSortCondition();
            geneInfoSortCondition5.setInfoTitle(ClusterInfoFacade.getInfoTitle("subclusterid"));
            geneInfoSortCondition5.setOrder(1);
            geneInfoSortConditionGroup.addCondition(geneInfoSortCondition5);
        }
        return geneInfoSortConditionGroup;
    }

    public static GeneInfoSortConditionGroup createInfoConditionGroup(String string, AbstractInfoTitle abstractInfoTitle) {
        return SortConditionFactory.createInfoConditionGroup(string, abstractInfoTitle, 1);
    }

    public static GeneInfoSortConditionGroup createInfoConditionGroup(String string, AbstractInfoTitle abstractInfoTitle, int n) {
        GeneInfoSortCondition geneInfoSortCondition = new GeneInfoSortCondition();
        geneInfoSortCondition.setInfoTitle(abstractInfoTitle);
        geneInfoSortCondition.setOrder(n);
        GeneInfoSortConditionGroup geneInfoSortConditionGroup = new GeneInfoSortConditionGroup();
        geneInfoSortConditionGroup.setOrganismCode(string);
        geneInfoSortConditionGroup.setInoutType(ClusterMode.getClusterMode());
        geneInfoSortConditionGroup.addCondition(geneInfoSortCondition);
        geneInfoSortConditionGroup.setSortName(abstractInfoTitle.getName());
        return geneInfoSortConditionGroup;
    }

    public static String createConditionByPPMLabelName(PPMLabelCondition pPMLabelCondition, int n) {
        int n2 = pPMLabelCondition.getPpmLabelType();
        if (PPMLabelType.isClusterId(n2)) {
            if (PPMLabelLocation.isHomCluster(n)) {
                return "Homology cluster ID";
            }
            return "Cluster ID";
        }
        if (PPMLabelType.isClusterGeneName(n2)) {
            if (PPMLabelLocation.isHomCluster(n)) {
                return "Homology cluster ID";
            }
            return "Category/gene name";
        }
        if (PPMLabelType.isClusterScore(n2)) {
            return "Score";
        }
        if (PPMLabelType.isClusterDist(n2)) {
            return "Dist";
        }
        ClusterInfoTitle clusterInfoTitle = PPMLabelLocation.isLeft(n) ? pPMLabelCondition.getSubClusterInfoTitle() : pPMLabelCondition.getClusterInfoTitle();
        return clusterInfoTitle.getName();
    }

    public static BasicSortCondition createConditionByPPMLabel(boolean bl, PPMLabelCondition pPMLabelCondition, int n, int n2) {
        int n3 = SortConditionFactory.getInoutTypeByPPMLabelLocation(n, bl);
        int n4 = pPMLabelCondition.getPpmLabelType();
        if (PPMLabelType.isClusterId(n4)) {
            if (PPMLabelLocation.isHomCluster(n)) {
                return SortConditionFactory.createHomClustIdConditionGroup(bl, n2);
            }
            return SortConditionFactory.createClustIdConditionGroup(bl, n2);
        }
        if (PPMLabelType.isClusterGeneName(n4)) {
            if (PPMLabelLocation.isHomCluster(n)) {
                return SortConditionFactory.createHomClustIdConditionGroup(bl, n2);
            }
            return SortConditionFactory.createFuncCatGeneNameConditionGroup(n3, n2);
        }
        if (PPMLabelType.isClusterScore(n4)) {
            return SortConditionFactory.createScoreConditionGroup(n, bl, n2);
        }
        if (PPMLabelType.isClusterDist(n4)) {
            return SortConditionFactory.createDistConditionGroup(n, bl, n2);
        }
        ClusterInfoTitle clusterInfoTitle = PPMLabelLocation.isLeft(n) ? pPMLabelCondition.getSubClusterInfoTitle() : pPMLabelCondition.getClusterInfoTitle();
        return SortConditionFactory.createInfoConditionGroup(null, clusterInfoTitle, n2);
    }

    private static int getInoutTypeByPPMLabelLocation(int n, boolean bl) {
        if (PPMLabelLocation.isLeft(n) && bl) {
            return 1;
        }
        return 2;
    }
}

