/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.sort;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.hcluster.HClustItem;
import cgdp.recog.option.ClusterMode;
import cgdp.recog.sort.ClusterSortItem;
import cgdp.recog.sort.GeneInfoSortItem;
import cgdp.recog.sort.HomClusterIdSortItem;
import cgdp.recog.sort.OrderByCategoryItem;
import cgdp.recog.sort.OrderByClusterItem;
import cgdp.recog.sort.OrderByPatternItem;
import cgdp.recog.sort.PatternCoefMenu;
import cgdp.recog.util.JLicenserTool;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JMenu;

public class SortMenuFactory {
    public static JMenu createSortMenuForDisaggregate(ActionListener actionListener, MediatorImpl mediatorImpl, ClusterTbl clusterTbl, Cluster cluster, String string) {
        JMenu jMenu = SortMenuFactory.createSortMenu();
        jMenu.add(new OrderByCategoryItem(actionListener, mediatorImpl, ClusterMode.getClusterMode(), "Category/gene name"));
        if (string != null) {
            jMenu.add(new ClusterSortItem(actionListener, mediatorImpl, ClusterMode.getClusterMode(), string));
        }
        jMenu.add(new OrderByPatternItem(actionListener, mediatorImpl, ClusterMode.getClusterMode(), clusterTbl.getViewOrganismCodeList()));
        if (cluster != null) {
            jMenu.add(new PatternCoefMenu(actionListener, mediatorImpl, ClusterMode.getClusterMode(), cluster, "Phylogenetic pattern similarity based on the cluster " + cluster.getClusterId()));
        }
        jMenu.add(new HClustItem(actionListener, mediatorImpl, false, ClusterMode.getClusterMode()));
        if (clusterTbl.isExistHomCluster()) {
            jMenu.add(new HomClusterIdSortItem(actionListener, mediatorImpl, clusterTbl.isOutgroup()));
        }
        jMenu.add(new GeneInfoSortItem(actionListener, mediatorImpl, ClusterMode.getClusterMode(), string, "Gene/Cluster/Cell properties..."));
        return jMenu;
    }

    public static JMenu createSortMenuForAggregate(ActionListener actionListener, MediatorImpl mediatorImpl, Cluster cluster, List list) {
        JMenu jMenu = SortMenuFactory.createSortMenu();
        jMenu.add(new OrderByPatternItem(actionListener, mediatorImpl, ClusterMode.getClusterMode(), list));
        jMenu.add(new OrderByClusterItem(actionListener, mediatorImpl, 1));
        if (cluster != null) {
            jMenu.add(new PatternCoefMenu(actionListener, mediatorImpl, ClusterMode.getClusterMode(), cluster, "Phylogenetic pattern similarity based on the cluster"));
        }
        jMenu.add(new HClustItem(actionListener, mediatorImpl, false, ClusterMode.getClusterMode()));
        return jMenu;
    }

    private static JMenu createSortMenu() {
        JMenu jMenu = new JMenu("Sort");
        try {
            jMenu.setIcon(new ImageIcon(JLicenserTool.getResource("cgdp.recog.startup.Startup", "images/sort.png")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jMenu;
    }
}

