/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.spgroup;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.SpGroupTbl;
import cgdp.recog.spgroup.SpCodeTreeNode;
import cgdp.recog.spgroup.SpGroup;
import cgdp.recog.spgroup.SpGroupDeleteItem;
import cgdp.recog.spgroup.SpGroupNameEditItem;
import cgdp.recog.spgroup.SpGroupRootNode;
import cgdp.recog.spgroup.SpGroupTransferHandler;
import cgdp.recog.spgroup.SpGroupTreeNode;
import cgdp.recog.spgroup.SpGroups;
import cgdp.recog.system.OS;
import cgdp.recog.util.AbstractTree;
import java.awt.Point;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class SpGroupTree
extends AbstractTree {
    private MediatorImpl mediator;
    private DefaultTreeModel treeModel;

    public SpGroupTree(MediatorImpl mediatorImpl) {
        super(OS.isWindows());
        this.mediator = mediatorImpl;
        this.mediator.register(this);
        this.treeModel = new DefaultTreeModel(this.createTreeStructure());
        this.setModel(this.treeModel);
        this.setVisibleRoot();
        this.addMouseListener(this);
        this.setDragEnabled(true);
        this.setTransferHandler(new SpGroupTransferHandler());
    }

    @Override
    protected MutableTreeNode createTreeStructure() {
        SpGroupRootNode spGroupRootNode = null;
        SpGroupTbl spGroupTbl = SpGroupTbl.getInstance();
        if (!spGroupTbl.getSpGroups().isExistSpGroup()) {
            spGroupRootNode = new SpGroupRootNode("No species group");
            return spGroupRootNode;
        }
        spGroupRootNode = new SpGroupRootNode("Species Group");
        SpGroups spGroups = spGroupTbl.getSpGroups();
        for (SpGroup spGroup : spGroups.getSpGroupList()) {
            String string = this.createLabel(spGroup);
            SpGroupTreeNode spGroupTreeNode = new SpGroupTreeNode(spGroup, string);
            spGroupRootNode.add(spGroupTreeNode);
            for (String string2 : spGroup.getSpList()) {
                SpCodeTreeNode spCodeTreeNode = new SpCodeTreeNode(spGroup, string2, spGroup.getName(string2));
                spGroupTreeNode.add(spCodeTreeNode);
            }
        }
        return spGroupRootNode;
    }

    private String createLabel(SpGroup spGroup) {
        return spGroup.getName() + "(" + spGroup.getSpCount() + ")";
    }

    @Override
    protected void setVisibleRoot() {
        this.setRootVisible(true);
    }

    @Override
    protected void showPopup(Point point) {
        Object object;
        Object object2;
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null) {
            return;
        }
        MutableTreeNode mutableTreeNode = (MutableTreeNode)treePathArray[0].getLastPathComponent();
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (mutableTreeNode instanceof SpGroupTreeNode) {
            object2 = (SpGroupTreeNode)mutableTreeNode;
            object = ((SpGroupTreeNode)object2).getSpGroup();
            SpGroupNameEditItem spGroupNameEditItem = new SpGroupNameEditItem(this, this.mediator, (SpGroup)object);
            jPopupMenu.add(spGroupNameEditItem);
        }
        object2 = this.getSpGroupMap(treePathArray);
        object = new SpGroupDeleteItem(this, this.mediator, (Map)object2);
        jPopupMenu.add((JMenuItem)object);
        jPopupMenu.show(this, point.x, point.y);
    }

    private Map getSpGroupMap(TreePath[] treePathArray) {
        HashMap hashMap = new HashMap();
        for (int i = 0; i < treePathArray.length; ++i) {
            SpGroup spGroup;
            DefaultMutableTreeNode defaultMutableTreeNode;
            MutableTreeNode mutableTreeNode = (MutableTreeNode)treePathArray[i].getLastPathComponent();
            if (mutableTreeNode instanceof SpGroupTreeNode) {
                defaultMutableTreeNode = (SpGroupTreeNode)mutableTreeNode;
                spGroup = ((SpGroupTreeNode)defaultMutableTreeNode).getSpGroup();
                hashMap.put(new Long(spGroup.getId()), new HashSet(spGroup.getSpSet()));
                continue;
            }
            if (!(mutableTreeNode instanceof SpCodeTreeNode)) continue;
            defaultMutableTreeNode = (SpCodeTreeNode)mutableTreeNode;
            spGroup = ((SpCodeTreeNode)defaultMutableTreeNode).getSpGroup();
            Long l = new Long(spGroup.getId());
            HashSet<String> hashSet = (HashSet<String>)hashMap.get(l);
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                hashMap.put(l, hashSet);
            }
            hashSet.add(((SpCodeTreeNode)defaultMutableTreeNode).getSp());
        }
        return hashMap;
    }
}

