/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.startup;

import cgdp.recog.bean.Const;
import cgdp.recog.data.DataManager;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.patch.PatchExecuter;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.server.AccessServer;
import cgdp.recog.system.OS;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.StringTool;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;

public class ApplicationInitializer {
    private static final ApplicationLogger logger = new ApplicationLogger(ApplicationInitializer.class);

    static boolean initWorkDirectory() {
        return FileUtil.createDirectory(Const.WORK_DIR);
    }

    static boolean initConfDirectory() {
        try {
            boolean bl = new File(Const.USER_CONF_DIR).isDirectory();
            if (!FileUtil.createDirectory(Const.USER_CONF_DIR)) {
                return false;
            }
            if (!FileUtil.createDirectory(Const.USER_DOMCLUST_CONDITION_DIR)) {
                return false;
            }
            FileUtil.copy(Const.BASE_AMINO_CODE_DAT_PATH, Const.USER_AMINO_CODE_DAT_PATH, false);
            FileUtil.copy(Const.BASE_COLOR_DAT_PATH, Const.USER_COLOR_DAT_PATH, false);
            FileUtil.copy(Const.BASE_OPTION_DAT_PATH, Const.USER_OPTION_DAT_PATH, false);
            FileUtil.copy(Const.BASE_PATTERN_DAT_PATH, Const.USER_PATTERN_DAT_PATH, false);
            FileUtil.copy(Const.BASE_PTREE_DAT_PATH, Const.USER_PTREE_DAT_PATH, false);
            FileUtil.copy(Const.BASE_SERVER_DAT_PATH, Const.USER_SERVER_DAT_PATH, false);
            FileUtil.copy(Const.BASE_GENE_INFO_PATH, Const.USER_GENE_INFO_PATH, false);
            FileUtil.copy(Const.BASE_CLUSTER_INFO_PATH, Const.USER_CLUSTER_INFO_PATH, false);
            FileUtil.copy(Const.BASE_CELL_INFO_PATH, Const.USER_CELL_INFO_PATH, false);
            FileUtil.copy(Const.BASE_CONSENSE_TITLE, Const.USER_CONSENSE_TITLE, false);
            FileUtil.copy(Const.BASE_DOMCLUST_CONDITION_DEFAULT, Const.USER_DOMCLUST_CONDITION_DEFAULT, true);
            if (!bl) {
                PatchExecuter.savePatchHistory(new Date());
            }
            ApplicationInitializer.deleteOldConfFile();
        }
        catch (Exception exception) {
            logger.warn("Fail to initialize conf directory.", exception);
            return false;
        }
        return true;
    }

    private static void deleteOldConfFile() {
        FileUtil.delete(Const.BASE_UPDATE_DAT_PATH);
        FileUtil.delete(Const.USER_UPDATE_DAT_PATH);
    }

    public static boolean initDataDirectory() {
        try {
            if (!ApplicationInitializer.createDataDir()) {
                return false;
            }
            FileUtil.copy(Const.BASE_TAXONOMY_DAT_PATH, DataManager.getTaxonomyDat(), false);
            FileUtil.copy(DataManager.getFuncCatDatOnBase("mbgd"), DataManager.getFunctionCategoryFilepath("mbgd"), false);
            FileUtil.copy(DataManager.getFuncCatDatOnBase("cog"), DataManager.getFunctionCategoryFilepath("cog"), false);
            FileUtil.copy(DataManager.getFuncCatDatOnBase("kegg"), DataManager.getFunctionCategoryFilepath("kegg"), false);
            FileUtil.copy(DataManager.getFuncCatDatOnBase("tigr"), DataManager.getFunctionCategoryFilepath("tigr"), false);
            FileUtil.copy(Const.BASE_GENOME_DAT_PATH, DataManager.getGenomeDat(), false);
        }
        catch (Exception exception) {
            logger.warn("Fail to initialize data directory.", exception);
            return false;
        }
        return true;
    }

    public static boolean createDataDir() {
        if (!FileUtil.createDirectory(AccessServer.getDataDir())) {
            return false;
        }
        if (!FileUtil.createDirectory(DataManager.getGlobalGeneDatDir())) {
            return false;
        }
        if (!FileUtil.createDirectory(DataManager.getGlobalChromosomeDatDir())) {
            return false;
        }
        if (!FileUtil.createDirectory(DataManager.getGlobalContigDatDir())) {
            return false;
        }
        if (!FileUtil.createDirectory(DataManager.getProjectMappingDatDir())) {
            return false;
        }
        if (!FileUtil.createDirectory(DataManager.getUserDefDataGeneInfoDirpath())) {
            return false;
        }
        return FileUtil.createDirectory(DataManager.getGlobalGeneSetDirpath());
    }

    static boolean initProjectDir() {
        try {
            if (!ApplicationInitializer.createProjectDir()) {
                return false;
            }
        }
        catch (Exception exception) {
            logger.warn("Fail to initialize data directory.", exception);
            return false;
        }
        return true;
    }

    private static boolean createProjectDir() {
        if (!FileUtil.createDirectory(Const.USER_PROJECT_PATH)) {
            return false;
        }
        List list = ProjectAccesser.loadProject();
        if (list.isEmpty()) {
            try {
                if (!ProjectAccesser.createDefaultProject()) {
                    ProjectAccesser.registerProjectFromOldProjectInfo();
                }
            }
            catch (IOException iOException) {
                logger.warn("Fail to set project information.", iOException);
                return false;
            }
        }
        ProjectAccesser.adjustServerInfo();
        return true;
    }

    static void initClustalWPath() {
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        String string = optionValues.getClustalW();
        if (StringTool.isNull(string)) {
            String string2 = OS.isWindows() ? "clustalw2.exe" : "./clustalw2";
            optionValues.setClustalW(string2);
        }
    }

    static void executePatch() {
        PatchExecuter.executePatch();
    }
}

