/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.system.property;

import cgdp.recog.auth.Auth;
import cgdp.recog.auth.AuthFacade;
import cgdp.recog.server.EnvType;
import cgdp.recog.util.DateUtil;
import cgdp.recog.util.StringTool;
import java.util.Date;

public class ApplicationPropertyConf {
    public static final String PREFIX = "S";
    static final String PROPERTY_FILE_NAME = "app_property";
    static final String CONF_NAME_DEFAULT = "default";
    public static final String[] CONF_FILE_NAMES = new String[]{"app_property", "organism_set", "pattern", "propertyColor", "setConditionGroup", "merge_cluster", "split_cluster"};
    private String confId;
    private String domClustId;
    private String domClustViewId;
    private String manageLocation;
    private String confName;
    private String comment;
    private String createUser;
    private String createDate;
    private String updateUser;
    private String updateDate;

    public String getConfId() {
        return this.confId;
    }

    public void setConfId(String string) {
        this.confId = string;
    }

    public String getConfDirname() {
        return this.getConfId();
    }

    public String getDomClustId() {
        return this.domClustId;
    }

    public void setDomClustId(String string) {
        this.domClustId = string;
    }

    public String getDomClustViewId() {
        return this.domClustViewId;
    }

    public void setDomClustViewId(String string) {
        this.domClustViewId = string;
    }

    public String getManageLocation() {
        return this.manageLocation;
    }

    public void setManageLocation(String string) {
        this.manageLocation = string;
    }

    public String getConfName() {
        return this.confName;
    }

    public void setConfName(String string) {
        this.confName = string;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getCreateUser() {
        return this.createUser;
    }

    public void setCreateUser(String string) {
        this.createUser = string;
    }

    public String getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(String string) {
        this.createDate = string;
    }

    public String getUpdateUser() {
        return this.updateUser;
    }

    public void setUpdateUser(String string) {
        this.updateUser = string;
    }

    public String getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(String string) {
        this.updateDate = string;
    }

    public static ApplicationPropertyConf createLocalConf(String string, String string2, String string3, String string4) {
        ApplicationPropertyConf applicationPropertyConf = new ApplicationPropertyConf();
        applicationPropertyConf.setConfId(ApplicationPropertyConf.createConfId());
        applicationPropertyConf.setConfName(string);
        applicationPropertyConf.setDomClustId(string2);
        applicationPropertyConf.setDomClustViewId(string3);
        applicationPropertyConf.setComment(string4);
        applicationPropertyConf.setManageLocation("Local");
        Date date = new Date();
        applicationPropertyConf.setCreateDate(DateUtil.formatServerDate(date));
        applicationPropertyConf.setUpdateDate(DateUtil.formatServerDate(date));
        Auth auth = AuthFacade.getAuth();
        if (auth != null) {
            applicationPropertyConf.setCreateUser(auth.getUserName());
            applicationPropertyConf.setUpdateUser(auth.getUserName());
        }
        return applicationPropertyConf;
    }

    public static ApplicationPropertyConf createServerConf(String string, String string2, String string3, String string4) {
        ApplicationPropertyConf applicationPropertyConf = new ApplicationPropertyConf();
        applicationPropertyConf.setConfId(ApplicationPropertyConf.createConfId());
        applicationPropertyConf.setConfName(string);
        applicationPropertyConf.setDomClustId(string2);
        applicationPropertyConf.setDomClustViewId(string3);
        applicationPropertyConf.setComment(string4);
        applicationPropertyConf.setManageLocation("Server");
        Date date = new Date();
        applicationPropertyConf.setCreateDate(DateUtil.formatServerDate(date));
        applicationPropertyConf.setUpdateDate(DateUtil.formatServerDate(date));
        Auth auth = AuthFacade.getAuth();
        if (auth != null) {
            applicationPropertyConf.setCreateUser(auth.getUserName());
            applicationPropertyConf.setUpdateUser(auth.getUserName());
        }
        return applicationPropertyConf;
    }

    public static ApplicationPropertyConf createDefaultConf(String string, String string2) {
        ApplicationPropertyConf applicationPropertyConf = new ApplicationPropertyConf();
        applicationPropertyConf.setConfId(CONF_NAME_DEFAULT);
        applicationPropertyConf.setConfName(CONF_NAME_DEFAULT);
        applicationPropertyConf.setDomClustId(string);
        applicationPropertyConf.setDomClustViewId(string2);
        applicationPropertyConf.setComment(CONF_NAME_DEFAULT);
        applicationPropertyConf.setManageLocation("Local");
        Date date = new Date();
        applicationPropertyConf.setCreateDate(DateUtil.formatServerDate(date));
        applicationPropertyConf.setUpdateDate(DateUtil.formatServerDate(date));
        Auth auth = AuthFacade.getAuth();
        if (auth != null) {
            applicationPropertyConf.setCreateUser(auth.getUserName());
            applicationPropertyConf.setUpdateUser(auth.getUserName());
        }
        return applicationPropertyConf;
    }

    private static String createConfId() {
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return PREFIX + System.currentTimeMillis();
    }

    public boolean isLocal() {
        return EnvType.isLocal(this.getManageLocation());
    }

    public boolean isServer() {
        return !this.isLocal();
    }

    public boolean equalsId(String string) {
        if (StringTool.isNull(string)) {
            return false;
        }
        return this.getConfId().equals(string);
    }

    public boolean equalsName(String string) {
        if (StringTool.isNull(string)) {
            return false;
        }
        return this.getConfName().equals(string);
    }
}

