/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.system.property;

import cgdp.recog.auth.Auth;
import cgdp.recog.auth.AuthFacade;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.DataManager;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.system.property.ApplicationPropertyConf;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.DateUtil;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.io.File;
import java.util.Date;

public class ApplicationPropertySaveProcess
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(ApplicationPropertySaveProcess.class);
    private Component parent;
    private ClusterTbl clusterTbl;
    private ApplicationPropertyConf conf;

    public ApplicationPropertySaveProcess(ApplicationPropertyConf applicationPropertyConf) {
        this(null, null, applicationPropertyConf);
    }

    public ApplicationPropertySaveProcess(Component component, ClusterTbl clusterTbl, ApplicationPropertyConf applicationPropertyConf) {
        this.parent = component;
        this.clusterTbl = clusterTbl;
        this.conf = applicationPropertyConf;
    }

    @Override
    public void execute(ProgressImpl progressImpl) {
        Project project = ProjectAccesser.getSelectedProject();
        try {
            ApplicationPropertyFacade.removeConf(this.conf.getConfName());
            String string = ApplicationPropertyFacade.getApplicationPropertyDirpath(project, this.conf);
            FileUtil.createDirectory(string);
            String string2 = DataManager.getDomClustDirpath(project, this.conf.getDomClustId());
            for (int i = 0; i < ApplicationPropertyConf.CONF_FILE_NAMES.length; ++i) {
                String string3 = ApplicationPropertyConf.CONF_FILE_NAMES[i];
                File file = new File(string2, string3);
                if (!file.isFile()) continue;
                File file2 = new File(string, string3);
                FileUtil.copy(file, file2, true);
            }
            Auth auth = AuthFacade.getAuth();
            this.conf.setUpdateDate(DateUtil.formatServerDate(new Date()));
            this.conf.setUpdateUser(auth.getUserName());
            ApplicationPropertyFacade.registerConf(project, this.conf);
        }
        catch (Exception exception) {
            String string = "Fail to save application property file. " + this.conf.getConfName();
            logger.warn(string, exception);
            this.setError(true);
            this.setErrorMessage(string);
            String string4 = ApplicationPropertyFacade.getApplicationPropertyDirpath(project, this.conf);
            FileUtil.delete(string4);
        }
    }

    @Override
    public void done() {
        if (this.isCancel()) {
            return;
        }
        if (this.isError()) {
            if (this.parent != null) {
                MessageManager.showErrorMessage(this.parent, this.getErrorMessages());
            }
            return;
        }
        if (this.clusterTbl != null) {
            this.clusterTbl.setApplicationPropertyConf(this.conf);
        }
    }
}

