/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy;

import cgdp.recog.data.GenomeTbl;
import cgdp.recog.data.RankDif;
import cgdp.recog.taxonomy.TaxonomyTreeNode;
import cgdp.recog.util.FileImporter;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

class TaxImporter
extends FileImporter {
    private static final String PARAMETER_PREFIX = "#";
    private static final String DELIMITER = "\t";
    private String filepath;
    private List nodeList = new ArrayList();
    private GenomeTbl genomeTbl;
    private int preLevel = -1;
    private String preRank;

    TaxImporter(String string) {
        this.filepath = string;
        this.setExistHeader(false);
        this.genomeTbl = new GenomeTbl();
        this.genomeTbl.read();
    }

    @Override
    protected String getFilepath() {
        return this.filepath;
    }

    @Override
    protected void parseDataLine(int n, String string) {
        if (StringTool.isNull(string) || string.startsWith(PARAMETER_PREFIX)) {
            return;
        }
        Vector vector = StringTool.splitString(string, DELIMITER);
        if (vector.size() < 6) {
            return;
        }
        int n2 = Integer.parseInt((String)vector.get(0));
        String string2 = (String)vector.get(1);
        String string3 = (String)vector.get(2);
        String string4 = (String)vector.get(3);
        int n3 = Integer.parseInt((String)vector.get(4));
        int n4 = !StringTool.isNull((String)vector.get(5)) ? Integer.parseInt((String)vector.get(5)) : -1;
        if (!StringTool.isNull(this.preRank) && RankDif.isGenome(this.preRank) && RankDif.isGenome(string4) && this.preLevel < n2) {
            n2 = this.preLevel;
        }
        this.preRank = string4;
        this.preLevel = n2;
        TaxonomyTreeNode taxonomyTreeNode = new TaxonomyTreeNode(n2, string2, string3, string4, n3, n4, this.genomeTbl.getSpecweight(string3));
        this.nodeList.add(taxonomyTreeNode);
    }

    @Override
    protected void parseHeaderLine(String string) {
    }

    public List getNodeList() {
        return this.nodeList;
    }
}

