/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.MultiInfoCondition;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.info.gene.GeneInfoUtil;
import cgdp.recog.sort.GeneInfoSortable;
import cgdp.recog.taxonomy.TaxFacade;
import cgdp.recog.taxonomy.TaxonomyTreeNode;
import cgdp.recog.taxonomy.map.AbstractRankScoreCalculater;
import cgdp.recog.taxonomy.map.TaxMapGraphTextDataCreater;
import cgdp.recog.taxonomy.map.TaxMapInfo;
import cgdp.recog.taxonomy.map.TaxMapModel;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.GeneUtil;
import cgdp.recog.util.MapUtil;
import cgdp.recog.util.StringTool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

class AbstractDatasetCreater {
    private static final ApplicationLogger logger = new ApplicationLogger(TaxMapGraphTextDataCreater.class);
    protected AbstractInfoTitle infoTitle;
    protected boolean displayRank = false;
    private Map nameRankMap;

    AbstractDatasetCreater(AbstractInfoTitle abstractInfoTitle, boolean bl) {
        this.infoTitle = abstractInfoTitle;
        this.displayRank = bl;
        if (this.displayRank) {
            this.nameRankMap = AbstractDatasetCreater.createNameRankMap();
        }
    }

    protected Map createOrganismCodeLocusTagGeneInfoMap(List list) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object42;
        ArrayList<GeneInfo> arrayList = new ArrayList<GeneInfo>();
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object42 : list) {
            Object object5;
            String string;
            object3 = ((TaxMapInfo)object42).getOrganismCode();
            object2 = GeneUtil.createOrganismLocusTagKey((String)object3, string = GeneUtil.removeDomainNo((String)(object5 = ((TaxMapInfo)object42).getLocusTag())));
            if (hashSet.contains(object2)) continue;
            object = new GeneInfo((String)object3, string);
            arrayList.add((GeneInfo)object);
            hashSet.add((String)object2);
        }
        Map map = GeneInfoUtil.createOrganismCodeGeneInfoListMap(arrayList);
        object42 = new ArrayList();
        object42.add(GeneInfoTitle.TITLE_ORGANISM_CODE);
        object42.add(GeneInfoTitle.TITLE_LOCUSTAG_SERVER);
        object42.add(this.infoTitle);
        object3 = new HashMap();
        for (String string : map.keySet()) {
            object2 = (List)map.get(string);
            object = GeneInfoFacade.getGeneInfoList((Collection)object2, (Collection)object42);
            Map map2 = GeneInfoUtil.createLocusTagGeneInfoMap((Collection)object);
            object3.put(string, map2);
        }
        return object3;
    }

    protected Map createKeyScoreMap(List list, Map map, TaxMapModel taxMapModel) {
        HashMap hashMap = new HashMap();
        for (TaxMapInfo taxMapInfo : list) {
            String string = taxMapInfo.getOrganismCode();
            String string2 = taxMapInfo.getLocusTag();
            Object object = this.getValue(string, string2, map);
            double d = AbstractRankScoreCalculater.calcScore(taxMapModel, taxMapInfo);
            this.addScore(object, hashMap, d);
        }
        return hashMap;
    }

    private void addScore(Object object, Map map, double d) {
        double d2 = 0.0;
        if (map.containsKey(object)) {
            d2 = (Double)map.get(object);
        }
        map.put(object, new Double(d2 += d));
    }

    protected Object getValue(String string, String string2, Map map) {
        Map map2 = (Map)map.get(string);
        if (MapUtil.isNull(map2)) {
            return null;
        }
        String string3 = GeneUtil.removeDomainNo(string2);
        GeneInfo geneInfo = (GeneInfo)map2.get(string3);
        if (geneInfo == null) {
            return null;
        }
        return geneInfo.getInfo(this.infoTitle);
    }

    static Map createNameRankMap() {
        try {
            List list = TaxFacade.getTaxonomyTreeNodeList();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (TaxonomyTreeNode taxonomyTreeNode : list) {
                hashMap.put(taxonomyTreeNode.getName(), taxonomyTreeNode.getRank());
            }
            return hashMap;
        }
        catch (IOException iOException) {
            logger.warn("Fail to load rank information.");
            return new HashMap();
        }
    }

    protected String addRank(String string) {
        return AbstractDatasetCreater.addRank(string, this.displayRank, this.nameRankMap);
    }

    static String addRank(String string, boolean bl, Map map) {
        if (!bl) {
            return string;
        }
        String string2 = (String)map.get(string);
        if (!StringTool.isNull(string2)) {
            return string + "[" + map.get(string) + "]";
        }
        return string;
    }

    protected class KeyComparator
    implements Comparator {
        private MultiInfoCondition condition;

        protected KeyComparator() {
            this.condition = new MultiInfoCondition(){

                @Override
                public AbstractInfoTitle getInfoTitle() {
                    return null;
                }

                @Override
                public int indexOfElement(Object object) {
                    return 0;
                }

                @Override
                public boolean isAsc() {
                    return true;
                }

                @Override
                public boolean isMultiGeneInfoAve() {
                    return false;
                }

                @Override
                public boolean isMultiGeneInfoMax() {
                    return false;
                }

                @Override
                public boolean isMultiGeneInfoMedian() {
                    return false;
                }

                @Override
                public boolean isMultiGeneInfoMin() {
                    return false;
                }
            };
        }

        public int compare(Object object, Object object2) {
            return GeneInfoSortable.compareHierarchy(this.condition, (Comparable)object, (Comparable)object2);
        }
    }

    protected class NameScoreComparator
    implements Comparator {
        private Map nameScoreMap;

        protected NameScoreComparator(Map map) {
            this.nameScoreMap = map;
        }

        public int compare(Object object, Object object2) {
            double d;
            String string = (String)object;
            String string2 = (String)object2;
            double d2 = ((Number)this.nameScoreMap.get(string)).doubleValue();
            if (d2 - (d = ((Number)this.nameScoreMap.get(string2)).doubleValue()) < 0.0) {
                return 1;
            }
            if (d2 - d > 0.0) {
                return -1;
            }
            return 0;
        }
    }
}

