/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.process.ProgressImpl;
import cgdp.recog.taxonomy.TaxFacade;
import cgdp.recog.taxonomy.TaxonomyTreeNode;
import cgdp.recog.taxonomy.map.AbstractRankScoreCalculater;
import cgdp.recog.taxonomy.map.TaxMapFacade;
import cgdp.recog.taxonomy.map.TaxMapInfo;
import cgdp.recog.taxonomy.map.TaxMapModel;
import cgdp.recog.util.StringTool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.tree.TreeNode;

class RankGeneCountLowerCalculater
extends AbstractRankScoreCalculater {
    RankGeneCountLowerCalculater(List list, TaxMapModel taxMapModel) {
        super(list, taxMapModel);
    }

    @Override
    public void execute(ProgressImpl progressImpl) throws Exception {
        this.updateRankTaxMapInfo();
        this.setRankScoreMap(this.createRankScoreMap());
    }

    private void updateRankTaxMapInfo() throws IOException, Exception {
        Object object;
        TaxonomyTreeNode taxonomyTreeNode2;
        List list = TaxFacade.getDisplayTaxonomyTreeNodeList();
        HashMap<String, TaxonomyTreeNode> hashMap = new HashMap<String, TaxonomyTreeNode>();
        for (TaxonomyTreeNode taxonomyTreeNode2 : list) {
            object = TaxMapModel.getKeyName(taxonomyTreeNode2);
            hashMap.put((String)object, taxonomyTreeNode2);
        }
        TaxFacade.createTaxonomyTree(list, null);
        List list2 = TaxFacade.getTaxonomyTreeNodeList();
        taxonomyTreeNode2 = TaxMapFacade.createTargetTaxonomyTree(list2, this.taxMapModel.getTreeOrganismCodeSet(), this.taxMapModel);
        object = TaxFacade.getRankNameSet(taxonomyTreeNode2);
        List list3 = this.getTaxMapInfoListByAggregateType();
        ArrayList<TaxMapInfo> arrayList = new ArrayList<TaxMapInfo>();
        HashMap<String, ArrayList<TaxMapInfo>> hashMap2 = new HashMap<String, ArrayList<TaxMapInfo>>();
        for (TaxMapInfo taxMapInfo : list3) {
            Object object2;
            TaxonomyTreeNode taxonomyTreeNode3 = (TaxonomyTreeNode)hashMap.get(taxMapInfo.getLowerName());
            if (taxonomyTreeNode3 == null) {
                System.err.println("Fail to get " + taxMapInfo.getLowerName() + " from taxonomy");
                continue;
            }
            ArrayList<TaxMapInfo> arrayList2 = null;
            TreeNode[] treeNodeArray = taxonomyTreeNode3.getPath();
            for (int i = treeNodeArray.length - 1; i >= 0; --i) {
                object2 = (TaxonomyTreeNode)treeNodeArray[i];
                String string = TaxMapModel.getKeyName((TaxonomyTreeNode)object2);
                if (object.contains(string)) {
                    arrayList2 = object2;
                    break;
                }
                if (!StringTool.isNull(taxMapInfo.getUpperName()) && TaxMapModel.getKeyName(object2).equals(taxMapInfo.getUpperName())) break;
            }
            if (arrayList2 != null) {
                String string = TaxMapModel.getKeyName(arrayList2);
                object2 = (List)hashMap2.get(string);
                if (object2 == null) {
                    object2 = new ArrayList<TaxMapInfo>();
                    hashMap2.put(string, (ArrayList<TaxMapInfo>)object2);
                }
                object2.add(taxMapInfo);
                continue;
            }
            arrayList.add(taxMapInfo);
        }
        this.setRankTaxMapInfoMap(hashMap2);
        this.setUnassignedTaxMapInfoList(arrayList);
    }
}

