/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.taxonomy.map.TaxMapConf;
import cgdp.recog.util.FileExporter;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.List;

public class TaxMapConfExporter
extends FileExporter {
    private static final String HEADER = "Name\tFilename\tMapping_Organism";
    private static final String DELIMITER = "\t";
    private static final String DELIMITER_SP = ",";
    private String filepath;
    private List taxMapConfList = new ArrayList();

    public TaxMapConfExporter(String string, List list) {
        this.filepath = string;
        this.taxMapConfList = list;
    }

    @Override
    protected String getContents() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(HEADER);
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        for (TaxMapConf taxMapConf : this.taxMapConfList) {
            stringBuffer.append(taxMapConf.getName());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(taxMapConf.getFilename());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(StringTool.conbineStrList(taxMapConf.getMappingOrganismCodeSet(), DELIMITER_SP));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        return stringBuffer.toString();
    }

    @Override
    protected String getFilepath() {
        return this.filepath;
    }
}

