/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.taxonomy.map.TaxMapInfo;
import cgdp.recog.util.FileExporter;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.List;

public class TaxMapExporter
extends FileExporter {
    private static final String HEADER = "#Cluster\tName\tlower(score,pam)\tupper(score,pam)";
    private static final String DELIMITER = "\t";
    private static final String NO_CLUSTER_ID = "-1";
    private String filepath;
    private List taxMapInfoList = new ArrayList();

    public TaxMapExporter(String string, List list) {
        this.filepath = string;
        this.taxMapInfoList = list;
    }

    @Override
    protected String getContents() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(HEADER);
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        for (TaxMapInfo taxMapInfo : this.taxMapInfoList) {
            String string = taxMapInfo.getKey();
            if (TaxMapInfo.isNoValue(string)) {
                string = NO_CLUSTER_ID;
            }
            stringBuffer.append(taxMapInfo.getKey());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(TaxMapExporter.createOrganismLocusTagSentence(taxMapInfo));
            stringBuffer.append(DELIMITER);
            stringBuffer.append(TaxMapExporter.createRankSentence(taxMapInfo.getLowerName(), taxMapInfo.getLowerScore(), taxMapInfo.getLowerDist()));
            stringBuffer.append(DELIMITER);
            stringBuffer.append(TaxMapExporter.createRankSentence(taxMapInfo.getUpperName(), taxMapInfo.getUpperScore(), taxMapInfo.getUpperDist()));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        return stringBuffer.toString();
    }

    private static String createOrganismLocusTagSentence(TaxMapInfo taxMapInfo) {
        return taxMapInfo.getOrganismCode() + ":" + taxMapInfo.getLocusTag();
    }

    private static String createRankSentence(String string, double d, double d2) {
        if (StringTool.isNull(string)) {
            return "";
        }
        return string + "(" + d + "," + d2 + ")";
    }

    @Override
    protected String getFilepath() {
        return this.filepath;
    }
}

