/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.DataManager;
import cgdp.recog.data.Gene;
import cgdp.recog.data.GeneTbl;
import cgdp.recog.filefilter.DatIOFileFilter;
import cgdp.recog.filefilter.FileFilterFactory;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.taxonomy.DisplayTaxonomyTreeNode;
import cgdp.recog.taxonomy.TaxFacade;
import cgdp.recog.taxonomy.TaxonomyTreeNode;
import cgdp.recog.taxonomy.map.TaxMapConf;
import cgdp.recog.taxonomy.map.TaxMapConfComparator;
import cgdp.recog.taxonomy.map.TaxMapConfExporter;
import cgdp.recog.taxonomy.map.TaxMapConfImporter;
import cgdp.recog.taxonomy.map.TaxMapDownloader;
import cgdp.recog.taxonomy.map.TaxMapExporter;
import cgdp.recog.taxonomy.map.TaxMapFuncCatDataCreater;
import cgdp.recog.taxonomy.map.TaxMapFuncCatDataExporter;
import cgdp.recog.taxonomy.map.TaxMapGraphNumDataCreater;
import cgdp.recog.taxonomy.map.TaxMapGraphNumDataExporter;
import cgdp.recog.taxonomy.map.TaxMapGraphTextDataCreater;
import cgdp.recog.taxonomy.map.TaxMapGraphTextDataExporter;
import cgdp.recog.taxonomy.map.TaxMapImporter;
import cgdp.recog.taxonomy.map.TaxMapInfo;
import cgdp.recog.taxonomy.map.TaxMapModel;
import cgdp.recog.taxonomy.map.TaxMapPopulationDataCreater;
import cgdp.recog.taxonomy.map.TaxMapPopulationDataExporter;
import cgdp.recog.taxonomy.map.TaxMapTableDialog;
import cgdp.recog.taxonomy.map.TaxMapUtil;
import cgdp.recog.util.AbstractFileExporter;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.FileExportExecuter;
import cgdp.recog.util.FileImporter;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.GeneUtil;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;

public class TaxMapFacade {
    private static final ApplicationLogger logger = new ApplicationLogger(TaxMapFacade.class);

    public static boolean downloadTaxMapInfo(String string, Set set, boolean bl) throws Exception {
        Project project = ProjectAccesser.getSelectedProject();
        TaxMapFacade.createTaxMapDirectory(project, string);
        TaxMapDownloader taxMapDownloader = new TaxMapDownloader(string, set);
        taxMapDownloader.execute();
        List list = taxMapDownloader.getTaxMapInfoList();
        if (CollectionUtil.isNull(list)) {
            return false;
        }
        Map map = TaxMapUtil.createOrganismTaxMapInfoMap(list);
        for (String string2 : map.keySet()) {
            List list2 = (List)map.get(string2);
            String string3 = DataManager.getTaxMapFilepath(project, string, string2);
            TaxMapFacade.exportTaxMapInfoList(string3, list2);
        }
        TaxMapConf taxMapConf = TaxMapConf.createDefaultTaxMapConf(set);
        TaxMapFacade.saveTaxMapConf(project, string, taxMapConf);
        return true;
    }

    private static void saveTaxMapConf(Project project, String string, TaxMapConf taxMapConf) throws IOException {
        Object object;
        String string2 = DataManager.getTaxMapConfFilepath(project, string);
        List<TaxMapConf> list = new ArrayList();
        if (new File(string2).isFile()) {
            object = new TaxMapConfImporter(string2);
            ((FileImporter)object).execute();
            list = ((TaxMapConfImporter)object).getTaxMapConfList();
        }
        object = new HashSet();
        for (TaxMapConf taxMapConf2 : list) {
            if (!taxMapConf.equalsName(taxMapConf2)) continue;
            object.add(taxMapConf2);
        }
        list.removeAll((Collection<?>)object);
        list.add(taxMapConf);
        Collections.sort(list, new TaxMapConfComparator());
        TaxMapConfExporter taxMapConfExporter = new TaxMapConfExporter(string2, list);
        taxMapConfExporter.execute();
    }

    public static TaxMapConf getTaxMapConf(Project project, String string, String string2) throws IOException {
        List list = TaxMapFacade.getTaxMapConfList(project, string);
        TaxMapConf taxMapConf = TaxMapFacade.getTaxMapConf(list, string2);
        if (taxMapConf == null && !CollectionUtil.isNull(list)) {
            taxMapConf = TaxMapFacade.getDefaultTaxMapConf(list);
        }
        return taxMapConf;
    }

    private static List getTaxMapConfList(Project project, String string) throws IOException {
        String string2 = DataManager.getTaxMapConfFilepath(project, string);
        TaxMapConfImporter taxMapConfImporter = new TaxMapConfImporter(string2);
        taxMapConfImporter.execute();
        return taxMapConfImporter.getTaxMapConfList();
    }

    public static Set getMappingOrganismCodeSetFromLastTaxMapConf(String string) {
        try {
            TaxMapConf taxMapConf = TaxMapFacade.getLastTaxMapConf(string);
            if (taxMapConf == null) {
                return new HashSet();
            }
            return taxMapConf.getMappingOrganismCodeSet();
        }
        catch (IOException iOException) {
            logger.warn("Fail to load the taxonomy mapping information file.", iOException);
            return new HashSet();
        }
    }

    private static TaxMapConf getLastTaxMapConf(String string) throws IOException {
        TaxMapModel taxMapModel = new TaxMapModel();
        ApplicationPropertyFacade.updateDomClustAccessable(string, taxMapModel);
        TaxMapConf taxMapConf = taxMapModel.getTaxMapConf();
        if (taxMapConf == null) {
            Project project = ProjectAccesser.getSelectedProject();
            List list = TaxMapFacade.getTaxMapConfList(project, string);
            if (!CollectionUtil.isNull(list)) {
                return TaxMapFacade.getDefaultTaxMapConf(list);
            }
            return null;
        }
        return taxMapModel.getTaxMapConf();
    }

    static TaxMapConf getDefaultTaxMapConf(String string) throws IOException {
        Project project = ProjectAccesser.getSelectedProject();
        List list = TaxMapFacade.getTaxMapConfList(project, string);
        return TaxMapFacade.getDefaultTaxMapConf(list);
    }

    private static TaxMapConf getDefaultTaxMapConf(List list) {
        TaxMapConf taxMapConf = null;
        for (TaxMapConf taxMapConf2 : list) {
            if (!taxMapConf2.isDefault()) continue;
            taxMapConf = taxMapConf2;
            break;
        }
        return taxMapConf;
    }

    public static TaxMapConf getTaxMapConf(List list, String string) {
        for (TaxMapConf taxMapConf : list) {
            if (!taxMapConf.equalsName(string)) continue;
            return taxMapConf;
        }
        return null;
    }

    private static void createTaxMapDirectory(Project project, String string) {
        String string2 = DataManager.getTaxMapDirpath(project, string);
        FileUtil.createDirectory(string2);
    }

    static List getTaxMapInfoList(String string, Collection collection, boolean bl) throws IOException {
        Project project = ProjectAccesser.getSelectedProject();
        ArrayList arrayList = new ArrayList();
        for (String string2 : collection) {
            String string3 = DataManager.getTaxMapFilepath(project, string, string2);
            if (!new File(string3).isFile()) continue;
            TaxMapImporter taxMapImporter = new TaxMapImporter(string3);
            taxMapImporter.execute();
            arrayList.addAll(taxMapImporter.getTaxMapInfoList());
        }
        return arrayList;
    }

    static List getNoHitTaxMapInfoList(String string, GeneTbl geneTbl, List list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object : list) {
            if (!string.equals(((TaxMapInfo)object).getOrganismCode())) continue;
            hashSet.add(GeneUtil.removeDomainNo(((TaxMapInfo)object).getLocusTag()));
        }
        ArrayList arrayList = new ArrayList();
        try {
            for (String string2 : geneTbl.keySet()) {
                Gene gene = (Gene)geneTbl.get(string2);
                if (hashSet.contains(string2) || !gene.isCDS()) continue;
                TaxMapInfo taxMapInfo = new TaxMapInfo();
                taxMapInfo.setOrganismCode(string);
                taxMapInfo.setLocusTag(string2);
                arrayList.add(taxMapInfo);
            }
        }
        catch (Exception exception) {
            logger.warn("Fail to load the gene information. " + string, exception);
        }
        return arrayList;
    }

    static Map createRankPathMap() throws IOException {
        TaxonomyTreeNode taxonomyTreeNode = TaxFacade.createCompleteTaxonomyTree();
        ArrayList arrayList = new ArrayList();
        TaxFacade.getLeafNodeList(taxonomyTreeNode, arrayList);
        HashMap<String, TreePath> hashMap = new HashMap<String, TreePath>();
        for (DefaultMutableTreeNode defaultMutableTreeNode : arrayList) {
            Object[] objectArray = defaultMutableTreeNode.getPath();
            TreePath treePath = new TreePath(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                TaxonomyTreeNode taxonomyTreeNode2 = (TaxonomyTreeNode)objectArray[i];
                hashMap.put(taxonomyTreeNode2.getName(), treePath);
            }
        }
        return hashMap;
    }

    public static void exportTaxMapInfoList(String string, List list) throws IOException {
        TaxMapExporter taxMapExporter = new TaxMapExporter(string, list);
        taxMapExporter.execute();
    }

    public static Map createTaxonomyTreeNodeMap(TaxonomyTreeNode taxonomyTreeNode) {
        HashMap hashMap = new HashMap();
        TaxMapFacade.createTaxonomyTreeNodeMap(taxonomyTreeNode, hashMap);
        return hashMap;
    }

    private static void createTaxonomyTreeNodeMap(TaxonomyTreeNode taxonomyTreeNode, Map map) {
        map.put(TaxMapModel.getKeyName(taxonomyTreeNode), taxonomyTreeNode);
        Enumeration<TreeNode> enumeration = taxonomyTreeNode.children();
        while (enumeration.hasMoreElements()) {
            TaxonomyTreeNode taxonomyTreeNode2 = (TaxonomyTreeNode)enumeration.nextElement();
            TaxMapFacade.createTaxonomyTreeNodeMap(taxonomyTreeNode2, map);
        }
    }

    public static TaxonomyTreeNode createTargetTaxonomyTree(List list, Collection collection, TaxMapModel taxMapModel) throws IOException {
        TaxonomyTreeNode taxonomyTreeNode = TaxFacade.createTaxonomyTree(list, collection);
        TaxMapFacade.filterRank(taxonomyTreeNode, taxMapModel);
        return taxonomyTreeNode;
    }

    public static void filterRank(TaxonomyTreeNode taxonomyTreeNode, TaxMapModel taxMapModel) {
        ArrayList arrayList = new ArrayList();
        TaxFacade.getLeafNodeList(taxonomyTreeNode, arrayList);
        HashMap hashMap = new HashMap();
        block0: for (TaxonomyTreeNode taxonomyTreeNode2 : arrayList) {
            while (true) {
                TaxonomyTreeNode taxonomyTreeNode3;
                ArrayList<TaxonomyTreeNode> arrayList2;
                if ((arrayList2 = (ArrayList<TaxonomyTreeNode>)hashMap.get(taxonomyTreeNode3 = TaxMapFacade.getDisplayRankParentNode((TaxonomyTreeNode)taxonomyTreeNode2.getParent(), taxMapModel))) == null) {
                    arrayList2 = new ArrayList<TaxonomyTreeNode>();
                    hashMap.put(taxonomyTreeNode3, arrayList2);
                }
                boolean bl = false;
                for (TaxonomyTreeNode taxonomyTreeNode4 : arrayList2) {
                    if (!taxonomyTreeNode4.getName().equals(taxonomyTreeNode2.getName()) || !taxonomyTreeNode4.getAbbreviation().equals(taxonomyTreeNode2.getAbbreviation())) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    arrayList2.add(taxonomyTreeNode2);
                }
                if (taxonomyTreeNode3.getLevel() == 1) continue block0;
                taxonomyTreeNode2 = taxonomyTreeNode3;
            }
        }
        TaxFacade.createTaxonomyTree(taxonomyTreeNode, hashMap);
    }

    private static TaxonomyTreeNode getDisplayRankParentNode(TaxonomyTreeNode taxonomyTreeNode, TaxMapModel taxMapModel) {
        while (!taxMapModel.isShowRank(taxonomyTreeNode)) {
            taxonomyTreeNode = (TaxonomyTreeNode)taxonomyTreeNode.getParent();
        }
        return taxonomyTreeNode;
    }

    public static void selectClusterOnPPM(List list, MediatorImpl mediatorImpl) {
        if (CollectionUtil.isNull(list)) {
            return;
        }
        List list2 = TaxMapUtil.createGeneInfoList(list);
        mediatorImpl.updateSelectedClusterByLocusTag(list2, false);
    }

    public static Set getMappingOrganismCodeSet(String string) {
        File[] fileArray;
        HashSet<String> hashSet = new HashSet<String>();
        Project project = ProjectAccesser.getSelectedProject();
        String string2 = DataManager.getTaxMapDirpath(project, string);
        File file = new File(string2);
        if (file.isDirectory() && (fileArray = file.listFiles(new DatIOFileFilter())) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                String string3 = fileArray[i].getName();
                String string4 = FileUtil.removeExtension(string3);
                hashSet.add(string4);
            }
        }
        return hashSet;
    }

    static boolean hideNoMappingNode(DisplayTaxonomyTreeNode displayTaxonomyTreeNode, Set set) {
        String string = TaxMapModel.getKeyName(displayTaxonomyTreeNode);
        displayTaxonomyTreeNode.setVisibled(set.contains(string));
        boolean bl = false;
        Enumeration<TreeNode> enumeration = displayTaxonomyTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DisplayTaxonomyTreeNode displayTaxonomyTreeNode2 = (DisplayTaxonomyTreeNode)enumeration.nextElement();
            bl |= TaxMapFacade.hideNoMappingNode(displayTaxonomyTreeNode2, set);
        }
        if (displayTaxonomyTreeNode.isVisibledChildForAllChildren()) {
            bl = true;
        }
        displayTaxonomyTreeNode.setVisibledChild(bl);
        return bl;
    }

    static boolean hideMappingNodeByScoreFilter(DisplayTaxonomyTreeNode displayTaxonomyTreeNode, TaxMapModel taxMapModel) {
        String string = TaxMapModel.getKeyName(displayTaxonomyTreeNode);
        displayTaxonomyTreeNode.setVisibled(taxMapModel.isMatchScoreFilter(string));
        boolean bl = false;
        Enumeration<TreeNode> enumeration = displayTaxonomyTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DisplayTaxonomyTreeNode displayTaxonomyTreeNode2 = (DisplayTaxonomyTreeNode)enumeration.nextElement();
            bl |= TaxMapFacade.hideMappingNodeByScoreFilter(displayTaxonomyTreeNode2, taxMapModel);
        }
        if (displayTaxonomyTreeNode.isVisibledChildForAllChildren()) {
            bl = true;
        }
        displayTaxonomyTreeNode.setVisibledChild(bl);
        return bl;
    }

    static void showAllNode(DisplayTaxonomyTreeNode displayTaxonomyTreeNode) {
        displayTaxonomyTreeNode.setVisibled(true);
        displayTaxonomyTreeNode.setVisibledChild(true);
        Enumeration<TreeNode> enumeration = displayTaxonomyTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DisplayTaxonomyTreeNode displayTaxonomyTreeNode2 = (DisplayTaxonomyTreeNode)enumeration.nextElement();
            TaxMapFacade.showAllNode(displayTaxonomyTreeNode2);
        }
    }

    static void setClusterId(List list, ClusterTbl clusterTbl) {
        for (TaxMapInfo taxMapInfo : list) {
            String string;
            String string2 = taxMapInfo.getOrganismCode();
            Cluster cluster = clusterTbl.getCluster(string2, string = taxMapInfo.getLocusTag());
            if (cluster != null) {
                taxMapInfo.setClusterId(cluster.getClusterId());
                if (!clusterTbl.isOutgroup()) continue;
                taxMapInfo.setSubClusterId(cluster.getSubClusterId());
                continue;
            }
            taxMapInfo.setClusterId(-1);
        }
    }

    static void saveTaxMapModel(TaxMapModel taxMapModel) {
        try {
            ApplicationPropertyFacade.saveProperty(taxMapModel.getDomClustId(), taxMapModel);
        }
        catch (IOException iOException) {
            String string = "Fail to save the taxonomy mapping option.";
            logger.warn(string, iOException);
        }
    }

    static void exportPopulationData(Component component, TaxMapModel taxMapModel) {
        TaxMapPopulationDataExporter taxMapPopulationDataExporter = new TaxMapPopulationDataExporter(taxMapModel);
        FileExportExecuter fileExportExecuter = new FileExportExecuter(component, taxMapPopulationDataExporter);
        fileExportExecuter.addFileFilter(FileFilterFactory.createTextFileWithDirFilter());
        fileExportExecuter.execute();
    }

    static void exportGraphData(Component component, TaxMapModel taxMapModel, ClusterTbl clusterTbl, AbstractInfoTitle abstractInfoTitle) {
        AbstractFileExporter abstractFileExporter = abstractInfoTitle.isNumeric() ? new TaxMapGraphNumDataExporter(taxMapModel, abstractInfoTitle) : (abstractInfoTitle.equalsKey("CFuncCat") ? new TaxMapFuncCatDataExporter(taxMapModel, clusterTbl, abstractInfoTitle) : new TaxMapGraphTextDataExporter(taxMapModel, abstractInfoTitle));
        FileExportExecuter fileExportExecuter = new FileExportExecuter(component, abstractFileExporter);
        fileExportExecuter.addFileFilter(FileFilterFactory.createTextFileWithDirFilter());
        fileExportExecuter.execute();
    }

    static void showGraphDataList(Frame frame, ClusterTbl clusterTbl, TaxMapModel taxMapModel, Dataset dataset, String string) {
        TaxMapTableDialog taxMapTableDialog = new TaxMapTableDialog(frame, clusterTbl);
        taxMapTableDialog.updateValue(clusterTbl, taxMapModel, dataset, string);
        taxMapTableDialog.setVisible(true);
    }

    static Dataset createGenePopulationDataset(TaxMapModel taxMapModel) {
        boolean bl = !taxMapModel.isExistSelectedNode();
        TaxMapPopulationDataCreater taxMapPopulationDataCreater = new TaxMapPopulationDataCreater(taxMapModel, bl);
        PieDataset pieDataset = taxMapPopulationDataCreater.createPieDataset();
        return pieDataset;
    }

    static Dataset createPropertyGraphDataset(ClusterTbl clusterTbl, TaxMapModel taxMapModel) throws Exception {
        boolean bl;
        AbstractInfoTitle abstractInfoTitle = taxMapModel.getSelectedInfoTitle();
        boolean bl2 = bl = !taxMapModel.isExistSelectedNode();
        if (taxMapModel.isFuncCatInfoTitle()) {
            TaxMapFuncCatDataCreater taxMapFuncCatDataCreater = new TaxMapFuncCatDataCreater(taxMapModel, clusterTbl, abstractInfoTitle, bl);
            DefaultCategoryDataset defaultCategoryDataset = taxMapFuncCatDataCreater.createDataset();
            return defaultCategoryDataset;
        }
        if (taxMapModel.isNumInfoTitle()) {
            TaxMapGraphNumDataCreater taxMapGraphNumDataCreater = new TaxMapGraphNumDataCreater(taxMapModel, abstractInfoTitle, bl);
            DefaultBoxAndWhiskerCategoryDataset defaultBoxAndWhiskerCategoryDataset = taxMapGraphNumDataCreater.createDataset();
            return defaultBoxAndWhiskerCategoryDataset;
        }
        TaxMapGraphTextDataCreater taxMapGraphTextDataCreater = new TaxMapGraphTextDataCreater(taxMapModel, abstractInfoTitle, bl);
        DefaultCategoryDataset defaultCategoryDataset = taxMapGraphTextDataCreater.createDataset();
        return defaultCategoryDataset;
    }
}

