/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.ClusterUtil;
import cgdp.recog.funccat.FuncCat;
import cgdp.recog.funccat.FuncCatTbl;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.taxonomy.map.AbstractDatasetCreater;
import cgdp.recog.taxonomy.map.AbstractRankScoreCalculater;
import cgdp.recog.taxonomy.map.TaxMapInfo;
import cgdp.recog.taxonomy.map.TaxMapModel;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.GeneUtil;
import cgdp.recog.util.MapUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jfree.data.category.DefaultCategoryDataset;

class TaxMapFuncCatDataCreater
extends AbstractDatasetCreater {
    private static final ApplicationLogger logger = new ApplicationLogger(TaxMapFuncCatDataCreater.class);
    private TaxMapModel taxMapModel;
    private ClusterTbl clusterTbl;
    private List keyList = new ArrayList();

    TaxMapFuncCatDataCreater(TaxMapModel taxMapModel, ClusterTbl clusterTbl, AbstractInfoTitle abstractInfoTitle) {
        super(abstractInfoTitle, false);
        this.taxMapModel = taxMapModel;
        this.clusterTbl = clusterTbl;
    }

    TaxMapFuncCatDataCreater(TaxMapModel taxMapModel, ClusterTbl clusterTbl, AbstractInfoTitle abstractInfoTitle, boolean bl) {
        super(abstractInfoTitle, bl);
        this.taxMapModel = taxMapModel;
        this.clusterTbl = clusterTbl;
    }

    DefaultCategoryDataset createDataset() {
        Object object;
        HashMap<String, Double> hashMap;
        Object object2;
        Object object32;
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        Map map = this.taxMapModel.getSelectNodeRankTaxMapInfoMap();
        HashMap<Object, Double> hashMap2 = new HashMap<Object, Double>();
        HashMap hashMap3 = new HashMap();
        HashSet hashSet = new HashSet();
        for (Object object32 : map.keySet()) {
            object2 = (List)map.get(object32);
            hashMap = this.createKeyScoreMap((List)object2, ((String)object32).equals("nohits") && this.taxMapModel.isAggregateMaxScoreInfo());
            double d = CollectionUtil.sum(hashMap.values());
            hashMap2.put(object32, new Double(d));
            hashSet.addAll(hashMap.keySet());
            hashMap3.put(object32, hashMap);
        }
        ArrayList arrayList = new ArrayList(hashMap2.keySet());
        Collections.sort(arrayList, new AbstractDatasetCreater.NameScoreComparator(hashMap2));
        object32 = new ArrayList(hashSet);
        Collections.sort(object32, new AbstractDatasetCreater.KeyComparator());
        object2 = FuncCatTbl.getInstance();
        hashMap = new HashMap<String, Double>();
        boolean bl = false;
        int n = 1;
        Object object4 = arrayList.iterator();
        while (object4.hasNext()) {
            object = (String)object4.next();
            if (TaxMapModel.isNoHitsCode((String)object)) {
                bl = true;
                continue;
            }
            Map map2 = (Map)hashMap3.get(object);
            if (this.taxMapModel.isDisplayRankOrder(n)) {
                this.addData((String)object, (List)object32, map2, defaultCategoryDataset, (FuncCatTbl)object2);
            } else {
                for (String string : map2.keySet()) {
                    Double d = (Double)map2.get(string);
                    Double d2 = (Double)hashMap.get(string);
                    double d3 = 0.0;
                    if (d2 != null) {
                        d3 += d2.doubleValue();
                    }
                    if (d != null) {
                        d3 += d.doubleValue();
                    }
                    hashMap.put(string, new Double(d3));
                }
            }
            ++n;
        }
        if (this.taxMapModel.isModeGeneCount() && this.taxMapModel.isUnassignedTaxMapInfoList() && this.taxMapModel.isShowUnassigned()) {
            object4 = this.taxMapModel.getUnassignedTaxMapInfoList();
            object = this.createKeyScoreMap((List)object4, false);
            this.addData("Unassigned", (List)object32, (Map)object, defaultCategoryDataset, (FuncCatTbl)object2);
        }
        if (this.taxMapModel.isModeScore() && this.taxMapModel.isShowHigherRank() && this.taxMapModel.isHigherRankTaxMapInfoList()) {
            object4 = this.taxMapModel.getHigherRankTaxMapInfoList();
            object = this.createKeyScoreMap((List)object4, false);
            this.addData("Higher rank", (List)object32, (Map)object, defaultCategoryDataset, (FuncCatTbl)object2);
        }
        if (!MapUtil.isNull(hashMap)) {
            this.addData("Other", (List)object32, hashMap, defaultCategoryDataset, (FuncCatTbl)object2);
        }
        if (bl) {
            object4 = (Map)hashMap3.get("nohits");
            this.addData("No hits", (List)object32, (Map)object4, defaultCategoryDataset, (FuncCatTbl)object2);
        }
        this.keyList = object32;
        return defaultCategoryDataset;
    }

    private Map createKeyScoreMap(List list, boolean bl) {
        HashMap hashMap = new HashMap();
        block0: for (TaxMapInfo taxMapInfo : list) {
            String string;
            String string2 = taxMapInfo.getOrganismCode();
            Cluster cluster = this.clusterTbl.getCluster(string2, string = taxMapInfo.getLocusTag());
            if (cluster != null) {
                String string3 = ClusterUtil.getFunctionCategoryNo(cluster, this.clusterTbl.isOutgroup());
                double d = AbstractRankScoreCalculater.calcScore(this.taxMapModel, taxMapInfo);
                this.addScore(string3, hashMap, d);
                continue;
            }
            int n = 1;
            while (true) {
                String string4;
                String string5;
                if ((cluster = this.clusterTbl.getCluster(string2, string5 = GeneUtil.combineLocusTagDomainNo(string, n))) == null) {
                    string4 = "Fail to decide the function category of " + string + ".";
                    logger.warn(string4);
                    continue block0;
                }
                string4 = ClusterUtil.getFunctionCategoryNo(cluster, this.clusterTbl.isOutgroup());
                double d = AbstractRankScoreCalculater.calcScore(this.taxMapModel, taxMapInfo);
                this.addScore(string4, hashMap, d);
                if (bl) continue block0;
                ++n;
            }
        }
        return hashMap;
    }

    private void addData(String string, List list, Map map, DefaultCategoryDataset defaultCategoryDataset, FuncCatTbl funcCatTbl) {
        String string2 = this.addRank(this.taxMapModel.getDisplayOrganismName(string));
        for (String string3 : list) {
            FuncCat funcCat = funcCatTbl.getFuncCat(string3);
            String string4 = string3 + " " + funcCat.getName();
            Double d = (Double)map.get(string3);
            if (d == null) {
                defaultCategoryDataset.addValue(0.0, (Comparable)((Object)string4), (Comparable)((Object)string2));
                continue;
            }
            double d2 = d;
            defaultCategoryDataset.addValue(d2, (Comparable)((Object)string4), (Comparable)((Object)string2));
        }
    }

    private void addScore(String string, Map map, double d) {
        double d2 = 0.0;
        if (map.containsKey(string)) {
            d2 = (Double)map.get(string);
        }
        map.put(string, new Double(d2 += d));
    }

    public List getKeyList() {
        return this.keyList;
    }
}

