/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.util.StringTool;

public class TaxMapInfo {
    static final String DELIMITER_ID = ".";
    static final String DELIMITER_OL = ":";
    private static final int NO_VALUE = Integer.MIN_VALUE;
    static final String ROOT = "root";
    private int clusterId = Integer.MIN_VALUE;
    private int subClusterId = Integer.MIN_VALUE;
    private String organismCode;
    private String locusTag;
    private String upperName;
    private double upperScore = -2.147483648E9;
    private double upperDist = -2.147483648E9;
    private String lowerName;
    private double lowerScore = -2.147483648E9;
    private double lowerDist = -2.147483648E9;

    public String getOrganismCode() {
        return this.organismCode;
    }

    public void setOrganismCode(String string) {
        this.organismCode = string;
    }

    public String getLocusTag() {
        return this.locusTag;
    }

    public void setLocusTag(String string) {
        this.locusTag = string;
    }

    String getKey() {
        if (TaxMapInfo.isNoValue(this.getSubClusterId())) {
            return String.valueOf(this.getClusterId());
        }
        return this.getClusterId() + DELIMITER_ID + this.getSubClusterId();
    }

    String getDisplayKey() {
        return "O" + this.getKey();
    }

    private int getClusterId() {
        return this.clusterId;
    }

    void setClusterId(int n) {
        this.clusterId = n;
    }

    private int getSubClusterId() {
        return this.subClusterId;
    }

    void setSubClusterId(int n) {
        this.subClusterId = n;
    }

    public String getUpperName() {
        return this.upperName;
    }

    public void setUpperName(String string) {
        this.upperName = string;
    }

    public double getUpperScore() {
        return this.upperScore;
    }

    public void setUpperScore(double d) {
        this.upperScore = d;
    }

    public double getUpperDist() {
        return this.upperDist;
    }

    public void setUpperDist(double d) {
        this.upperDist = d;
    }

    public String getLowerName() {
        return this.lowerName;
    }

    public void setLowerName(String string) {
        this.lowerName = string;
    }

    public double getLowerScore() {
        return this.lowerScore;
    }

    public void setLowerScore(double d) {
        this.lowerScore = d;
    }

    public double getLowerDist() {
        return this.lowerDist;
    }

    public void setLowerDist(double d) {
        this.lowerDist = d;
    }

    public static boolean isNoValue(double d) {
        return d == -2.147483648E9;
    }

    public static boolean isNoValue(String string) {
        return string.equals(String.valueOf(Integer.MIN_VALUE));
    }

    public boolean isSameUpperLowerRank() {
        if (StringTool.isNull(this.getUpperName()) || StringTool.isNull(this.getLowerName())) {
            return false;
        }
        return this.getUpperName().equals(this.getLowerName());
    }
}

