/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.taxonomy.map.TaxMapInfo;
import cgdp.recog.taxonomy.map.TaxMapModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class TaxMapInfoTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_NAMES = new String[]{"Cluster ID", "Organism", "LocusTag", "Lower Name", "Score", "Dist", "Upper Name", "Score", "Dist"};
    private TaxMapModel taxMapModel;
    private List taxMapInfoList = new ArrayList();

    TaxMapInfoTableModel(TaxMapModel taxMapModel) {
        this.taxMapModel = taxMapModel;
    }

    public List getTaxMapInfoList() {
        return this.taxMapInfoList;
    }

    public TaxMapInfo getTaxMapInfo(int n) {
        return (TaxMapInfo)this.taxMapInfoList.get(n);
    }

    public List getTaxMapInfoList(int[] nArray) {
        ArrayList<TaxMapInfo> arrayList = new ArrayList<TaxMapInfo>();
        for (int i = 0; i < nArray.length; ++i) {
            TaxMapInfo taxMapInfo = (TaxMapInfo)this.getTaxMapInfoList().get(nArray[i]);
            arrayList.add(taxMapInfo);
        }
        return arrayList;
    }

    public void setTaxMapInfoList(List list) {
        this.taxMapInfoList = list;
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    public Class getColumnClass(int n) {
        if (n == 4 || n == 5 || n == 7 || n == 8) {
            return Double.class;
        }
        return String.class;
    }

    @Override
    public int getRowCount() {
        return this.taxMapInfoList.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        TaxMapInfo taxMapInfo = (TaxMapInfo)this.taxMapInfoList.get(n);
        if (n2 == 0) {
            return taxMapInfo.getDisplayKey();
        }
        if (n2 == 1) {
            return taxMapInfo.getOrganismCode();
        }
        if (n2 == 2) {
            return taxMapInfo.getLocusTag();
        }
        if (n2 == 3) {
            String string = taxMapInfo.getLowerName();
            return this.taxMapModel.getDisplayOrganismName(string);
        }
        if (n2 == 4) {
            double d = taxMapInfo.getLowerScore();
            if (TaxMapInfo.isNoValue(d)) {
                return null;
            }
            return new Double(d);
        }
        if (n2 == 5) {
            double d = taxMapInfo.getLowerDist();
            if (TaxMapInfo.isNoValue(d)) {
                return null;
            }
            return new Double(d);
        }
        if (n2 == 6) {
            String string = taxMapInfo.getUpperName();
            return this.taxMapModel.getDisplayOrganismName(string);
        }
        if (n2 == 7) {
            double d = taxMapInfo.getUpperScore();
            if (TaxMapInfo.isNoValue(d)) {
                return null;
            }
            return new Double(d);
        }
        if (n2 == 8) {
            double d = taxMapInfo.getUpperDist();
            if (TaxMapInfo.isNoValue(d)) {
                return null;
            }
            return new Double(d);
        }
        return null;
    }
}

