/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.taxonomy.map.AbstractDatasetCreater;
import cgdp.recog.taxonomy.map.TaxMapModel;
import cgdp.recog.util.LabelValue;
import java.util.List;
import java.util.Map;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.util.SortOrder;

class TaxMapPopulationDataCreater {
    private TaxMapModel taxMapModel;
    protected boolean displayRank = false;
    private Map nameRankMap;

    TaxMapPopulationDataCreater(TaxMapModel taxMapModel) {
        this.taxMapModel = taxMapModel;
    }

    TaxMapPopulationDataCreater(TaxMapModel taxMapModel, boolean bl) {
        this.taxMapModel = taxMapModel;
        this.displayRank = bl;
        if (this.displayRank) {
            this.nameRankMap = AbstractDatasetCreater.createNameRankMap();
        }
    }

    PieDataset createPieDataset() {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        boolean bl = false;
        List list = this.taxMapModel.getSelectedNodeRankLabelValueList();
        int n = 1;
        double d = 0.0;
        for (LabelValue labelValue : list) {
            String string = AbstractDatasetCreater.addRank(this.taxMapModel.getDisplayOrganismName(labelValue.getLabel()), this.displayRank, this.nameRankMap);
            double d2 = ((Number)((Object)labelValue.getValue())).doubleValue();
            if (TaxMapModel.isNoHitsCode(string)) {
                bl = true;
                continue;
            }
            if (this.taxMapModel.isDisplayRankOrder(n)) {
                defaultPieDataset.setValue((Comparable)((Object)string), d2);
            } else {
                d += d2;
            }
            ++n;
        }
        defaultPieDataset.sortByValues(SortOrder.DESCENDING);
        if (this.taxMapModel.isModeGeneCount() && this.taxMapModel.isUnassignedTaxMapInfoList() && this.taxMapModel.isShowUnassigned()) {
            defaultPieDataset.setValue((Comparable)((Object)"Unassigned"), this.taxMapModel.getUnassignedTaxMapInfoScore());
        }
        if (this.taxMapModel.isModeScore() && this.taxMapModel.isShowHigherRank() && this.taxMapModel.isHigherRankTaxMapInfoList()) {
            defaultPieDataset.setValue((Comparable)((Object)"Higher rank"), this.taxMapModel.getHigherRankTaxMapInfoListScore());
        }
        if (d != 0.0) {
            defaultPieDataset.setValue((Comparable)((Object)"Other"), d);
        }
        if (bl) {
            double d3 = this.taxMapModel.getTotalScore("nohits");
            defaultPieDataset.setValue((Comparable)((Object)"No hits"), d3);
        }
        return defaultPieDataset;
    }
}

