/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.info.LocationComboBox;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.info.gene.GeneInfoUtil;
import cgdp.recog.taxonomy.map.TaxMapPropertyCondition;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.FocusTextField;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class TaxMapPropertyDialog
extends AbstractApplyDialog {
    private static final String TITLE = "Register gene property";
    private FocusTextField nameTextField;
    private LocationComboBox locationComboBox;
    private JRadioButton lowerButton;
    private JRadioButton upperButton;
    private GeneInfoTitle templateGeneInfoTitle;

    private TaxMapPropertyDialog(Frame frame) {
        super(frame);
        this.createComponents();
    }

    private TaxMapPropertyDialog(Dialog dialog) {
        super(dialog);
        this.createComponents();
    }

    public static TaxMapPropertyDialog getInstance(Component component) {
        if (component instanceof Frame) {
            return new TaxMapPropertyDialog((Frame)component);
        }
        if (component instanceof Dialog) {
            return new TaxMapPropertyDialog((Dialog)component);
        }
        return null;
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(true);
        JLabel jLabel = new JLabel("Name");
        this.nameTextField = new FocusTextField(30);
        JLabel jLabel2 = new JLabel("Location");
        this.locationComboBox = new LocationComboBox();
        JPanel jPanel = this.createTargetPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Target"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 5, 10), 0, 0));
        this.getContentPane().add((Component)this.nameTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(10, 0, 0, 15), 0, 0));
        this.getContentPane().add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 5, 10), 0, 0));
        this.getContentPane().add((Component)this.locationComboBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(10, 0, 5, 15), 0, 0));
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 15, 0, 15), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 0, new Insets(10, 15, 10, 15), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel createTargetPanel() {
        this.lowerButton = new JRadioButton("Lower");
        this.upperButton = new JRadioButton("Upper");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.lowerButton);
        buttonGroup.add(this.upperButton);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.lowerButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.upperButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    public void updateValue(GeneInfoTitle geneInfoTitle, String string, boolean bl) {
        this.templateGeneInfoTitle = geneInfoTitle;
        String string2 = GeneInfoUtil.getDefaultGeneInfoTitleName(geneInfoTitle.getName());
        this.nameTextField.setText(GeneInfoUtil.getDefaultGeneInfoTitleName(string2));
        this.locationComboBox.updateLocationConboBox();
        this.locationComboBox.setSelectedItem(string);
        this.lowerButton.setSelected(bl);
        this.upperButton.setSelected(!bl);
    }

    private String getPropertyName() {
        return this.nameTextField.getText();
    }

    private String getLocationString() {
        return this.locationComboBox.getLocationString();
    }

    private GeneInfoTitle getGeneInfoTitle() {
        GeneInfoTitle geneInfoTitle = GeneInfoFacade.getGeneInfoTitle(this.getPropertyName());
        if (geneInfoTitle != null) {
            return geneInfoTitle;
        }
        String string = this.getPropertyName();
        this.templateGeneInfoTitle.setName(string);
        this.templateGeneInfoTitle.setKey(string);
        this.templateGeneInfoTitle.setLocationName(this.getLocationString());
        return this.templateGeneInfoTitle;
    }

    private int getTargetType() {
        if (this.lowerButton.isSelected()) {
            return 1;
        }
        return 2;
    }

    public TaxMapPropertyCondition createCondition() {
        TaxMapPropertyCondition taxMapPropertyCondition = new TaxMapPropertyCondition();
        taxMapPropertyCondition.setInfoTitle(this.getGeneInfoTitle());
        taxMapPropertyCondition.setTargetType(this.getTargetType());
        return taxMapPropertyCondition;
    }

    @Override
    protected boolean check() {
        Object[] objectArray;
        if (StringTool.isNull(this.getPropertyName())) {
            MessageManager.showErrorMessage((Component)this, "Input name.");
            return false;
        }
        GeneInfoTitle geneInfoTitle = GeneInfoFacade.getGeneInfoTitle(this.getPropertyName());
        return geneInfoTitle == null || MessageManager.showConfirmMessage((Component)this, objectArray = new String[]{"You have already made gene property [" + this.getPropertyName() + "].", "Overwrite the gene property [" + this.getPropertyName() + "]?"});
    }

    @Override
    protected boolean apply() {
        return true;
    }
}

