/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.observer.ApplicationObserver;
import cgdp.recog.taxonomy.map.TaxMapModel;
import cgdp.recog.taxonomy.map.TaxMapViewHandler;
import cgdp.recog.util.ApplicationFrame;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;

class TaxMapViewDialog
extends ApplicationFrame
implements ActionListener {
    private TaxMapViewHandler handler;
    private TaxMapModel taxMapModel;
    private JComponent component;
    private JButton closeButton;
    private boolean scroll = false;

    TaxMapViewDialog(Component component, String string, JComponent jComponent, TaxMapModel taxMapModel, TaxMapViewHandler taxMapViewHandler) {
        this(component, string, jComponent, taxMapModel, taxMapViewHandler, false);
    }

    TaxMapViewDialog(Component component, String string, JComponent jComponent, TaxMapModel taxMapModel, TaxMapViewHandler taxMapViewHandler, boolean bl) {
        super(string);
        this.component = jComponent;
        this.taxMapModel = taxMapModel;
        this.handler = taxMapViewHandler;
        this.scroll = bl;
        this.createComponents();
        if (jComponent instanceof ApplicationObserver) {
            this.taxMapModel.addObserver((ApplicationObserver)((Object)jComponent));
        }
    }

    private void createComponents() {
        this.setResizable(true);
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(this);
        this.getContentPane().setLayout(new GridBagLayout());
        if (this.scroll) {
            JScrollPane jScrollPane = new JScrollPane(this.component, 20, 30);
            this.getContentPane().add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 15, 5, 15), 0, 0));
            jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
            jScrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        } else {
            this.getContentPane().add((Component)this.component, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 15, 5, 15), 0, 0));
        }
        this.getContentPane().add((Component)this.closeButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 15, 5, 15), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    protected boolean apply() {
        return true;
    }

    protected void exit() {
        if (this.component instanceof ApplicationObserver) {
            this.taxMapModel.deleteObserver((ApplicationObserver)((Object)this.component));
        }
        this.handler.disposeView();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.closeButton) {
            this.exit();
        }
    }
}

