/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.taxonomy.map.RankChangeEvent;
import cgdp.recog.taxonomy.map.TaxMapModel;
import cgdp.recog.util.RestrictTextField;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

class TopNRankDisplayPanel
extends JPanel
implements ActionListener {
    private static final int NO_VALUE = -1;
    private TaxMapModel taxMapModel;
    private JCheckBox checkBox;
    private RestrictTextField textField;

    TopNRankDisplayPanel() {
        this.createComponents();
    }

    private void createComponents() {
        this.checkBox = new JCheckBox("Top # rank");
        this.checkBox.addActionListener(this);
        this.textField = new RestrictTextField(3);
        this.textField.addActionListener(this);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.checkBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 10), 0, 0));
        this.add((Component)this.textField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
    }

    public void updateValue(TaxMapModel taxMapModel) {
        this.taxMapModel = taxMapModel;
        this.checkBox.setSelected(this.taxMapModel.isEnableMaxRankCount());
        this.textField.setText(String.valueOf(this.taxMapModel.getDisplayMaxRankCount()));
        this.textField.setEnabled(this.checkBox.isSelected());
    }

    private boolean isEnableDisplayMaxRankCount() {
        return this.checkBox.isSelected();
    }

    private int getDisplayMaxRankCount() {
        if (StringTool.isNull(this.textField.getText())) {
            return -1;
        }
        return Integer.parseInt(this.textField.getText());
    }

    private boolean isNoValue(int n) {
        return n == -1;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.textField) {
            int n = this.getDisplayMaxRankCount();
            if (this.isNoValue(n)) {
                return;
            }
            this.taxMapModel.setDisplayMaxRankCount(n);
            RankChangeEvent rankChangeEvent = new RankChangeEvent(this);
            this.taxMapModel.nodifyObservers(rankChangeEvent);
        } else if (actionEvent.getSource() == this.checkBox) {
            this.textField.setEnabled(this.isEnableDisplayMaxRankCount());
            this.taxMapModel.setEnableMaxRankCount(this.isEnableDisplayMaxRankCount());
            int n = this.getDisplayMaxRankCount();
            if (this.isNoValue(n)) {
                return;
            }
            this.taxMapModel.setDisplayMaxRankCount(n);
            RankChangeEvent rankChangeEvent = new RankChangeEvent(this);
            this.taxMapModel.nodifyObservers(rankChangeEvent);
        }
    }
}

