/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.tree;

import java.util.ArrayList;
import java.util.List;

public class Node {
    private static final String NS_LEFT = "[";
    private static final String NS_RIGHT = "]";
    private static final String NS_COMMA = ",";
    private static final String NS_COLON = ":";
    private static final String NS_SEMICOLON = ";";
    private int id;
    private String name;
    private Node parent;
    private Node node1;
    private Node node2;
    private double dist;

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Node getParent() {
        return this.parent;
    }

    public void setParent(Node node) {
        this.parent = node;
    }

    public Node getNode1() {
        return this.node1;
    }

    public boolean existNode1() {
        return this.node1 != null;
    }

    public void setNode1(Node node) {
        this.node1 = node;
        if (this.node1 != null) {
            node.setParent(this);
        }
    }

    public Node getNode2() {
        return this.node2;
    }

    public boolean existNode2() {
        return this.node2 != null;
    }

    public void setNode2(Node node) {
        this.node2 = node;
        if (this.node2 != null) {
            node.setParent(this);
        }
    }

    public void removeChildNode(Node node) {
        if (this.getNode1() != null && this.getNode1().equals(node)) {
            this.setNode1(null);
        } else if (this.getNode2() != null && this.getNode2().equals(node)) {
            this.setNode2(null);
        }
    }

    public void clearChildNode() {
        this.setNode1(null);
        this.setNode2(null);
    }

    public Node getRestChildNode() {
        Node node = null;
        if (this.getNode1() != null && this.getNode2() == null) {
            node = this.getNode1();
        } else if (this.getNode1() == null && this.getNode2() != null) {
            node = this.getNode2();
        }
        return node;
    }

    public void setNode(Node node) {
        if (this.getNode1() != null && this.getNode2() == null) {
            this.setNode2(node);
        } else if (this.getNode1() == null && this.getNode2() != null) {
            this.setNode1(node);
        }
    }

    public double getDist() {
        return this.dist;
    }

    public void setDist(double d) {
        this.dist = d;
    }

    public int getMaxDepth() {
        int n = 0;
        if (this.node1 != null) {
            n = this.node1.getMaxDepth();
        }
        int n2 = 0;
        if (this.node2 != null) {
            n2 = this.node2.getMaxDepth();
        }
        return Math.max(n, n2) + 1;
    }

    public boolean isLeaf() {
        return this.node1 == null && this.node2 == null;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public double getMaxDist() {
        double d = this.node1 != null ? this.node1.getMaxDist() : 0.0;
        double d2 = this.node2 != null ? this.node2.getMaxDist() : 0.0;
        double d3 = Math.max(d, d2);
        return d3 += this.getDist();
    }

    public int getChildCount() {
        int n = 0;
        if (this.node1 != null) {
            n += this.node1.getChildCount();
        }
        if (this.node2 != null) {
            n += this.node2.getChildCount();
        }
        if (this.isLeaf()) {
            ++n;
        }
        return n;
    }

    public String getTreeStructureString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.node1 != null && this.node2 != null) {
            stringBuffer.append(NS_LEFT);
        }
        if (this.node1 != null) {
            stringBuffer.append(this.node1.getTreeStructureString());
            stringBuffer.append(NS_COMMA);
        }
        if (this.node2 != null) {
            stringBuffer.append(this.node2.getTreeStructureString());
        }
        if (this.node1 != null && this.node2 != null) {
            stringBuffer.append(NS_RIGHT);
        }
        if (this.isRoot()) {
            stringBuffer.append(NS_SEMICOLON);
        } else {
            if (this.getName() != null) {
                stringBuffer.append(this.getName());
            }
            stringBuffer.append(NS_COLON);
            stringBuffer.append(this.getDist());
        }
        return stringBuffer.toString();
    }

    public List getLeafNodeList() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (this.node1 != null) {
            arrayList.addAll(this.node1.getLeafNodeList());
            if (this.node1.isLeaf()) {
                arrayList.add(this.node1);
            }
        }
        if (this.node2 != null) {
            arrayList.addAll(this.node2.getLeafNodeList());
            if (this.node2.isLeaf()) {
                arrayList.add(this.node2);
            }
        }
        return arrayList;
    }

    public void copy(Node node) {
        this.setDist(node.getDist());
        this.setId(node.getId());
        this.setName(node.getName());
        this.setNode1(node.getNode1());
        this.setNode2(node.getNode2());
        this.setParent(node.getParent());
    }
}

