/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.tree;

import cgdp.recog.hcluster.tree.ClusterNode;
import cgdp.recog.tree.Node;
import cgdp.recog.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class NodeUtil {
    private NodeUtil() {
    }

    public static void filterClusterNode(Node node, Collection collection) {
        Node node2;
        if (node.isLeaf() && !collection.contains(node.getName()) && (node2 = node.getParent()) != null) {
            Node node3 = node2.getParent();
            if (node3 != null) {
                node2.removeChildNode(node);
                node3.removeChildNode(node2);
                Node node4 = node2.getRestChildNode();
                node4.setDist(node4.getDist() + node2.getDist());
                node3.setNode(node4);
            } else {
                node2.removeChildNode(node);
                Node node5 = node2.getRestChildNode();
                node2.copy(node5);
                node2.setParent(null);
                NodeUtil.filterClusterNode(node2, collection);
            }
        }
        if (node.getNode1() != null) {
            NodeUtil.filterClusterNode(node.getNode1(), collection);
        }
        if (node.getNode2() != null) {
            NodeUtil.filterClusterNode(node.getNode2(), collection);
        }
    }

    public static void aggregatePatternNode(Node node, Map map) {
        boolean bl = false;
        while (!bl) {
            bl = NodeUtil.aggregatePatternNodeCore(node, map, true);
        }
    }

    private static boolean aggregatePatternNodeCore(Node node, Map map, boolean bl) {
        Node node2;
        if (node.isLeaf() && (node2 = node.getParent()) != null) {
            ClusterNode clusterNode = (ClusterNode)node2.getNode1();
            ClusterNode clusterNode2 = (ClusterNode)node2.getNode2();
            if (clusterNode != null && !clusterNode.isLeaf()) {
                return bl;
            }
            if (clusterNode2 != null && !clusterNode2.isLeaf()) {
                return bl;
            }
            if (clusterNode != null && clusterNode2 != null && ((Object)clusterNode.getPatternMap()).equals(clusterNode2.getPatternMap())) {
                ClusterNode clusterNode3 = ClusterNode.createClusterNode(clusterNode);
                HashSet hashSet = new HashSet(clusterNode.getClusterSet());
                hashSet.addAll(clusterNode2.getClusterSet());
                clusterNode3.setClusterSet(hashSet);
                clusterNode3.setPatternMap(clusterNode.getPatternMap());
                HashSet hashSet2 = new HashSet(clusterNode.getClusterIdSet());
                hashSet2.addAll(clusterNode2.getClusterIdSet());
                clusterNode3.setClusterIdSet(hashSet2);
                Node node3 = node2.getParent();
                if (node3 != null) {
                    node2.removeChildNode(clusterNode);
                    node2.removeChildNode(clusterNode2);
                    node3.removeChildNode(node2);
                    clusterNode3.setDist(clusterNode3.getDist() + node2.getDist());
                    node3.setNode(clusterNode3);
                } else {
                    node2.copy(clusterNode3);
                    node2.setParent(null);
                    NodeUtil.aggregatePatternNodeCore(node2, map, bl);
                }
                bl = false;
            }
        }
        if (node.getNode1() != null) {
            bl = NodeUtil.aggregatePatternNodeCore(node.getNode1(), map, bl);
        }
        if (node.getNode2() != null) {
            bl = NodeUtil.aggregatePatternNodeCore(node.getNode2(), map, bl);
        }
        return bl;
    }

    public static List getLeafNodeList(Node node) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        arrayList.add(node);
        return NodeUtil.getLeafNodeList(arrayList);
    }

    public static List getLeafNodeList(List list) {
        ArrayList arrayList = new ArrayList();
        for (Node node : list) {
            NodeUtil.getLeafNodeList(node, arrayList);
        }
        return arrayList;
    }

    private static void getLeafNodeList(Node node, List list) {
        if (node.isLeaf()) {
            list.add(node);
        }
        if (node.existNode1()) {
            NodeUtil.getLeafNodeList(node.getNode1(), list);
        }
        if (node.existNode2()) {
            NodeUtil.getLeafNodeList(node.getNode2(), list);
        }
    }

    public static double calcMaxDist(List list) {
        double d = 0.0;
        for (Node node : list) {
            d = Math.max(d, node.getMaxDist());
        }
        return d;
    }

    public static void setAggregateMode(boolean bl, List list) {
        for (ClusterNode clusterNode : list) {
            clusterNode.setAggregateMode(bl);
        }
    }

    public static void adjustDist(List list) {
        HashSet hashSet = new HashSet(list);
        do {
            HashSet<Node> hashSet2 = new HashSet<Node>();
            HashSet<Node> hashSet3 = new HashSet<Node>();
            for (Node node : hashSet) {
                double d;
                if (node.isRoot()) {
                    hashSet3.add(node);
                    break;
                }
                Node node2 = node.getParent();
                Node node3 = node2.getNode1();
                Node node4 = node2.getNode2();
                if (!hashSet.contains(node3) || !hashSet.contains(node4) || hashSet3.contains(node3) || hashSet3.contains(node4)) continue;
                double d2 = node3.getMaxDist();
                if (d2 < (d = node4.getMaxDist())) {
                    node3.setDist(node3.getDist() + (d - d2));
                } else if (d2 > d) {
                    node4.setDist(node4.getDist() + (d2 - d));
                }
                if (!node2.isRoot()) {
                    hashSet2.add(node2);
                }
                hashSet3.add(node3);
                hashSet3.add(node4);
            }
            hashSet.removeAll(hashSet3);
            hashSet.addAll(hashSet2);
        } while (!hashSet.isEmpty());
    }

    public static void filterClusterNode(ClusterNode clusterNode, Collection collection) {
        if (clusterNode.isLeaf()) {
            HashSet hashSet = new HashSet(clusterNode.getClusterIdSet());
            hashSet.removeAll(collection);
            if (CollectionUtil.isNull(hashSet)) {
                Node node = clusterNode.getParent();
                if (node != null) {
                    Node node2 = node.getParent();
                    if (node2 != null) {
                        node.removeChildNode(clusterNode);
                        node2.removeChildNode(node);
                        Node node3 = node.getRestChildNode();
                        node3.setDist(node3.getDist() + node.getDist());
                        node2.setNode(node3);
                    } else {
                        node.removeChildNode(clusterNode);
                        Node node4 = node.getRestChildNode();
                        node.copy(node4);
                        node.setParent(null);
                        NodeUtil.filterClusterNode(node, collection);
                    }
                }
            } else {
                clusterNode.setViewClusterIdSet(hashSet);
            }
        }
        if (clusterNode.getNode1() != null) {
            NodeUtil.filterClusterNode(clusterNode.getNode1(), collection);
        }
        if (clusterNode.getNode2() != null) {
            NodeUtil.filterClusterNode(clusterNode.getNode2(), collection);
        }
    }
}

