/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.update;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.update.VersionUpTask;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class ClientServerVersionUpTask
implements VersionUpTask {
    private Frame parent;
    private MediatorImpl mediator;
    private String clientVersion;
    private String serverVersion;
    private JCheckBox continueCheckUpdateCheckBox;

    public ClientServerVersionUpTask(Frame frame, MediatorImpl mediatorImpl, String string, String string2) {
        this.parent = frame;
        this.mediator = mediatorImpl;
        this.clientVersion = string;
        this.serverVersion = string2;
    }

    @Override
    public void run() {
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        JEditorPane jEditorPane = new JEditorPane("text/html", this.createMessage());
        jEditorPane.setEditable(false);
        jEditorPane.setOpaque(false);
        UpdateMessageHyperlinkListener updateMessageHyperlinkListener = new UpdateMessageHyperlinkListener();
        jEditorPane.addHyperlinkListener(updateMessageHyperlinkListener);
        this.continueCheckUpdateCheckBox = new JCheckBox("In the future, this message should not be displayed");
        this.continueCheckUpdateCheckBox.setSelected(!optionValues.isShowVersionUp());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jEditorPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(10, 10, 0, 10), 0, 0));
        jPanel.add((Component)this.continueCheckUpdateCheckBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 15, 10, 10), 0, 0));
        MessageManager.showMessage((Component)this.parent, jPanel);
        optionValues.setShowVersionUp(!this.continueCheckUpdateCheckBox.isSelected());
    }

    private String createMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<HTML>");
        if (!StringTool.isNull(this.clientVersion)) {
            stringBuffer.append("RECOG Client Version (" + this.clientVersion + ") Released!");
            stringBuffer.append("<BR>");
        }
        if (!StringTool.isNull(this.serverVersion)) {
            stringBuffer.append("RECOG Server Version (" + this.serverVersion + ") Released!");
            stringBuffer.append("<BR>");
        }
        String string = OptionTbl.getInstance().getOptionValues().getUpdateSiteURL();
        stringBuffer.append("You can get from <a href='" + string + "'>the download site</a>");
        stringBuffer.append("<BR>");
        stringBuffer.append("</HTML>");
        return stringBuffer.toString();
    }

    @Override
    public boolean equalsTask(VersionUpTask versionUpTask) {
        return versionUpTask instanceof ClientServerVersionUpTask;
    }

    private class UpdateMessageHyperlinkListener
    implements HyperlinkListener {
        private UpdateMessageHyperlinkListener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            if (hyperlinkEvent.getDescription().equals("UpdateData")) {
                ClientServerVersionUpTask.this.mediator.updateDatasWithConfirm();
            } else {
                String string = hyperlinkEvent.getURL().toString();
                ClientServerVersionUpTask.this.mediator.viewUrl(string);
            }
        }
    }
}

