/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.url;

import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.server.AccessServer;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GeneUrl {
    public static final String PLACEHOLDER_PREFIX = "#";
    public static final String PH_EXEC_SERVER = "#exec_dclst_url";
    private static final String NAME_MBGD_GENE_ANNOTATION = "MBGD Gene Information";
    private static final String NAME_MBGD_CLUSTER_ANNOTATION = "MBGD Cluster Information";
    static final String DELIMITER_KEY = ";";
    private String name;
    private String urlTemplate;
    private List keyList = new ArrayList();
    private boolean def;

    public GeneUrl() {
    }

    public GeneUrl(String string, String string2, List list, boolean bl) {
        this.setName(string);
        this.setUrlTemplate(string2);
        this.setKeyList(list);
        this.setDef(bl);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getUrlTemplate() {
        return this.urlTemplate;
    }

    public void setUrlTemplate(String string) {
        this.urlTemplate = string;
    }

    public String getUrl(List list) {
        String string = this.getUrlTemplate();
        AccessServer accessServer = AccessServer.getInstance();
        string = string.replaceAll(PH_EXEC_SERVER, accessServer.getServerUrlWithoutHttp());
        int n = 1;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = String.valueOf(iterator.next());
            string = string.replaceAll(PLACEHOLDER_PREFIX + n, string2);
            ++n;
        }
        return string;
    }

    boolean validatePlaceHolder() {
        int n = 0;
        while (true) {
            String string = PLACEHOLDER_PREFIX + (n + 1);
            if (this.getUrlTemplate().indexOf(string) == -1) break;
            ++n;
        }
        return this.getKeySize() == n;
    }

    public List getKeyList() {
        return this.keyList;
    }

    public int getKeySize() {
        return this.keyList.size();
    }

    private List getKeyNameList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AbstractInfoTitle abstractInfoTitle : this.getKeyList()) {
            arrayList.add(abstractInfoTitle.getName());
        }
        return arrayList;
    }

    public String getKeyString() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AbstractInfoTitle abstractInfoTitle : this.getKeyList()) {
            arrayList.add(abstractInfoTitle.getKey());
        }
        return StringTool.conbineStrList(arrayList, DELIMITER_KEY);
    }

    public String getClsString() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AbstractInfoTitle abstractInfoTitle : this.getKeyList()) {
            arrayList.add(String.valueOf(abstractInfoTitle.getCls()));
        }
        return StringTool.conbineStrList(arrayList, DELIMITER_KEY);
    }

    public String getKeyNameString() {
        List list = this.getKeyNameList();
        return StringTool.conbineStrList(list, DELIMITER_KEY);
    }

    public void setKeyList(List list) {
        this.keyList = list;
    }

    public void addKey(AbstractInfoTitle abstractInfoTitle) {
        this.keyList.add(abstractInfoTitle);
    }

    public boolean isDef() {
        return this.def;
    }

    public void setDef(boolean bl) {
        this.def = bl;
    }

    public boolean isMBGDGeneAnnotationUrl() {
        return this.getName().equals(NAME_MBGD_GENE_ANNOTATION);
    }

    public boolean isMBGDClusterAnnotation() {
        return this.getName().equals(NAME_MBGD_CLUSTER_ANNOTATION);
    }

    public boolean equalsGeneUrl(GeneUrl geneUrl) {
        return this.getName().equals(geneUrl.getName());
    }

    public void copy(GeneUrl geneUrl) {
        this.setName(geneUrl.getName());
        this.setUrlTemplate(geneUrl.getUrlTemplate());
        this.setDef(geneUrl.isDef());
        this.setKeyList(geneUrl.getKeyList());
    }
}

