/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.url;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.DataManager;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.cluster.ClusterInfo;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.project.Project;
import cgdp.recog.url.GeneUrl;
import cgdp.recog.url.GeneUrlExporter;
import cgdp.recog.url.GeneUrlImporter;
import cgdp.recog.url.GeneUrlItem;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class GeneUrlFacade {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneUrlFacade.class);

    public static void createDefaultGeneUrlFile() throws Exception {
        String string = DataManager.getProjectGeneUrlFilepath();
        if (new File(string).isFile()) {
            return;
        }
        GeneUrl geneUrl = GeneUrlFacade.createGeneAnnotationUrl();
        GeneUrl geneUrl2 = GeneUrlFacade.createClusterAnnotationUrl();
        geneUrl.setDef(true);
        geneUrl2.setDef(false);
        ArrayList<GeneUrl> arrayList = new ArrayList<GeneUrl>();
        arrayList.add(geneUrl);
        arrayList.add(geneUrl2);
        GeneUrlExporter geneUrlExporter = new GeneUrlExporter(string, arrayList);
        geneUrlExporter.execute();
    }

    public static GeneUrl createGeneAnnotationUrl() {
        GeneUrl geneUrl = new GeneUrl();
        geneUrl.setName("MBGD Gene Information");
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        String string = "http://#exec_dclst_url" + optionValues.getGeneAnnotationUrl();
        geneUrl.setUrlTemplate(string);
        geneUrl.addKey(GeneInfoTitle.TITLE_ORGANISM_CODE);
        geneUrl.addKey(GeneInfoTitle.TITLE_LOCUSTAG_SERVER);
        ClusterInfoTitle clusterInfoTitle = ClusterInfoFacade.getInfoTitle("domclust_id");
        geneUrl.addKey(clusterInfoTitle);
        geneUrl.setDef(true);
        return geneUrl;
    }

    public static GeneUrl createClusterAnnotationUrl() {
        GeneUrl geneUrl = new GeneUrl();
        geneUrl.setName("MBGD Cluster Information");
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        String string = "http://#exec_dclst_url" + optionValues.getClusterAnnotationUrl();
        geneUrl.setUrlTemplate(string);
        geneUrl.addKey(ClusterInfoFacade.getInfoTitle("combine_clusterid"));
        ClusterInfoTitle clusterInfoTitle = ClusterInfoFacade.getInfoTitle("domclust_id");
        geneUrl.addKey(clusterInfoTitle);
        geneUrl.setDef(true);
        return geneUrl;
    }

    public static List getGeneUrlList() throws Exception {
        GeneUrlFacade.createDefaultGeneUrlFile();
        String string = DataManager.getProjectGeneUrlFilepath();
        GeneUrlImporter geneUrlImporter = new GeneUrlImporter(string);
        geneUrlImporter.execute();
        return geneUrlImporter.getGeneUrlList();
    }

    public static List getGeneUrlList(Project project) throws Exception {
        GeneUrlFacade.createDefaultGeneUrlFile();
        String string = DataManager.getProjectGeneUrlFilepath(project);
        GeneUrlImporter geneUrlImporter = new GeneUrlImporter(string);
        geneUrlImporter.execute();
        return geneUrlImporter.getGeneUrlList();
    }

    public static void saveGeneUrlList(List list) throws Exception {
        String string = DataManager.getProjectGeneUrlFilepath();
        GeneUrlFacade.saveGeneUrlList(string, list);
    }

    public static void saveGeneUrlList(String string, List list) throws Exception {
        GeneUrlExporter geneUrlExporter = new GeneUrlExporter(string, list);
        geneUrlExporter.execute();
    }

    private static final GeneUrl getDefaultGeneUrl() throws Exception {
        List list = GeneUrlFacade.getGeneUrlList();
        if (CollectionUtil.isNull(list)) {
            return null;
        }
        GeneUrl geneUrl = null;
        for (GeneUrl geneUrl2 : list) {
            if (!geneUrl2.isDef()) continue;
            geneUrl = geneUrl2;
            break;
        }
        if (geneUrl == null && !list.isEmpty()) {
            geneUrl = (GeneUrl)list.get(0);
        }
        return geneUrl;
    }

    public static String getDefaultUrl(ClusterTbl clusterTbl, String string, String string2) {
        try {
            GeneUrl geneUrl = GeneUrlFacade.getDefaultGeneUrl();
            List list = GeneUrlFacade.getValueList(geneUrl, clusterTbl, string, string2);
            return geneUrl.getUrl(list);
        }
        catch (Exception exception) {
            logger.warn("Fail to load url file.", exception);
            return null;
        }
    }

    private static List getValueList(GeneUrl geneUrl, ClusterTbl clusterTbl, String string, String string2) {
        try {
            Cluster cluster = clusterTbl.getCluster(string, string2);
            ClusterInfo clusterInfo = ClusterInfoFacade.createClusterInfo(clusterTbl, cluster, geneUrl.getKeyList());
            GeneInfo geneInfo = GeneInfoFacade.createGeneInfo(string, string2, geneUrl.getKeyList());
            HashMap hashMap = new HashMap();
            hashMap.putAll(clusterInfo.getValueMap());
            hashMap.putAll(geneInfo.getValueMap());
            ArrayList arrayList = new ArrayList();
            for (AbstractInfoTitle abstractInfoTitle : geneUrl.getKeyList()) {
                arrayList.add(hashMap.get(abstractInfoTitle));
            }
            return arrayList;
        }
        catch (Exception exception) {
            logger.warn("Fail to load url file.", exception);
            return new ArrayList();
        }
    }

    static String getGeneInfoUrl(GeneUrl geneUrl, ClusterTbl clusterTbl, String string, String string2) {
        List list = GeneUrlFacade.getValueList(geneUrl, clusterTbl, string, string2);
        return geneUrl.getUrl(list);
    }

    public static String getClusterInfoUrl(String string, String string2) {
        GeneUrl geneUrl = GeneUrlFacade.createClusterAnnotationUrl();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        arrayList.add(string);
        return geneUrl.getUrl(arrayList);
    }

    public static List createUrlMenuList(ActionListener actionListener, MediatorImpl mediatorImpl, ClusterTbl clusterTbl, String string, String string2) {
        try {
            List list = GeneUrlFacade.getGeneUrlList();
            ArrayList<GeneUrlItem> arrayList = new ArrayList<GeneUrlItem>();
            for (GeneUrl geneUrl : list) {
                GeneUrlItem geneUrlItem = new GeneUrlItem(actionListener, mediatorImpl, clusterTbl, geneUrl, string, string2);
                arrayList.add(geneUrlItem);
            }
            return arrayList;
        }
        catch (Exception exception) {
            logger.warn("Fail to load url file.", exception);
            return new ArrayList();
        }
    }
}

