/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.url;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.url.GeneUrl;
import cgdp.recog.url.GeneUrlFacade;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;

public class GeneUrlItem
extends JMenuItem
implements CommandImpl {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneUrlItem.class);
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private GeneUrl geneUrl;
    private String organismCode;
    private String locusTag;

    public GeneUrlItem(ActionListener actionListener, MediatorImpl mediatorImpl, ClusterTbl clusterTbl, GeneUrl geneUrl, String string, String string2) {
        super(geneUrl.getName());
        this.addActionListener(actionListener);
        this.mediator = mediatorImpl;
        this.clusterTbl = clusterTbl;
        this.geneUrl = geneUrl;
        this.organismCode = string;
        this.locusTag = string2;
    }

    @Override
    public void execute() {
        try {
            String string = GeneUrlFacade.getGeneInfoUrl(this.geneUrl, this.clusterTbl, this.organismCode, this.locusTag);
            this.mediator.viewUrl(string);
        }
        catch (Exception exception) {
            String string = "Fail to show gene information on the blowser.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.getParent(), string);
        }
    }
}

