/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.util;

import cgdp.recog.process.ProgressImpl;
import cgdp.recog.server.AccessServer;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.ServerConnection;
import cgdp.recog.util.ServerStatus;
import cgdp.recog.util.StringTool;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public abstract class AbstractServerConnection
implements ServerConnection {
    private static final ApplicationLogger logger = new ApplicationLogger(AbstractServerConnection.class);
    protected boolean debug = false;
    private String contextPath = "";
    private String options = "";
    private ProgressImpl progressImpl;
    private String serverStatus;
    private String message;
    private String errorNo;
    private String errorCode;
    private boolean httpError = false;
    private boolean displayLogOption = true;

    public void setProgressImpl(ProgressImpl progressImpl) {
        this.progressImpl = progressImpl;
    }

    public ProgressImpl getProgressImpl() {
        return this.progressImpl;
    }

    public boolean isCanceled() {
        if (this.progressImpl == null) {
            return false;
        }
        return this.progressImpl.isCanceled();
    }

    public void setContextPath(String string) {
        this.contextPath = string;
    }

    public void setOptions(String string) {
        System.err.println("###" + string);
        this.options = string;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getOptions() {
        return this.options;
    }

    protected String createUrl() {
        return this.getServerUrl() + this.getContextPath();
    }

    protected String getServerUrl() {
        String string = AccessServer.getInstance().getServerUrl();
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        return string;
    }

    protected void setServerStatus(String string) {
        this.serverStatus = string;
    }

    public boolean isError() {
        return ServerStatus.isError(this.serverStatus);
    }

    public void setError() {
        this.serverStatus = "error";
    }

    protected boolean isRunning() {
        return ServerStatus.isRunning(this.serverStatus);
    }

    protected boolean isFinish() {
        return ServerStatus.isFinish(this.serverStatus);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String string) {
        this.errorCode = string;
    }

    public String getErrorNo() {
        return this.errorNo;
    }

    public void setErrorNo(String string) {
        this.errorNo = string;
    }

    public boolean isDisplayLogOption() {
        return this.displayLogOption;
    }

    public void setDisplayLogOption(boolean bl) {
        this.displayLogOption = bl;
    }

    protected URLConnection postServer() throws IOException {
        String string = this.createUrl();
        logger.info("Server URL:" + string);
        URL uRL = new URL(string);
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDoOutput(true);
        OutputStream outputStream = uRLConnection.getOutputStream();
        PrintStream printStream = new PrintStream(outputStream);
        printStream.print(this.getOptions());
        printStream.close();
        if (!StringTool.isNull(this.getOptions()) && this.isDisplayLogOption()) {
            logger.info("Options : " + this.getOptions());
        }
        return uRLConnection;
    }

    public static boolean checkHttpStatus(URLConnection uRLConnection) throws IOException {
        if (!(uRLConnection instanceof HttpURLConnection)) {
            return true;
        }
        int n = ((HttpURLConnection)uRLConnection).getResponseCode();
        return n < 300;
    }

    protected void before() {
    }

    protected void after() {
    }

    protected boolean setParameter(String string) {
        if (!ServerStatus.isParameter(string)) {
            return false;
        }
        if (ServerStatus.isServerStatus(string)) {
            this.setServerStatus(ServerStatus.getServerStatus(string));
            return true;
        }
        if (ServerStatus.isServerStatus2(string)) {
            this.setMessage(ServerStatus.getMessage(string));
            return true;
        }
        if (ServerStatus.isErrorNo(string)) {
            this.setErrorNo(ServerStatus.getErrorNo(string));
            return true;
        }
        if (ServerStatus.isErrorCode(string)) {
            this.setErrorCode(ServerStatus.getErrorCode(string));
            return true;
        }
        return false;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }
}

