/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CollectionUtil {
    public static boolean isNull(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static Object median(List list) {
        return CollectionUtil.median(list, null);
    }

    public static Object median(List list, Comparator comparator) {
        return CollectionUtil.median(list, comparator, true);
    }

    private static Object median(List list, Comparator comparator, boolean bl) {
        if (CollectionUtil.isNull(list)) {
            return null;
        }
        ArrayList arrayList = bl ? CollectionUtil.removeNaNInfinity(list) : new ArrayList(list);
        if (CollectionUtil.isNull(arrayList)) {
            return null;
        }
        if (comparator != null) {
            Collections.sort(arrayList, comparator);
        } else {
            Collections.sort(arrayList);
        }
        Number number = null;
        Object e = arrayList.get(0);
        if (e instanceof Number) {
            int n = arrayList.size();
            if (n % 2 == 0) {
                int n2 = (int)((double)n / 2.0) - 1;
                n2 = n2 < 0 ? 0 : n2;
                int n3 = (int)((double)n / 2.0);
                Number number2 = (Number)arrayList.get(n2);
                Number number3 = (Number)arrayList.get(n3);
                number = number2 instanceof Float ? (Number)new Float((number2.doubleValue() + number3.doubleValue()) / 2.0) : (Number)new Double((number2.doubleValue() + number3.doubleValue()) / 2.0);
            } else {
                int n4 = (int)((double)n / 2.0);
                number = (Number)arrayList.get(n4);
            }
        } else {
            int n = arrayList.size();
            int n5 = (int)((double)n / 2.0);
            number = (Number)arrayList.get(n5);
        }
        return number;
    }

    public static double sum(Collection collection) {
        return CollectionUtil.sum(collection, true);
    }

    public static double sum(Collection collection, boolean bl) {
        double d = 0.0;
        for (Object e : collection) {
            if (!(e instanceof Number)) continue;
            double d2 = ((Number)e).doubleValue();
            if (bl && Double.isNaN(d2)) continue;
            d += ((Number)e).doubleValue();
        }
        return d;
    }

    public static double average(Collection collection) {
        if (CollectionUtil.isAllNaN(collection)) {
            return Double.NaN;
        }
        int n = 0;
        double d = 0.0;
        for (Object e : collection) {
            double d2;
            if (e == null || !(e instanceof Number) || Double.isNaN(d2 = ((Number)e).doubleValue())) continue;
            d += ((Number)e).doubleValue();
            ++n;
        }
        if (n == 0) {
            return d;
        }
        return d / (double)n;
    }

    public static Set getMoreValue(Collection collection, double d) {
        HashSet hashSet = new HashSet();
        for (Object e : collection) {
            double d2 = ((Number)e).doubleValue();
            if (!(d2 > d)) continue;
            hashSet.add(e);
        }
        return hashSet;
    }

    public static Set getLessValue(Collection collection, double d) {
        HashSet hashSet = new HashSet();
        for (Object e : collection) {
            double d2 = ((Number)e).doubleValue();
            if (!(d2 < d)) continue;
            hashSet.add(e);
        }
        return hashSet;
    }

    public static double variance(Collection collection) {
        return CollectionUtil.variance(collection, true);
    }

    public static double variance(Collection collection, boolean bl) {
        if (collection.size() <= 1) {
            return Double.NaN;
        }
        ArrayList arrayList = bl ? CollectionUtil.removeNaNInfinity(collection) : new ArrayList(collection);
        if (arrayList.size() <= 1) {
            return Double.NaN;
        }
        double d = arrayList.size();
        double d2 = CollectionUtil.average(collection);
        double d3 = 0.0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            double d4 = ((Number)iterator.next()).doubleValue();
            d3 += Math.pow(d4 - d2, 2.0);
        }
        return d3 / (d - 1.0);
    }

    public static List removeNaN(Collection collection) {
        ArrayList arrayList = new ArrayList();
        for (Object e : collection) {
            Number number;
            double d;
            if (!(e instanceof Number) || Double.isNaN(d = (number = (Number)e).doubleValue())) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public static List removeNaNInfinity(Collection collection) {
        ArrayList<Number> arrayList = new ArrayList<Number>();
        for (Object e : collection) {
            Number number;
            if (!(e instanceof Number) || Double.isNaN((number = (Number)e).doubleValue()) || Double.isInfinite(number.doubleValue())) continue;
            arrayList.add(number);
        }
        return arrayList;
    }

    public static boolean isAllNaN(Collection collection) {
        HashSet hashSet = new HashSet(collection);
        return hashSet.size() == 1 && hashSet.contains(new Double(Double.NaN));
    }
}

