/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.util;

import cgdp.recog.util.FocusTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class FileSelectPanel
extends JPanel
implements ActionListener {
    private FocusTextField pathTextField;
    private JButton fileSelectButton;
    private JFileChooser chooser;
    private FileFilter fileFilter;

    public FileSelectPanel() {
        this((FileFilter)null);
    }

    public FileSelectPanel(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
        this.init();
    }

    private void init() {
        this.pathTextField = new FocusTextField("");
        this.pathTextField.setColumns(30);
        this.fileSelectButton = new JButton("Select...");
        this.fileSelectButton.addActionListener(this);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.pathTextField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.fileSelectButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.chooser = new JFileChooser();
        this.chooser.setDialogTitle("Select file");
        if (this.fileFilter != null) {
            this.chooser.setFileFilter(this.fileFilter);
        }
    }

    private void showFileChooser() {
        this.beforeFileChooser();
        this.chooser.setSelectedFile(new File(this.getPath()));
        if (this.chooser.showOpenDialog(this.getParent()) == 0) {
            File file = this.chooser.getSelectedFile();
            this.pathTextField.setText(file.getAbsolutePath());
        }
    }

    public void setDefaultPath(String string) {
        if (string != null) {
            this.chooser.setSelectedFile(new File(string));
            this.pathTextField.setText(string);
        }
    }

    public void setFileSelectionMode(int n) {
        this.chooser.setFileSelectionMode(n);
    }

    public void addChoosableFileFilter(FileFilter fileFilter) {
        this.chooser.addChoosableFileFilter(fileFilter);
    }

    public void removeChoosableFileFilter(FileFilter fileFilter) {
        this.chooser.removeChoosableFileFilter(fileFilter);
    }

    public void setAcceptAllFileFilterUsed(boolean bl) {
        this.chooser.setAcceptAllFileFilterUsed(bl);
    }

    public String getPath() {
        return this.pathTextField.getText();
    }

    protected void beforeFileChooser() {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.fileSelectButton) {
            this.showFileChooser();
        }
    }
}

