/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.util;

import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class FileUtil {
    public static final String LINE_SEPARETOR = System.getProperty("line.separator");
    private static final DecimalFormat FILE_SIZE_FORMATTER = new DecimalFormat("###,###,###");
    private static final DateFormat FILE_DATE_FORMATTER = DateFormat.getDateTimeInstance(2, 2);

    public static void copyDir(File file, File file2, boolean bl) throws Exception {
        FileUtil.copyDir(file.getAbsolutePath(), file2.getAbsolutePath(), bl);
    }

    public static void copyDir(String string, String string2, boolean bl) throws Exception {
        File file = new File(string);
        File file2 = new File(string2);
        if (file2.isFile()) {
            return;
        }
        if (!file2.isDirectory()) {
            file2.mkdir();
        }
        if (file.isFile()) {
            String string3 = new File(string2, file.getName()).getAbsolutePath();
            FileUtil.copy(string, string3, bl);
        } else if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                File file3;
                File file4 = fileArray[i];
                if (file4.isFile()) {
                    file3 = new File(file2, file4.getName());
                    FileUtil.copy(file4, file3, bl);
                    continue;
                }
                if (!file4.isDirectory()) continue;
                file3 = new File(file2, file4.getName());
                FileUtil.copyDir(file4.getAbsolutePath(), file3.getAbsolutePath(), bl);
            }
        }
    }

    public static void copy(File file, File file2, boolean bl) throws Exception {
        FileUtil.copy(file.getAbsolutePath(), file2.getAbsolutePath(), bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(String string, String string2, boolean bl) throws Exception {
        Object object;
        if (!bl && ((File)(object = new File(string2))).isFile()) {
            return;
        }
        object = null;
        BufferedReader bufferedReader = null;
        FileOutputStream fileOutputStream = null;
        PrintWriter printWriter = null;
        try {
            String string3;
            object = new FileInputStream(string);
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
            fileOutputStream = new FileOutputStream(string2);
            printWriter = new PrintWriter(fileOutputStream);
            while ((string3 = bufferedReader.readLine()) != null) {
                printWriter.write(string3);
                printWriter.write(LINE_SEPARETOR);
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (object != null) {
                ((FileInputStream)object).close();
            }
            if (printWriter != null) {
                printWriter.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    public static String readFile(File file) throws IOException {
        return FileUtil.readFile(file.getAbsolutePath(), 0);
    }

    public static String readFile(String string) throws IOException {
        return FileUtil.readFile(string, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(String string, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            String string2;
            fileInputStream = new FileInputStream(string);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            int n2 = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (n2 < n) {
                    ++n2;
                    continue;
                }
                stringBuffer.append(string2);
                stringBuffer.append(LINE_SEPARETOR);
                ++n2;
            }
            String string3 = stringBuffer.toString();
            return string3;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    public static void outputFile(String string, File file) throws IOException {
        FileUtil.outputFile(string, file.getAbsolutePath());
    }

    public static void outputFile(String string, String string2) throws IOException {
        FileUtil.outputFile(string, string2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outputFile(String string, String string2, boolean bl) throws IOException {
        FileOutputStream fileOutputStream = null;
        PrintWriter printWriter = null;
        try {
            fileOutputStream = new FileOutputStream(string2, bl);
            printWriter = new PrintWriter(fileOutputStream);
            printWriter.print(string);
            printWriter.flush();
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    public static boolean createDirectory(String string) {
        File file = new File(string);
        if (file.isFile()) {
            return false;
        }
        if (!file.isDirectory()) {
            file.mkdirs();
        }
        return true;
    }

    public static String getFilename(String string) {
        File file = new File(string);
        return file.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readLine(String string, int n) throws IOException {
        String string2 = null;
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            String string3;
            fileInputStream = new FileInputStream(string);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            int n2 = 0;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (n2 == n) {
                    string2 = string3;
                    break;
                }
                ++n2;
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        return string2;
    }

    public static String getExtension(String string) {
        if (StringTool.isNull(string)) {
            return null;
        }
        int n = string.lastIndexOf(".");
        String string2 = new File(string).getParent();
        int n2 = -1;
        if (string2 != null) {
            n2 = string2.length();
        }
        if (n == -1) {
            return null;
        }
        if (n <= n2) {
            return null;
        }
        return string.substring(n + 1);
    }

    public static void delete(String string) {
        FileUtil.delete(new File(string));
    }

    public static void delete(File file) {
        if (file.isFile()) {
            file.delete();
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                FileUtil.delete(fileArray[i]);
                continue;
            }
            fileArray[i].delete();
        }
        file.delete();
    }

    public static String removeExtension(String string) {
        String string2 = FileUtil.getExtension(string);
        if (string2 == null) {
            return string;
        }
        int n = string.lastIndexOf(string2);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n - 1);
    }

    public static String addExtension(String string, String string2) {
        if (string.endsWith(string2)) {
            return string;
        }
        return string + string2;
    }

    public static String modifiedExtension(File file, String string) {
        return FileUtil.modifiedExtension(file.getAbsolutePath(), string);
    }

    public static String modifiedExtension(String string, String string2) {
        if (string2 == null) {
            return string;
        }
        String string3 = string;
        String string4 = FileUtil.getExtension(string);
        if (StringTool.isNull(string4) || !string4.equalsIgnoreCase(string2)) {
            string3 = FileUtil.removeExtension(string);
            string3 = string3 + string2;
        }
        return string3;
    }

    public static boolean validateOverwrite(Component component, String string) {
        File file = new File(string);
        return !file.exists() || MessageManager.showConfirmOverwriteMessage(component, file.getName());
    }

    public static String getDisplayFileSize(File file) {
        double d = file.length();
        int n = 0;
        while (d > 10240.0) {
            d /= 1024.0;
            ++n;
        }
        String string = "B";
        if (n == 1) {
            string = "KB";
        } else if (n == 2) {
            string = "MB";
        } else if (n == 3) {
            string = "GB";
        }
        return FILE_SIZE_FORMATTER.format(d) + " " + string;
    }

    public static String getLastUpdateDate(File file) {
        long l = file.lastModified();
        return FILE_DATE_FORMATTER.format(new Date(l));
    }

    public static void renameTo(String string, String string2) {
        new File(string).renameTo(new File(string2));
    }

    public static List listFiles(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (!file.isDirectory()) {
            arrayList.add(file);
            return arrayList;
        }
        FileUtil.listFiles(file, arrayList);
        return arrayList;
    }

    private static void listFiles(File file, List list) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                FileUtil.listFiles(file2, list);
                continue;
            }
            if (!file2.isFile()) continue;
            list.add(file2);
        }
    }

    public static int compareExtension(File file, File file2) {
        return FileUtil.compareExtensition(file.getName(), file2.getName());
    }

    public static int compareExtensition(String string, String string2) {
        return FileUtil.compare(FileUtil.getExtension(string), FileUtil.getExtension(string2));
    }

    public static int compare(String string, String string2) {
        return string.compareToIgnoreCase(string2);
    }

    public static void main(String[] stringArray) {
        try {
            String string = "C:/Documents and Settings/093031_101071/RECOG/data/test_alt.nibb.ac.jp_8036/";
            String string2 = "C:/Documents and Settings/093031_101071/RECOG/data/aaa/";
            FileUtil.copyDir(string, string2, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

