/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.util;

import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.Renderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import org.jfree.chart.encoders.EncoderUtil;
import org.jfree.chart.util.ResourceBundleWrapper;
import org.jfree.ui.ExtensionFileFilter;

public class ImageUtil {
    private static final ApplicationLogger logger = new ApplicationLogger(ImageUtil.class);
    protected static ResourceBundle localizationResources = ResourceBundleWrapper.getBundle("org.jfree.chart.LocalizationBundle");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doSaveAsPNG(Renderer renderer, int n, int n2, Component component) {
        block7: {
            try {
                File file;
                BufferedImage bufferedImage = new BufferedImage(n, n2, 5);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                graphics2D.setColor(Color.white);
                graphics2D.fillRect(0, 0, n, n2);
                renderer.draw(graphics2D);
                graphics2D.dispose();
                OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setCurrentDirectory(new File(optionValues.getUserExportDir()));
                ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter(localizationResources.getString("PNG_Image_Files"), ".png");
                jFileChooser.addChoosableFileFilter(extensionFileFilter);
                int n3 = jFileChooser.showSaveDialog(component);
                if (n3 != 0) break block7;
                String string = jFileChooser.getSelectedFile().getPath();
                if (!string.endsWith(".png")) {
                    string = string + ".png";
                }
                if ((file = new File(string)).isFile() && !MessageManager.showConfirmOverwriteMessage(component, string)) {
                    return;
                }
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(string)));
                try {
                    EncoderUtil.writeBufferedImage(bufferedImage, "png", bufferedOutputStream);
                    optionValues.setUserExportDir(file.getParent());
                }
                finally {
                    ((OutputStream)bufferedOutputStream).close();
                }
            }
            catch (IOException iOException) {
                String string = "Fail to save image.";
                logger.warn(string, iOException);
                MessageManager.showErrorMessage(component, string);
            }
        }
    }
}

