/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.util;

import cgdp.recog.util.LabelColor;
import cgdp.recog.util.ListControlTableModel;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class LabelColorTableModel
extends AbstractTableModel
implements ListControlTableModel {
    private static final String[] COLUMN_NAMES = new String[]{"Value", "Color"};
    private List labelColorList = new ArrayList();

    public void setLabelColorList(List list) {
        this.labelColorList = new ArrayList(list);
        this.fireTableDataChanged();
    }

    public List getLabelColorList() {
        return this.labelColorList;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return String.class;
        }
        if (n == 1) {
            return Color.class;
        }
        return String.class;
    }

    @Override
    public int getRowCount() {
        return this.labelColorList.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        LabelColor labelColor = (LabelColor)this.labelColorList.get(n);
        if (n2 == 0) {
            return labelColor.getLabel();
        }
        return labelColor.getColor();
    }

    public void setColor(int n, Color color) {
        LabelColor labelColor = (LabelColor)this.labelColorList.get(n);
        labelColor.setColor(color);
    }

    @Override
    public void swapData(int n, int n2) {
        Collections.swap(this.labelColorList, n, n2);
    }

    @Override
    public Object removeData(int n) {
        if (n < 0 || n >= this.getRowCount()) {
            throw new IllegalArgumentException("[ERROR:LabelColorTableModel]:Index is invalid.");
        }
        Object e = this.getLabelColorList().remove(n);
        this.fireTableRowsDeleted(this.getRowCount() - 1, this.getRowCount());
        return e;
    }

    @Override
    public void addData(Object object) {
        this.labelColorList.add(object);
        this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount());
    }

    @Override
    public int indexOf(Object object) {
        return this.labelColorList.indexOf(object);
    }

    @Override
    public Object getData(int n) {
        return this.labelColorList.get(n);
    }
}

