/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.util;

import cgdp.recog.util.AbstractListSelectTableModel;
import cgdp.recog.util.ListSelectUtil;
import cgdp.recog.util.ListTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ListSelectPanel
extends JPanel
implements ActionListener {
    private static final Dimension LIST_SIZE = new Dimension(100, 100);
    private JLabel candidateLabel;
    private JLabel selectLabel;
    private ListTable candidateListTable;
    private ListTable selectListTable;
    private final AbstractListSelectTableModel candidateTableModel;
    private final AbstractListSelectTableModel selectTableModel;
    private JButton selectButton;
    private JButton removeButton;
    private JButton upButton;
    private JButton downButton;
    private boolean showUpDown;

    public ListSelectPanel(AbstractListSelectTableModel abstractListSelectTableModel, AbstractListSelectTableModel abstractListSelectTableModel2) {
        this(abstractListSelectTableModel, abstractListSelectTableModel2, true);
    }

    public ListSelectPanel(AbstractListSelectTableModel abstractListSelectTableModel, AbstractListSelectTableModel abstractListSelectTableModel2, boolean bl) {
        this.candidateTableModel = abstractListSelectTableModel;
        this.selectTableModel = abstractListSelectTableModel2;
        this.showUpDown = bl;
        this.init();
    }

    private void init() {
        this.candidateLabel = new JLabel("Candidate:");
        this.candidateListTable = new ListTable(this.candidateTableModel){

            @Override
            protected void actionListSelectionListener(ListSelectionEvent listSelectionEvent) {
                if (this.isSelectLock()) {
                    return;
                }
                if (ListSelectPanel.this.selectListTable.getSelectedRowCount() != 0) {
                    ListSelectPanel.this.selectListTable.lockSelect();
                    ListSelectPanel.this.selectListTable.clearSelection();
                    ListSelectPanel.this.selectListTable.unlockSelect();
                }
                ListSelectPanel.this.setEnableButton();
            }

            @Override
            public String getTableToolTipText(MouseEvent mouseEvent) {
                return ListSelectPanel.this.getCandidateToolTipText(mouseEvent);
            }
        };
        this.candidateListTable.setViewPortPreferredSize(LIST_SIZE);
        this.selectLabel = new JLabel("Target:");
        this.selectListTable = new ListTable(this.selectTableModel){

            @Override
            protected void actionListSelectionListener(ListSelectionEvent listSelectionEvent) {
                if (this.isSelectLock()) {
                    return;
                }
                if (ListSelectPanel.this.candidateListTable.getSelectedRowCount() != 0) {
                    ListSelectPanel.this.candidateListTable.lockSelect();
                    ListSelectPanel.this.candidateListTable.clearSelection();
                    ListSelectPanel.this.candidateListTable.unlockSelect();
                }
                ListSelectPanel.this.setEnableButton();
            }

            @Override
            public String getTableToolTipText(MouseEvent mouseEvent) {
                return ListSelectPanel.this.getSelectToolTipText(mouseEvent);
            }
        };
        this.selectListTable.setViewPortPreferredSize(LIST_SIZE);
        this.selectButton = new JButton(">>");
        this.selectButton.addActionListener(this);
        this.removeButton = new JButton("<<");
        this.removeButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.selectButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.removeButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.upButton = new JButton("Up");
        this.upButton.addActionListener(this);
        this.downButton = new JButton("Down");
        this.downButton.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.add((Component)this.upButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)this.downButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.setVisible(this.showUpDown);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.candidateLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.candidateListTable, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.selectLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.selectListTable, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)jPanel2, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.setEnableButton();
    }

    protected String getSelectToolTipText(MouseEvent mouseEvent) {
        return null;
    }

    protected String getCandidateToolTipText(MouseEvent mouseEvent) {
        return null;
    }

    public void setCandidateColumnWidth(int n, int n2) {
        this.candidateListTable.setColumnWidth(n, n2);
    }

    public void setSelectColumnWidth(int n, int n2) {
        this.selectListTable.setColumnWidth(n, n2);
    }

    public void setCandidateSize(int n, int n2) {
        this.candidateListTable.setViewPortPreferredSize(new Dimension(n, n2));
    }

    public void setSelectSize(int n, int n2) {
        this.selectListTable.setViewPortPreferredSize(new Dimension(n, n2));
    }

    public void setCandidateRenderer(int n, TableCellRenderer tableCellRenderer) {
        this.candidateListTable.setRenderer(n, tableCellRenderer);
    }

    public void setSelectRenderer(int n, TableCellRenderer tableCellRenderer) {
        this.selectListTable.setRenderer(n, tableCellRenderer);
    }

    public void setCandidateEditor(int n, TableCellEditor tableCellEditor) {
        this.candidateListTable.setEditor(n, tableCellEditor);
    }

    public void setSelectEditor(int n, TableCellEditor tableCellEditor) {
        this.selectListTable.setEditor(n, tableCellEditor);
    }

    public void setCandidateCaption(String string) {
        if (string == null) {
            return;
        }
        this.candidateLabel.setText(string);
    }

    public void setSelectCaption(String string) {
        if (string == null) {
            return;
        }
        this.selectLabel.setText(string);
    }

    public List getCandidateL() {
        return this.candidateTableModel.getDataList();
    }

    public List getSelectL() {
        return this.selectTableModel.getDataList();
    }

    private void select() {
        List list = ListSelectUtil.remove(this.candidateListTable);
        ListSelectUtil.add(this.selectListTable, list);
        this.selectTableModel.selectAfter();
        this.candidateTableModel.selectAfter();
        ListSelectUtil.select(this.selectListTable, list);
        this.candidateListTable.updateView();
        this.selectListTable.updateView();
    }

    private void remove() {
        List list = ListSelectUtil.remove(this.selectListTable);
        ListSelectUtil.add(this.candidateListTable, list);
        this.selectTableModel.removeAfter();
        this.candidateTableModel.removeAfter();
        ListSelectUtil.select(this.candidateListTable, list);
        this.candidateListTable.updateView();
        this.selectListTable.updateView();
    }

    private void up() {
        ListSelectUtil.up(this.selectListTable);
        this.selectListTable.updateView();
    }

    private void down() {
        ListSelectUtil.down(this.selectListTable);
        this.selectListTable.updateView();
    }

    private void setEnableButton() {
        this.selectButton.setEnabled(this.candidateListTable.getSelectedRowCount() != 0);
        this.removeButton.setEnabled(this.selectListTable.getSelectedRowCount() != 0);
        int[] nArray = this.selectListTable.getSelectedRows();
        if (nArray != null && nArray.length != 0) {
            this.upButton.setEnabled(nArray[0] != 0);
            this.downButton.setEnabled(nArray[nArray.length - 1] != this.selectListTable.getRowCount() - 1);
        } else {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
    }

    public void setEnableComponents(boolean bl) {
        this.selectButton.setEnabled(bl);
        this.removeButton.setEnabled(bl);
        this.upButton.setEnabled(bl);
        this.downButton.setEnabled(bl);
        this.candidateLabel.setEnabled(bl);
        this.candidateListTable.setEnableComponents(bl);
        this.selectLabel.setEnabled(bl);
        this.selectListTable.setEnableComponents(bl);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.selectButton) {
            this.select();
        } else if (actionEvent.getSource() == this.removeButton) {
            this.remove();
        } else if (actionEvent.getSource() == this.upButton) {
            this.up();
        } else if (actionEvent.getSource() == this.downButton) {
            this.down();
        }
    }
}

