/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.util;

import java.util.BitSet;

public class MathUtil {
    private MathUtil() {
    }

    public static double roundDecimal(double d) {
        int n = MathUtil.getDecimalDisit(d);
        if (n == 0) {
            return d;
        }
        return MathUtil.roundDecimal(n, d);
    }

    public static double roundDecimal(double d, int n) {
        int n2 = MathUtil.getDecimalDisit(d);
        if (n2 == 0) {
            return d;
        }
        return MathUtil.roundDecimal(n, d);
    }

    public static double roundDecimal(int n, double d) {
        double d2 = Math.abs(d);
        double d3 = (int)(d / d2);
        return (double)((int)(d2 * Math.pow(10.0, n) + 0.5)) / Math.pow(10.0, n) * d3;
    }

    public static int getDecimalDisit(double d) {
        int n = 0;
        if (d == 0.0) {
            return n;
        }
        int n2 = 0;
        double d2 = Math.abs(d);
        if (d2 > 1.0) {
            n2 = (int)d2;
            d2 -= (double)n2;
        }
        if (d2 == 0.0) {
            return n;
        }
        while (d2 < 1.0) {
            d2 *= 10.0;
            ++n;
        }
        return n;
    }

    public static double getEfficientRound(double d, int n) {
        int n2 = MathUtil.getDigit(d);
        int n3 = n2 - n;
        if (Math.abs(d) < 1.0) {
            ++n3;
        }
        double d2 = Math.floor(d / Math.pow(10.0, n3) + 0.5);
        return d2 * Math.pow(10.0, n3);
    }

    public static int getDigit(double d) {
        int n = (int)Math.ceil(MathUtil.log10(Math.abs(d)));
        if (Math.abs(d) < 1.0) {
            --n;
        }
        return n;
    }

    public static double log10(double d) {
        return Math.log(d) / Math.log(10.0);
    }

    public static String getBitSetString(int n, BitSet bitSet) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (bitSet.get(i)) {
                stringBuffer.append("1");
                continue;
            }
            stringBuffer.append("0");
        }
        return stringBuffer.toString();
    }
}

