/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.util;

import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ServerStatus {
    private static final ApplicationLogger logger = new ApplicationLogger(ServerStatus.class);
    public static final String PARAMETER_PREFIX = "#";
    public static final String STATUS_KEY = "#STATUS";
    public static final String STATUS2_KEY = "#STATUS2";
    public static final String ERROR_NO_KEY = "#ERROR_NO";
    public static final String ERROR_CODE_KEY = "#ERROR_CODE";
    public static final String PROGRESS_KEY = "#PROGRESS";
    private static final String SPECIES_KEY = "#SPECIES";
    public static final String CLUSTER_ID_KEY = "#CLUSTER_ID";
    public static final String DOMCLUST_ID_KEY = "#DOMCLUST_ID";
    public static final String CLUSTER_VIEW_ID_KEY = "#CLUSTER_VIEW_ID";
    public static final String CORE_GENOME_ID_KEY = "#CORE_TAB_ID";
    public static final String N_CLUSTERS_KEY = "#N_CLUSTERS";
    public static final String N_CLUSTERS_DOM_KEY = "#N_CLUSTERS_DOM";
    public static final String TARGET_FILTERED_CLUSTER_LIST_KEY = "#TARGET_FILTERED_CLUSTER_LIST";
    public static final String N_SPECIES = "#N_SPECIES";
    public static final String INGROUP_KEY = "#INGROUP";
    public static final String OUTGROUP_KEY = "#OUTGROUP";
    public static final String MAP_SPECIES_KEY = "#MAP_SPECIES";
    public static final String EXEC_SERVER_KEY = "#EXEC_SERVER";
    public static final String EXEC_PORT_KEY = "#EXEC_PORT";
    public static final String EXEC_DATE_KEY = "#EXEC_DATE";
    public static final String ORIG_EXEC_SERVER_KEY = "#ORIG_EXEC_SERVER";
    public static final String ORIG_EXEC_PORT_KEY = "#ORIG_EXEC_PORT";
    public static final String QUERY_KEY = "#QUERY";
    public static final String DCLST_NAME_KEY = "#DCLST_NAME";
    public static final String MODIFIED_CLUSTER_KEY = "#MODIFIED_CLUSTER";
    private static final String START_DATA_KEY = "#START_DATA";
    private static final String FOR_VIEW_KEY = "#FOR_VIEW";
    public static final String DOMCLUST_COLUMN_PREFIX_KEY = "#COLUMN_";
    public static final String DOMCLUST_FORMAT_VER_KEY = "#FORMAT_VER";
    static final String STATUS_VALUE_RUNNING = "running";
    static final String STATUS_VALUE_ERROR = "error";
    private static final String STATUS_VALUE_FINISH = "finish";
    private static final String STATUS_VALUE_FINISHED = "finished";

    public static boolean isParameter(String string) {
        return ServerStatus.isIncludeString(string, PARAMETER_PREFIX);
    }

    public static boolean isServerStatus(String string) {
        return ServerStatus.isIncludeString(string, "#STATUS=");
    }

    public static boolean isServerStatus2(String string) {
        return ServerStatus.isIncludeString(string, "#STATUS2=");
    }

    public static boolean isErrorNo(String string) {
        return ServerStatus.isIncludeString(string, "#ERROR_NO=");
    }

    public static boolean isErrorCode(String string) {
        return ServerStatus.isIncludeString(string, "#ERROR_CODE=");
    }

    public static boolean isProgress(String string) {
        return ServerStatus.isIncludeString(string, "#PROGRESS=");
    }

    public static boolean isSpecies(String string) {
        return ServerStatus.isIncludeString(string, "#SPECIES=");
    }

    public static boolean isClusterId(String string) {
        return ServerStatus.isIncludeString(string, "#CLUSTER_ID=");
    }

    public static boolean isDomClustId(String string) {
        return ServerStatus.isIncludeString(string, "#DOMCLUST_ID=");
    }

    public static boolean isClusterViewId(String string) {
        return ServerStatus.isIncludeString(string, "#CLUSTER_VIEW_ID=");
    }

    public static boolean isCoreGenomeId(String string) {
        return ServerStatus.isIncludeString(string, "#CORE_TAB_ID=");
    }

    public static boolean isNClusters(String string) {
        return ServerStatus.isIncludeString(string, "#N_CLUSTERS=");
    }

    public static boolean isNClustersDom(String string) {
        return ServerStatus.isIncludeString(string, "#N_CLUSTERS_DOM=");
    }

    public static boolean isTargetFilteredClusterList(String string) {
        return ServerStatus.isIncludeString(string, "#TARGET_FILTERED_CLUSTER_LIST=");
    }

    public static boolean isDomClustColumn(String string) {
        return ServerStatus.isIncludeString(string, DOMCLUST_COLUMN_PREFIX_KEY);
    }

    public static boolean isFormatVer(String string) {
        return ServerStatus.isIncludeString(string, "#FORMAT_VER=");
    }

    public static boolean isIngroup(String string) {
        return ServerStatus.isIncludeString(string, "#INGROUP=");
    }

    public static boolean isOutgroup(String string) {
        return ServerStatus.isIncludeString(string, "#OUTGROUP=");
    }

    public static boolean isMapSpecies(String string) {
        return ServerStatus.isIncludeString(string, "#MAP_SPECIES=");
    }

    public static boolean isExecServer(String string) {
        return ServerStatus.isIncludeString(string, "#EXEC_SERVER=");
    }

    public static boolean isExecPort(String string) {
        return ServerStatus.isIncludeString(string, "#EXEC_PORT=");
    }

    public static boolean isExecDate(String string) {
        return ServerStatus.isIncludeString(string, "#EXEC_DATE=");
    }

    public static boolean isOrigExecServer(String string) {
        return ServerStatus.isIncludeString(string, "#ORIG_EXEC_SERVER=");
    }

    public static boolean isOrigExecPort(String string) {
        return ServerStatus.isIncludeString(string, "#ORIG_EXEC_PORT=");
    }

    public static boolean isQuery(String string) {
        return ServerStatus.isIncludeString(string, "#QUERY=");
    }

    public static boolean isDclstName(String string) {
        return ServerStatus.isIncludeString(string, "#DCLST_NAME=");
    }

    public static boolean isModifiedCluster(String string) {
        return ServerStatus.isIncludeString(string, "#MODIFIED_CLUSTER=");
    }

    public static boolean isStartData(String string) {
        return ServerStatus.isIncludeString(START_DATA_KEY, string);
    }

    public static boolean isIncludeString(String string, String string2) {
        if (StringTool.isNull(string)) {
            return false;
        }
        return string.indexOf(string2) != -1;
    }

    public static boolean isError(String string) {
        return ServerStatus.equalsString(string, STATUS_VALUE_ERROR);
    }

    public static boolean isRunning(String string) {
        return ServerStatus.equalsString(string, STATUS_VALUE_RUNNING);
    }

    public static boolean isFinish(String string) {
        return ServerStatus.equalsString(string, STATUS_VALUE_FINISH) || ServerStatus.equalsString(string, STATUS_VALUE_FINISHED);
    }

    public static boolean isForView(String string) {
        return ServerStatus.isIncludeString(string, FOR_VIEW_KEY);
    }

    private static boolean equalsString(String string, String string2) {
        if (StringTool.isNull(string)) {
            return false;
        }
        return string.equals(string2);
    }

    public static String getServerStatus(String string) {
        return ServerStatus.extractValue(STATUS_KEY, string);
    }

    public static String getServerStatus2(String string) {
        return ServerStatus.extractValue(STATUS2_KEY, string);
    }

    public static String getMessage(String string) {
        return ServerStatus.extractValue(STATUS2_KEY, string);
    }

    public static String getErrorNo(String string) {
        return ServerStatus.extractValue(ERROR_NO_KEY, string);
    }

    public static String getErrorCode(String string) {
        return ServerStatus.extractValue(ERROR_CODE_KEY, string);
    }

    public static int getProgressValue(String string) {
        String string2 = ServerStatus.extractValue(PROGRESS_KEY, string);
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            logger.warn("Fail to parse progress value. String -> Integer " + string2, numberFormatException);
        }
        return n;
    }

    public static List getSpeciesList(String string) {
        String string2 = ServerStatus.extractValue(SPECIES_KEY, string);
        return new ArrayList(StringTool.splitString(string2));
    }

    public static String getClusterId(String string) {
        return ServerStatus.extractValue(CLUSTER_ID_KEY, string);
    }

    public static String getDomClustId(String string) {
        return ServerStatus.extractValue(DOMCLUST_ID_KEY, string);
    }

    public static String getClusterViewId(String string) {
        return ServerStatus.extractValue(CLUSTER_VIEW_ID_KEY, string);
    }

    public static String getCoreGenomeId(String string) {
        return ServerStatus.extractValue(CORE_GENOME_ID_KEY, string);
    }

    public static int getNClusters(String string) {
        String string2 = ServerStatus.extractValue(N_CLUSTERS_KEY, string);
        int n = -1;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            logger.warn("Fail to parse NCluster value. String -> Integer " + n, numberFormatException);
        }
        return n;
    }

    public static int getNClustersDom(String string) {
        String string2 = ServerStatus.extractValue(N_CLUSTERS_DOM_KEY, string);
        int n = -1;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            logger.warn("Fail to parse NCluster Dom value. String -> Integer " + n, numberFormatException);
        }
        return n;
    }

    public static boolean getTargetFilteredClusterList(String string) {
        return new Boolean(ServerStatus.extractValue(TARGET_FILTERED_CLUSTER_LIST_KEY, string));
    }

    public static String getDomClustColumn(String string) {
        String string2 = null;
        if (!StringTool.isNull(string) && string.startsWith(DOMCLUST_COLUMN_PREFIX_KEY)) {
            string2 = string.substring(DOMCLUST_COLUMN_PREFIX_KEY.length() + 3);
        }
        return string2;
    }

    public static String getFormatVer(String string) {
        String string2 = ServerStatus.extractValue(DOMCLUST_FORMAT_VER_KEY, string);
        return string2;
    }

    public static List getIngroupList(String string) {
        String string2 = ServerStatus.extractValue(INGROUP_KEY, string);
        return new ArrayList(StringTool.splitString(string2));
    }

    public static List getOutgroupList(String string) {
        String string2 = ServerStatus.extractValue(OUTGROUP_KEY, string);
        return new ArrayList(StringTool.splitString(string2));
    }

    public static List getMapSpeciesList(String string) {
        String string2 = ServerStatus.extractValue(MAP_SPECIES_KEY, string);
        return new ArrayList(StringTool.splitString(string2));
    }

    public static String getExecServer(String string) {
        String string2 = ServerStatus.extractValue(EXEC_SERVER_KEY, string);
        return string2;
    }

    public static int getExecPort(String string) {
        String string2 = ServerStatus.extractValue(EXEC_PORT_KEY, string);
        int n = -1;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            logger.warn("Fail to parse exec port. String -> Integer " + string2, numberFormatException);
        }
        return n;
    }

    public static String getExecDate(String string) {
        String string2 = ServerStatus.extractValue(EXEC_DATE_KEY, string);
        return string2;
    }

    public static String getOrigExecServer(String string) {
        String string2 = ServerStatus.extractValue(ORIG_EXEC_SERVER_KEY, string);
        return string2;
    }

    public static int getOrigExecPort(String string) {
        String string2 = ServerStatus.extractValue(ORIG_EXEC_PORT_KEY, string);
        int n = -1;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            logger.warn("Fail to parse orig exec port. String -> Integer " + string2, numberFormatException);
        }
        return n;
    }

    public static String getQuery(String string) {
        String string2 = ServerStatus.extractValue(QUERY_KEY, string);
        return string2;
    }

    public static String getDclstName(String string) {
        String string2 = ServerStatus.extractValue(DCLST_NAME_KEY, string);
        return string2;
    }

    public static String getModifiedCluster(String string) {
        String string2 = ServerStatus.extractValue(MODIFIED_CLUSTER_KEY, string);
        return string2;
    }

    public static String extractValue(String string, String string2) {
        String string3 = "";
        if (!StringTool.isNull(string2) && string2.startsWith(string) && string2.length() >= string.length() + 1) {
            string3 = string2.substring(string.length() + 1);
        }
        return string3.trim();
    }

    public static String createFormatVarMessage(String string) {
        return ServerStatus.createParameterMessage(DOMCLUST_FORMAT_VER_KEY, string);
    }

    public static String createClusterIdMessage(String string) {
        return ServerStatus.createParameterMessage(CLUSTER_ID_KEY, string);
    }

    public static String createDomClustIdMessage(String string) {
        return ServerStatus.createParameterMessage(DOMCLUST_ID_KEY, string);
    }

    public static String createSpeciesMessage(Collection collection) {
        return ServerStatus.createParameterMessage(SPECIES_KEY, StringTool.conbineStrList(collection, ","));
    }

    public static String createIngroup(List list) {
        return ServerStatus.createParameterMessage(INGROUP_KEY, StringTool.conbineStrList(list, ","));
    }

    public static String createOutgroup(List list) {
        return ServerStatus.createParameterMessage(OUTGROUP_KEY, StringTool.conbineStrList(list, ","));
    }

    public static String createNClusters(int n) {
        return ServerStatus.createParameterMessage(N_CLUSTERS_KEY, String.valueOf(n));
    }

    public static String createClusterViewIdMessage(String string) {
        return ServerStatus.createParameterMessage(CLUSTER_VIEW_ID_KEY, string);
    }

    public static String createNSpecies(int n) {
        return ServerStatus.createParameterMessage(N_SPECIES, String.valueOf(n));
    }

    public static String createExecServer(String string) {
        return ServerStatus.createParameterMessage(EXEC_SERVER_KEY, string);
    }

    public static String createExecPort(int n) {
        return ServerStatus.createParameterMessage(EXEC_PORT_KEY, String.valueOf(n));
    }

    public static String createExecDate(String string) {
        return ServerStatus.createParameterMessage(EXEC_DATE_KEY, string);
    }

    public static String createOrigExecServer(String string) {
        return ServerStatus.createParameterMessage(ORIG_EXEC_SERVER_KEY, string);
    }

    public static String createOrigExecPort(int n) {
        return ServerStatus.createParameterMessage(ORIG_EXEC_PORT_KEY, String.valueOf(n));
    }

    public static String createQuery(String string) {
        return ServerStatus.createParameterMessage(QUERY_KEY, string);
    }

    public static String createTargetFilteredClusterList(boolean bl) {
        return ServerStatus.createParameterMessage(TARGET_FILTERED_CLUSTER_LIST_KEY, String.valueOf(bl).toLowerCase());
    }

    public static String createDclstName(String string) {
        return ServerStatus.createParameterMessage(DCLST_NAME_KEY, string);
    }

    public static String createModifiedCluster() {
        return ServerStatus.createParameterMessage(MODIFIED_CLUSTER_KEY, "Exist");
    }

    public static String createStartData() {
        return "##START_DATA";
    }

    public static String createForViewMessage() {
        return FOR_VIEW_KEY;
    }

    protected static String createParameterMessage(String string, String string2) {
        return string + "=" + string2;
    }

    public static String createParameterMessageAddPrefix(String string, String string2) {
        return PARAMETER_PREFIX + ServerStatus.createParameterMessage(string, string2);
    }
}

