/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.util.axis;

import cgdp.recog.util.axis.NumberTickUnit;
import cgdp.recog.util.axis.TickUnit;
import cgdp.recog.util.axis.TickUnitSource;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TickUnits
implements TickUnitSource,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1134174035901467545L;
    private List tickUnits = new ArrayList();

    public void add(TickUnit tickUnit) {
        if (tickUnit == null) {
            throw new NullPointerException("Null 'unit' argument.");
        }
        this.tickUnits.add(tickUnit);
        Collections.sort(this.tickUnits);
    }

    public int size() {
        return this.tickUnits.size();
    }

    public TickUnit get(int n) {
        return (TickUnit)this.tickUnits.get(n);
    }

    @Override
    public TickUnit getLargerTickUnit(TickUnit tickUnit) {
        int n = Collections.binarySearch(this.tickUnits, tickUnit);
        n = n >= 0 ? ++n : -n;
        return (TickUnit)this.tickUnits.get(Math.min(n, this.tickUnits.size() - 1));
    }

    @Override
    public TickUnit getCeilingTickUnit(TickUnit tickUnit) {
        int n = Collections.binarySearch(this.tickUnits, tickUnit);
        if (n >= 0) {
            return (TickUnit)this.tickUnits.get(n);
        }
        n = -(n + 1);
        return (TickUnit)this.tickUnits.get(Math.min(n, this.tickUnits.size() - 1));
    }

    @Override
    public TickUnit getCeilingTickUnit(double d) {
        return this.getCeilingTickUnit(new NumberTickUnit(d, NumberFormat.getInstance()));
    }

    public Object clone() throws CloneNotSupportedException {
        TickUnits tickUnits = (TickUnits)super.clone();
        tickUnits.tickUnits = new ArrayList(this.tickUnits);
        return tickUnits;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TickUnits)) {
            return false;
        }
        TickUnits tickUnits = (TickUnits)object;
        return ((Object)tickUnits.tickUnits).equals(this.tickUnits);
    }
}

