/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.style;

import com.lowagie.text.Font;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfColor;
import com.lowagie.text.rtf.style.RtfFontList;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfFont
extends Font
implements RtfExtendedElement {
    private static final byte[] FONT_FAMILY = "\\froman".getBytes();
    private static final byte[] FONT_CHARSET = "\\fcharset".getBytes();
    public static final byte[] FONT_SIZE = "\\fs".getBytes();
    private static final byte[] FONT_BOLD = "\\b".getBytes();
    private static final byte[] FONT_ITALIC = "\\i".getBytes();
    private static final byte[] FONT_UNDERLINE = "\\ul".getBytes();
    private static final byte[] FONT_STRIKETHROUGH = "\\strike".getBytes();
    public static final int STYLE_NONE = 0;
    public static final int STYLE_ITALIC = 1;
    public static final int STYLE_BOLD = 2;
    public static final int STYLE_UNDERLINE = 4;
    public static final int STYLE_STRIKETHROUGH = 8;
    private String fontName = "Times New Roman";
    private int fontSize = 10;
    private int fontStyle = 0;
    private int fontNumber = 0;
    private RtfColor color = null;
    private int charset = 0;
    private RtfDocument document = null;

    public RtfFont(String string) {
        super(-1, 12.0f, 0, new Color(0, 0, 0));
        this.fontName = string;
    }

    public RtfFont(String string, float f) {
        super(-1, f, 0, new Color(0, 0, 0));
        this.fontName = string;
    }

    public RtfFont(String string, float f, int n) {
        super(-1, f, n, new Color(0, 0, 0));
        this.fontName = string;
    }

    public RtfFont(String string, float f, int n, Color color) {
        super(-1, f, n, color);
        this.fontName = string;
    }

    protected RtfFont(RtfDocument rtfDocument, int n) {
        this.document = rtfDocument;
        this.fontNumber = n;
        this.color = new RtfColor(rtfDocument, 0, 0, 0);
    }

    public RtfFont(RtfDocument rtfDocument, Font font) {
        this.document = rtfDocument;
        if (font instanceof RtfFont) {
            this.fontName = ((RtfFont)font).getFontName();
        } else {
            switch (Font.getFamilyIndex(font.getFamilyname())) {
                case 0: {
                    this.fontName = "Courier";
                    break;
                }
                case 1: {
                    this.fontName = "Arial";
                    break;
                }
                case 3: {
                    this.fontName = "Symbol";
                    this.charset = 2;
                    break;
                }
                case 2: {
                    this.fontName = "Times New Roman";
                    break;
                }
                case 4: {
                    this.fontName = "Windings";
                    break;
                }
                default: {
                    this.fontName = font.getFamilyname();
                }
            }
        }
        if (font.getBaseFont() != null) {
            String[][] stringArray = font.getBaseFont().getFullFontName();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i][2].equals("0")) {
                    this.fontName = stringArray[i][3];
                    break;
                }
                if (!stringArray[i][2].equals("1033") && !stringArray[i][2].equals("")) continue;
                this.fontName = stringArray[i][3];
            }
        }
        if (this.fontName.equalsIgnoreCase("unknown")) {
            this.color = new RtfColor(rtfDocument, 0, 0, 0);
            return;
        }
        this.fontSize = (int)font.size();
        if (font.isBold()) {
            this.fontStyle |= 2;
        }
        if (font.isItalic()) {
            this.fontStyle |= 1;
        }
        if (font.isUnderlined()) {
            this.fontStyle |= 4;
        }
        if (font.isStrikethru()) {
            this.fontStyle |= 8;
        }
        if (this.document != null) {
            this.fontNumber = this.document.getDocumentHeader().getFontNumber(this);
        }
        this.color = new RtfColor(rtfDocument, font.color());
    }

    public byte[] writeDefinition() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(FONT_FAMILY);
            byteArrayOutputStream.write(FONT_CHARSET);
            byteArrayOutputStream.write(this.intToByteArray(this.charset));
            byteArrayOutputStream.write(RtfBasicElement.DELIMITER);
            byteArrayOutputStream.write(this.document.filterSpecialChar(this.fontName, true, false).getBytes());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] writeBegin() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(RtfFontList.FONT_NUMBER);
            byteArrayOutputStream.write(this.intToByteArray(this.fontNumber));
            byteArrayOutputStream.write(FONT_SIZE);
            byteArrayOutputStream.write(this.intToByteArray(this.fontSize * 2));
            if ((this.fontStyle & 2) == 2) {
                byteArrayOutputStream.write(FONT_BOLD);
            }
            if ((this.fontStyle & 1) == 1) {
                byteArrayOutputStream.write(FONT_ITALIC);
            }
            if ((this.fontStyle & 4) == 4) {
                byteArrayOutputStream.write(FONT_UNDERLINE);
            }
            if ((this.fontStyle & 8) == 8) {
                byteArrayOutputStream.write(FONT_STRIKETHROUGH);
            }
            byteArrayOutputStream.write(this.color.writeBegin());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] writeEnd() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            if ((this.fontStyle & 2) == 2) {
                byteArrayOutputStream.write(FONT_BOLD);
                byteArrayOutputStream.write(this.intToByteArray(0));
            }
            if ((this.fontStyle & 1) == 1) {
                byteArrayOutputStream.write(FONT_ITALIC);
                byteArrayOutputStream.write(this.intToByteArray(0));
            }
            if ((this.fontStyle & 4) == 4) {
                byteArrayOutputStream.write(FONT_UNDERLINE);
                byteArrayOutputStream.write(this.intToByteArray(0));
            }
            if ((this.fontStyle & 8) == 8) {
                byteArrayOutputStream.write(FONT_STRIKETHROUGH);
                byteArrayOutputStream.write(this.intToByteArray(0));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] write() {
        return new byte[0];
    }

    public boolean equals(Object object) {
        if (!(object instanceof RtfFont)) {
            return false;
        }
        RtfFont rtfFont = (RtfFont)object;
        boolean bl = true;
        bl &= this.fontName.equals(rtfFont.getFontName());
        bl &= this.fontSize == rtfFont.getFontSize();
        return bl &= this.fontStyle == rtfFont.getFontStyle();
    }

    public int hashCode() {
        return (this.fontName + this.fontSize + "-" + this.fontStyle).hashCode();
    }

    public String getFontName() {
        return this.fontName;
    }

    public String getFamilyname() {
        return this.fontName;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public int getFontNumber() {
        return this.fontNumber;
    }

    public void setRtfDocument(RtfDocument rtfDocument) {
        this.document = rtfDocument;
        if (this.document != null) {
            this.fontNumber = this.document.getDocumentHeader().getFontNumber(this);
        }
        this.color.setRtfDocument(this.document);
    }

    public void setInTable(boolean bl) {
    }

    public void setInHeader(boolean bl) {
    }

    private byte[] intToByteArray(int n) {
        return Integer.toString(n).getBytes();
    }

    public Font difference(Font font) {
        float f;
        String string = font.getFamilyname();
        if (string == null || string.trim().equals("") || string.trim().equalsIgnoreCase("unknown")) {
            string = this.fontName;
        }
        if ((f = font.size()) == -1.0f) {
            f = this.size();
        }
        int n = -1;
        if (this.style() != -1 && font.style() != -1) {
            n = this.style() | font.style();
        } else if (this.style() != -1) {
            n = this.style();
        } else if (font.style() != -1) {
            n = font.style();
        }
        Color color = font.color();
        if (color == null) {
            color = this.color();
        }
        return new RtfFont(string, f, n, color);
    }
}

