/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.codec.TiffImage;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.ImageFilter;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class Tiff2Pdf
extends AbstractTool {
    public Tiff2Pdf() {
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to convert", false, new ImageFilter(false, false, false, false, false, true)));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the converted TIFF has to be written", true, new PdfFilter()));
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Tiff2Pdf", true, true, true);
        this.internalFrame.setSize(550, 250);
        this.internalFrame.setJMenuBar(this.getMenubar());
        this.internalFrame.getContentPane().add(this.getConsole(40, 30));
    }

    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File file = (File)this.getValue("srcfile");
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            File file2 = (File)this.getValue("destfile");
            Document document = new Document();
            PdfWriter pdfWriter = PdfWriter.getInstance(document, new FileOutputStream(file2));
            int n = 0;
            document.open();
            PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
            RandomAccessFileOrArray randomAccessFileOrArray = null;
            int n2 = 0;
            randomAccessFileOrArray = new RandomAccessFileOrArray(file.getAbsolutePath());
            n2 = TiffImage.getNumberOfPages(randomAccessFileOrArray);
            for (int i = 0; i < n2; ++i) {
                Image image = TiffImage.getTiffImage(randomAccessFileOrArray, i + 1);
                if (image == null) continue;
                if (image.scaledWidth() > 500.0f || image.scaledHeight() > 700.0f) {
                    image.scaleToFit(500.0f, 700.0f);
                }
                image.setAbsolutePosition(20.0f, 20.0f);
                document.add(new Paragraph(file + " - page " + (i + 1)));
                pdfContentByte.addImage(image);
                System.out.println("Finished page " + (i + 1));
                document.newPage();
                ++n;
            }
            randomAccessFileOrArray.close();
            document.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.internalFrame, exception.getMessage(), exception.getClass().getName(), 0);
            System.err.println(exception.getMessage());
        }
    }

    public void valueHasChanged(ToolArgument toolArgument) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        Tiff2Pdf tiff2Pdf = new Tiff2Pdf();
        if (stringArray.length < 2) {
            System.err.println(tiff2Pdf.getUsage());
        }
        tiff2Pdf.setArguments(stringArray);
        tiff2Pdf.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }
}

