/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.align;

import cgdp.recog.align.GlobalAlignRenderer;
import cgdp.recog.align.GlobalAlignViewModel;
import cgdp.recog.process.ThreadCancelListener;
import cgdp.recog.util.AbstractPrintable;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;

public class GlobalAlignPrintable
extends AbstractPrintable {
    private GlobalAlignViewModel globalAlignViewModel;

    public GlobalAlignPrintable(PageFormat pageFormat, GlobalAlignViewModel globalAlignViewModel) {
        this.setPageFormat(pageFormat);
        this.setPageCount(1);
        this.globalAlignViewModel = globalAlignViewModel;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        GlobalAlignRenderer globalAlignRenderer = this.globalAlignViewModel.getGlobalAlignRenderer();
        globalAlignRenderer = (GlobalAlignRenderer)globalAlignRenderer.clone();
        double d = this.getZoomScale(this.globalAlignViewModel, globalAlignRenderer.getDrawWidth(), globalAlignRenderer.getDrawHeight());
        Graphics2D graphics2D = (Graphics2D)graphics;
        globalAlignRenderer.beforeDraw(graphics2D, 1.0);
        graphics2D.scale(d, d);
        graphics2D.translate(this.getPageFormat().getImageableX() / d, this.getPageFormat().getImageableY() / d);
        Shape shape = graphics2D.getClip();
        graphics2D.translate(globalAlignRenderer.getAlignStartX(), 0.0);
        globalAlignRenderer.draw(graphics2D, new NoActionThreadCancelListener());
        graphics2D.translate(-globalAlignRenderer.getAlignStartX(), 0.0);
        graphics2D.setClip(shape);
        globalAlignRenderer.drawFrame(graphics2D);
        graphics2D.translate(-this.getPageFormat().getImageableX() / d, -this.getPageFormat().getImageableY() / d);
        return 0;
    }

    private double getZoomScale(GlobalAlignViewModel globalAlignViewModel, double d, double d2) {
        if (this.globalAlignViewModel.isPrintZoomAuto()) {
            return this.calcZoomScaleForPageFit(d, d2);
        }
        return this.globalAlignViewModel.getPrintZoomSpecValue();
    }

    private double calcZoomScaleForPageFit(double d, double d2) {
        double d3 = 1.0;
        double d4 = this.getImageableWidth() / d;
        double d5 = this.getImageableHeight() / d2;
        if (d4 < 1.0 && d5 < 1.0) {
            d3 = Math.min(d4, d5);
        } else if (d4 < 1.0) {
            d3 = d4;
        } else if (d5 < 1.0) {
            d3 = d5;
        }
        return d3;
    }

    private class NoActionThreadCancelListener
    implements ThreadCancelListener {
        private NoActionThreadCancelListener() {
        }

        public void cancel() {
        }

        public boolean isCancel() {
            return false;
        }
    }
}

