/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.align;

import cgdp.recog.align.GlobalAlign;
import cgdp.recog.align.GlobalAlignGenerater;
import cgdp.recog.align.GlobalAlignViewModel;
import cgdp.recog.bean.MainWindow;
import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.color.ColorFacade;
import cgdp.recog.coregenome.CoreGenomeViewModel;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.organism.OrganismViewModel;
import cgdp.recog.process.ProcessImpl;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class GlobalAlignmentCommand
implements ProcessImpl {
    private static final ApplicationLogger logger = new ApplicationLogger(GlobalAlignmentCommand.class);
    protected MediatorImpl mediator;
    protected MainWindow mainWindow;
    private boolean error = false;
    private String errorMessage;
    private ClusterTbl clusterTbl;
    private CoreGenomeViewModel coreGenomeViewModel;

    public GlobalAlignmentCommand(MediatorImpl mediatorImpl, MainWindow mainWindow, ClusterTbl clusterTbl, CoreGenomeViewModel coreGenomeViewModel) {
        this.mediator = mediatorImpl;
        this.mainWindow = mainWindow;
        this.clusterTbl = clusterTbl;
        this.coreGenomeViewModel = coreGenomeViewModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ProgressImpl progressImpl) {
        try {
            GlobalAlignGenerater globalAlignGenerater = new GlobalAlignGenerater();
            globalAlignGenerater.setClusterTbl(this.clusterTbl);
            globalAlignGenerater.setGenomeAlign(this.coreGenomeViewModel.getGenomeAlign());
            globalAlignGenerater.setOrganismList(this.coreGenomeViewModel.getOrganismList());
            globalAlignGenerater.setProgressImpl(progressImpl);
            globalAlignGenerater.execute();
            if (progressImpl.isCanceled()) {
                return;
            }
            GlobalAlign globalAlign = globalAlignGenerater.getGlobalAlign();
            final GlobalAlignViewModel globalAlignViewModel = this.createGlobalAlignViewModel(globalAlign);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GlobalAlignmentCommand.this.mediator.showGlobalAlignFrame(globalAlignViewModel);
                }
            });
        }
        catch (Exception exception) {
            String string = "Fail to show global alignment.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.mainWindow, string);
        }
        finally {
            this.mediator.updateMemory();
        }
    }

    private GlobalAlignViewModel createGlobalAlignViewModel(GlobalAlign globalAlign) {
        GlobalAlignViewModel globalAlignViewModel = new GlobalAlignViewModel();
        ApplicationPropertyFacade.updateDomClustAccessable(this.clusterTbl.getClusterId(), globalAlignViewModel);
        globalAlignViewModel.setDomClustId(this.clusterTbl.getClusterId());
        globalAlignViewModel.setReferenceOrganism(this.coreGenomeViewModel.getReferenceOrganism());
        globalAlignViewModel.setGlobalAlign(globalAlign);
        globalAlignViewModel.setViewOrganismList(new ArrayList(this.coreGenomeViewModel.getViewOrganismList()));
        globalAlignViewModel.processAfterUpdateOrganism();
        OrganismViewModel organismViewModel = globalAlignViewModel.getOrganismViewModel();
        organismViewModel.setAddStrainToName(this.coreGenomeViewModel.isAddStrainToName());
        organismViewModel.setOrganismNameType(this.coreGenomeViewModel.getOrganismNameType());
        globalAlignViewModel.initGlobalAlignViewModel();
        ColorFacade.getInstance().setAlignmentViewModel(globalAlignViewModel);
        return globalAlignViewModel;
    }

    public void done() {
    }

    public String getProgressMessages() {
        return "Create global align...";
    }
}

