/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.bean;

import cgdp.recog.bean.ClusterListTableModel;
import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.ClusterUtil;
import cgdp.recog.funccat.FunctionCategoryColorCellRenderer;
import cgdp.recog.info.gene.GeneInfoUtil;
import cgdp.recog.mgmap.AlignmentItem;
import cgdp.recog.multiplealign.MultipleAlignmentItem;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.system.OS;
import cgdp.recog.url.GeneUrlFacade;
import cgdp.recog.util.CollectionUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

public class ClusterList
extends JPanel
implements MouseListener,
ActionListener {
    private static final int[] COLUMN_WIDTHS = new int[]{35, 35, 80};
    private MediatorImpl m_mediatorImpl;
    private OptionTbl m_optionTbl;
    private ClusterTbl m_clusterTbl;
    private List m_clusterList;
    private JTable m_table;
    private JScrollPane scrollPane;
    private JTextArea clusterDescriptionArea;

    public ClusterList(MediatorImpl mediatorImpl) {
        this.m_mediatorImpl = mediatorImpl;
        this.m_mediatorImpl.register(this);
        this.m_optionTbl = OptionTbl.getInstance();
        this.init();
    }

    private void init() {
        this.setBorder(null);
        this.setPreferredSize(new Dimension(300, 200));
        this.setMinimumSize(new Dimension(150, 100));
        this.m_table = new JTable(new ClusterListTableModel()){

            public String getToolTipText(MouseEvent mouseEvent) {
                int n = ClusterList.this.m_table.rowAtPoint(mouseEvent.getPoint());
                int n2 = ClusterList.this.m_table.columnAtPoint(mouseEvent.getPoint());
                if (n != -1 && n2 != -1) {
                    Cluster cluster = (Cluster)ClusterList.this.m_clusterList.get(n);
                    return ClusterList.this.createToolTipText(cluster);
                }
                return null;
            }

            public Point getToolTipLocation(MouseEvent mouseEvent) {
                return new Point(mouseEvent.getX(), mouseEvent.getY() + 20);
            }
        };
        this.m_table.addMouseListener(this);
        this.m_table.setRowHeight(20);
        this.m_table.setToolTipText("");
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ClusterList.this.updateClusterDescriptionArea();
            }
        };
        this.m_table.getSelectionModel().addListSelectionListener(listSelectionListener);
        TableColumn tableColumn = this.m_table.getColumnModel().getColumn(2);
        tableColumn.setCellRenderer(new FunctionCategoryColorCellRenderer(true));
        Enumeration<TableColumn> enumeration = this.m_table.getColumnModel().getColumns();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn2 = enumeration.nextElement();
            tableColumn2.setPreferredWidth(COLUMN_WIDTHS[n]);
            ++n;
        }
        this.scrollPane = new JScrollPane(this.m_table, 20, 31);
        this.scrollPane.setViewportView(this.m_table);
        this.clusterDescriptionArea = this.createClusterDescriptionArea();
        this.setLayout(new GridBagLayout());
        this.add((Component)this.clusterDescriptionArea, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setClusterTbl(ClusterTbl clusterTbl) {
        this.m_clusterTbl = clusterTbl;
        if (clusterTbl != null) {
            ClusterListTableModel clusterListTableModel = (ClusterListTableModel)this.m_table.getModel();
            clusterListTableModel.setClusterList(new ArrayList(), clusterTbl.isOutgroup());
        }
    }

    public boolean createClusterList(String string, Collection collection) {
        if (this.m_clusterTbl == null) {
            return false;
        }
        ArrayList arrayList = new ArrayList(collection);
        if (!CollectionUtil.isNull(this.m_clusterList) && this.m_clusterList.equals(arrayList)) {
            this.m_table.selectAll();
            return false;
        }
        ClusterListTableModel clusterListTableModel = (ClusterListTableModel)this.m_table.getModel();
        clusterListTableModel.setClusterList(arrayList);
        this.m_clusterList = arrayList;
        this.m_table.selectAll();
        return true;
    }

    private JTextArea createClusterDescriptionArea() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setFocusable(false);
        jTextArea.setOpaque(false);
        jTextArea.setCaretPosition(0);
        return jTextArea;
    }

    private void updateClusterDescriptionArea() {
        Cluster cluster = this.getSelectedCluster();
        if (cluster == null) {
            return;
        }
        this.clusterDescriptionArea.setText(cluster.getDescription());
        this.clusterDescriptionArea.setCaretPosition(0);
        this.clusterDescriptionArea.setToolTipText(cluster.getDescription());
    }

    private String createToolTipText(Cluster cluster) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<HTML>");
        stringBuffer.append("Cluster ID:");
        stringBuffer.append(cluster.getDisplayClusterId());
        stringBuffer.append("<BR>");
        stringBuffer.append("Gene Name:");
        stringBuffer.append(ClusterUtil.getGeneName(cluster, this.m_clusterTbl.isOutgroup()));
        stringBuffer.append("<BR>");
        stringBuffer.append("Function Category:");
        stringBuffer.append(ClusterUtil.getFunctionCategoryName(cluster, this.m_clusterTbl.isOutgroup()));
        stringBuffer.append("<BR>");
        stringBuffer.append("Description:<BR>");
        stringBuffer.append(ClusterUtil.getDescription(cluster, this.m_clusterTbl.isOutgroup()));
        stringBuffer.append("</HTML>");
        return stringBuffer.toString();
    }

    public void clearClusterList() {
        this.m_clusterList = null;
        if (this.m_clusterList != null) {
            this.getClusterListTableModel().setClusterList(new ArrayList(), this.m_clusterTbl.isOutgroup());
        } else {
            this.getClusterListTableModel().setClusterList(new ArrayList());
        }
    }

    private ClusterListTableModel getClusterListTableModel() {
        return (ClusterListTableModel)this.m_table.getModel();
    }

    public Cluster getSelectedCluster() {
        int n = this.m_table.getSelectedRow();
        return n != -1 ? (Cluster)this.m_clusterList.get(n) : null;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            List list = this.getSelectedClusterList();
            if (list.size() == 0) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            for (Cluster cluster : list) {
                if (!bl) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(cluster.getDisplayClusterId());
                bl = false;
            }
            String string = GeneUrlFacade.getClusterInfoUrl(this.m_clusterTbl.getClusterId(), String.valueOf(stringBuffer));
            this.m_mediatorImpl.viewUrl(string);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!OS.isWindows()) {
            this.showPopupMenu(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (OS.isWindows()) {
            this.showPopupMenu(mouseEvent);
        }
    }

    public List getSelectedClusterList() {
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        int[] nArray = this.m_table.getSelectedRows();
        if (nArray.length == 0) {
            return arrayList;
        }
        for (int i = 0; i < nArray.length; ++i) {
            Cluster cluster = (Cluster)this.m_clusterList.get(nArray[i]);
            arrayList.add(cluster);
        }
        return arrayList;
    }

    private void showPopupMenu(MouseEvent mouseEvent) {
        int n = this.m_table.rowAtPoint(mouseEvent.getPoint());
        if (n != -1) {
            List list = this.getSelectedClusterList();
            if (mouseEvent.isPopupTrigger()) {
                if (!this.m_optionTbl.getOptionValues().isIntensive()) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    ClusterList.showClusterMenu(this, this.m_mediatorImpl, jPopupMenu, list);
                    jPopupMenu.show(this.m_table, mouseEvent.getX(), mouseEvent.getY());
                }
                return;
            }
            this.m_mediatorImpl.createGeneNameList(null, new HashSet(list), true);
        }
    }

    public static void showClusterMenu(ActionListener actionListener, MediatorImpl mediatorImpl, JPopupMenu jPopupMenu, List list) {
        List list2 = GeneInfoUtil.createGeneInfoListByClusterList(list);
        if (OptionTbl.getInstance().getOptionValues().isShowHiddenMenu()) {
            jPopupMenu.add(new AlignmentItem(actionListener, mediatorImpl, list2));
        }
        if (OptionTbl.getInstance().getOptionValues().isShowHiddenMenu() && list2.size() > 1) {
            jPopupMenu.add(new MultipleAlignmentItem(actionListener, mediatorImpl, list2));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ((CommandImpl)actionEvent.getSource()).execute();
    }
}

