/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.bean;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoDetailTableModel;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.util.StringTool;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class GeneInfoList
extends JScrollPane {
    private MediatorImpl mediator;
    private JTable geneInfoTable;

    public GeneInfoList(MediatorImpl mediatorImpl) {
        this.mediator = mediatorImpl;
        this.mediator.register(this);
        this.createComponents();
    }

    private void createComponents() {
        this.setBorder(null);
        this.setPreferredSize(new Dimension(300, 146));
        this.setMinimumSize(new Dimension(150, 100));
        this.geneInfoTable = new JTable(new GeneInfoDetailTableModel());
        this.geneInfoTable.setSelectionMode(2);
        this.geneInfoTable.setRowHeight(20);
        int[] nArray = new int[]{40, 180};
        Enumeration<TableColumn> enumeration = this.geneInfoTable.getColumnModel().getColumns();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setPreferredWidth(nArray[n]);
            ++n;
        }
        this.setViewportView(this.geneInfoTable);
    }

    private GeneInfoDetailTableModel getGeneInfoDetailTableModel() {
        return (GeneInfoDetailTableModel)this.geneInfoTable.getModel();
    }

    public void createGeneInfoList(List list, GeneInfo geneInfo) {
        if (geneInfo == null) {
            this.clearGeneInfoList();
            return;
        }
        String string = (String)geneInfo.getInfo(GeneInfoTitle.TITLE_ORGANISM_CODE);
        if (StringTool.isNull(string)) {
            this.clearGeneInfoList();
            return;
        }
        GeneInfoDetailTableModel geneInfoDetailTableModel = this.getGeneInfoDetailTableModel();
        geneInfoDetailTableModel.setGeneInfo(list, geneInfo);
    }

    public void clearGeneInfoList() {
        this.getGeneInfoDetailTableModel().clearGeneInfo();
    }
}

