/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.calc;

import cgdp.recog.calc.CalcCondition;
import cgdp.recog.calc.CoefType;
import cgdp.recog.data.Cluster;
import cgdp.recog.info.AbstractInfo;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.AbstractMultiValueCondition;
import cgdp.recog.info.cell.CellInfo;
import cgdp.recog.info.cell.CellInfoFacade;
import cgdp.recog.info.cell.CellInfoTitle;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.MapUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractCalcCondition
extends AbstractMultiValueCondition
implements CalcCondition {
    private int profile = 1;
    private AbstractInfoTitle infoTitle;
    private Map organismGeneInfoMap = new HashMap();
    private Map organismCellInfoMap = new HashMap();
    private int distType;

    public int getProfile() {
        return this.profile;
    }

    public void setProfile(int n) {
        this.profile = n;
    }

    public boolean isPattern() {
        return AbstractCalcCondition.isPattern(this.getProfile());
    }

    public static boolean isPattern(int n) {
        return CoefType.isPattern(n);
    }

    public boolean isGeneProperty() {
        return CoefType.isGeneProperty(this.getProfile());
    }

    public void setInfoTitle(AbstractInfoTitle abstractInfoTitle) {
        this.infoTitle = abstractInfoTitle;
    }

    public int getDistType() {
        return this.distType;
    }

    public String getDistName() {
        return CoefType.getTypeDistanceKey2NameForHClust(this.getDistType());
    }

    public void setDistType(int n) {
        this.distType = n;
    }

    public void setGeneInfoMap(String string, Map map) {
        this.organismGeneInfoMap.put(string, map);
    }

    public Map getGeneInfoMap(String string) {
        return (Map)this.organismGeneInfoMap.get(string);
    }

    public void setOrganismCellInfoMap(Map map) {
        this.organismCellInfoMap = map;
    }

    private Map getOrganismCellInfoMap() {
        return this.organismCellInfoMap;
    }

    public Map getCellInfoMap(String string) {
        return (Map)this.getOrganismCellInfoMap().get(string);
    }

    public void setCellInfoMap(String string, Map map) {
        this.organismCellInfoMap.put(string, map);
    }

    public CellInfo getCellInfo(String string, Cluster cluster) {
        Map map = this.getCellInfoMap(string);
        if (MapUtil.isNull(map)) {
            return null;
        }
        CellInfo cellInfo = (CellInfo)map.get(cluster);
        if (cellInfo == null) {
            return null;
        }
        return cellInfo;
    }

    public boolean containsOrganismInCellInfo(String string, Cluster cluster) {
        CellInfo cellInfo = this.getCellInfo(string, cluster);
        if (cellInfo == null) {
            return false;
        }
        return cellInfo.containsTitle(this.getInfoTitle());
    }

    public GeneInfo getGeneInfo(String string, String string2) {
        Map map = this.getGeneInfoMap(string);
        if (MapUtil.isNull(map)) {
            return null;
        }
        GeneInfo geneInfo = (GeneInfo)map.get(string2);
        return geneInfo;
    }

    public boolean containsLocusTag(String string, String string2) {
        GeneInfo geneInfo = this.getGeneInfo(string, string2);
        if (geneInfo == null) {
            return false;
        }
        return geneInfo.containsTitle(this.getInfoTitle());
    }

    public List getGeneInfoValue(String string, String string2) {
        GeneInfo geneInfo = this.getGeneInfo(string, string2);
        if (geneInfo == null) {
            return new ArrayList();
        }
        return this.getValueList(geneInfo);
    }

    public List getCellInfoValue(String string, Cluster cluster) {
        CellInfo cellInfo = this.getCellInfo(string, cluster);
        if (cellInfo == null) {
            return null;
        }
        return this.getValueList(cellInfo);
    }

    public List getInfoValueList(String string, Cluster cluster) {
        List list = new ArrayList();
        if (this.isGene()) {
            List list2 = cluster.getLocusTagWithoutDomainList(string);
            if (!CollectionUtil.isNull(list2)) {
                for (String string2 : list2) {
                    list.addAll(this.getGeneInfoValue(string, string2));
                }
            }
        } else if (this.isCell()) {
            CellInfo cellInfo = this.getCellInfo(string, cluster);
            if (cellInfo == null) {
                return null;
            }
            list = this.getValueList(cellInfo);
        }
        return list;
    }

    private List getValueList(AbstractInfo abstractInfo) {
        List<Object> list;
        if (this.getInfoTitle().isMulti()) {
            list = abstractInfo.getMultiInfo(this.getInfoTitle());
        } else {
            list = new ArrayList();
            list.add(abstractInfo.getInfo(this.getInfoTitle()));
        }
        return list;
    }

    public void setGeneInfoValue(String string, String string2, double d) {
        GeneInfo geneInfo;
        HashMap<String, GeneInfo> hashMap = this.getGeneInfoMap(string);
        if (MapUtil.isNull(hashMap)) {
            hashMap = new HashMap<String, GeneInfo>();
            this.organismGeneInfoMap.put(string, hashMap);
        }
        if ((geneInfo = (GeneInfo)hashMap.get(string2)) == null) {
            geneInfo = new GeneInfo();
            hashMap.put(string2, geneInfo);
        }
        geneInfo.putInfo(this.getInfoTitle(), new Float(d));
    }

    public void setCellInfoValue(String string, Cluster cluster, double d) {
        CellInfo cellInfo;
        HashMap<Cluster, CellInfo> hashMap = this.getCellInfoMap(string);
        if (MapUtil.isNull(hashMap)) {
            hashMap = new HashMap<Cluster, CellInfo>();
            this.organismCellInfoMap.put(string, hashMap);
        }
        if ((cellInfo = (CellInfo)hashMap.get(cluster)) == null) {
            cellInfo = new CellInfo();
            hashMap.put(cluster, cellInfo);
        }
        cellInfo.putInfo(this.getInfoTitle(), new Float(d));
    }

    public AbstractInfoTitle getInfoTitle() {
        return this.infoTitle;
    }

    public boolean isGene() {
        return this.infoTitle.isGene();
    }

    public boolean isCell() {
        return this.infoTitle.isCell();
    }

    public int indexOfElement(Object object) {
        return this.getInfoTitle().indexOfElement(object);
    }

    public boolean isAsc() {
        return true;
    }

    public void loadInfo(String string, List list) throws Exception {
        if (!this.isGeneProperty()) {
            return;
        }
        if (this.isGene()) {
            Map map = GeneInfoFacade.createGeneInfoMap(list, string, this.getInfoTitle());
            this.setGeneInfoMap(string, map);
        } else if (this.isCell()) {
            Map map = CellInfoFacade.createClusterCellInfoMap(string, list, (CellInfoTitle)this.getInfoTitle());
            this.setCellInfoMap(string, map);
        }
    }
}

