/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.calc;

import cgdp.recog.calc.AbstractCalculater;
import cgdp.recog.calc.CalculateType;
import cgdp.recog.calc.Calculater;
import cgdp.recog.util.CollectionUtil;
import java.util.List;

public class CalculaterFactory {
    public static Calculater createCalculater(int n) {
        AbstractCalculater abstractCalculater = null;
        if (CalculateType.isSum(n)) {
            abstractCalculater = new SumCalculater();
        } else if (CalculateType.isMean(n)) {
            abstractCalculater = new MeanCalculater();
        } else if (CalculateType.isMedian(n)) {
            abstractCalculater = new MedianCalculater();
        } else if (CalculateType.isVariance(n)) {
            abstractCalculater = new VarianceCalculater();
        } else if (CalculateType.isMaxValDiff(n)) {
            abstractCalculater = new MaxValDiffCalculater();
        }
        return abstractCalculater;
    }

    private static class MaxValDiffCalculater
    extends AbstractCalculater {
        private MaxValDiffCalculater() {
        }

        public double calculate() {
            double d = 0.0;
            List list = CollectionUtil.removeNaNInfinity(this.getValueList());
            for (int i = 0; i < list.size(); ++i) {
                double d2 = ((Number)list.get(i)).doubleValue();
                for (int j = i + 1; j < list.size(); ++j) {
                    double d3 = ((Number)list.get(j)).doubleValue();
                    d = Math.max(d, Math.abs(d3 - d2));
                }
            }
            return d;
        }
    }

    private static class VarianceCalculater
    extends AbstractCalculater {
        private VarianceCalculater() {
        }

        public double calculate() {
            return CollectionUtil.variance(this.getValueList());
        }
    }

    private static class MedianCalculater
    extends AbstractCalculater {
        private MedianCalculater() {
        }

        public double calculate() {
            Number number = (Number)CollectionUtil.median(this.getValueList());
            if (number == null) {
                return Double.NaN;
            }
            return number.doubleValue();
        }
    }

    private static class MeanCalculater
    extends AbstractCalculater {
        private MeanCalculater() {
        }

        public double calculate() {
            return CollectionUtil.average(this.getValueList());
        }
    }

    private static class SumCalculater
    extends AbstractCalculater {
        private SumCalculater() {
        }

        public double calculate() {
            return CollectionUtil.sum(this.getValueList());
        }
    }
}

