/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.calc;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.calc.CoefCondition;
import cgdp.recog.calc.ProfilePanel;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.InfoUtil;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.FocusTextField;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CoefDialog
extends AbstractApplyDialog {
    private static CoefDialog COEF_DIALOG;
    private static final String TITLE = "Calculate distance by pattern";
    private MediatorImpl mediator;
    private FocusTextField nameTextField;
    private ProfilePanel profilePanel;
    private JCheckBox sortCheckBox;
    private JCheckBox saveCheckBox;

    private CoefDialog(Frame frame, MediatorImpl mediatorImpl) {
        super(frame);
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    public static void createInstance(Frame frame, MediatorImpl mediatorImpl) {
        COEF_DIALOG = new CoefDialog(frame, mediatorImpl);
    }

    public static CoefDialog getInstance() {
        return COEF_DIALOG;
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(false);
        this.profilePanel = new ProfilePanel(this);
        this.sortCheckBox = new JCheckBox("Sort by the caluculated result");
        this.sortCheckBox.setSelected(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.getButtonPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 5, 10), 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.createNamePane(), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
        this.getContentPane().add((Component)this.profilePanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
        this.getContentPane().add((Component)this.sortCheckBox, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 15, 5, 15), 0, 0));
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 5, 10), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel createNamePane() {
        JLabel jLabel = new JLabel("Name");
        this.nameTextField = new FocusTextField();
        this.saveCheckBox = new JCheckBox("Save");
        this.saveCheckBox.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.nameTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)this.saveCheckBox, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        return jPanel;
    }

    public void updateValue(String string, Set set) {
        String string2 = this.getDefaultName(string);
        this.nameTextField.setText(string2);
        this.profilePanel.updateValue(set);
        this.setEnableName();
        this.pack();
    }

    private String getDefaultName(String string) {
        String string2 = string;
        List list = ClusterInfoFacade.getInfoTitleList();
        Set set = InfoUtil.getInfoTitleNameSet(list);
        int n = 1;
        while (set.contains(string2)) {
            string2 = string + " " + n;
            ++n;
        }
        return string2;
    }

    private void setEnableName() {
        this.nameTextField.setEnabled(this.saveCheckBox.isSelected());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.saveCheckBox) {
            this.setEnableName();
        }
    }

    private String getCoefName() {
        return this.nameTextField.getText();
    }

    private int getProfile() {
        return this.profilePanel.getProfile();
    }

    private AbstractInfoTitle getInfoTitle() {
        return this.profilePanel.getInfoTitle();
    }

    private int getDistType() {
        return this.profilePanel.getDistTypeForHClust();
    }

    private boolean isSave() {
        return this.saveCheckBox.isSelected();
    }

    private boolean isSort() {
        return this.sortCheckBox.isSelected();
    }

    public CoefCondition createCoefCondition() {
        CoefCondition coefCondition = CoefCondition.createCoefCondition(this.getCoefName(), this.getProfile(), this.getInfoTitle(), this.getDistType(), true, this.isSave(), this.isSort());
        return coefCondition;
    }

    protected boolean check() {
        if (this.isSave()) {
            if (StringTool.isNull(this.getCoefName())) {
                String string = "Input name.";
                MessageManager.showErrorMessage((Component)this, string);
                return false;
            }
            ClusterInfoTitle clusterInfoTitle = this.createCoefCondition().createClusterInfoTitle();
            List list = ClusterInfoFacade.getInfoTitleList();
            if (list.contains(clusterInfoTitle)) {
                Object[] objectArray = new String[]{"You have already calculated the  [" + this.getCoefName() + "].", "Input the another name."};
                MessageManager.showConfirmMessage((Component)this, objectArray);
                return false;
            }
        }
        return true;
    }

    protected boolean apply() {
        return true;
    }
}

